(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_filesystem_lib_browser_file-dialog_index_js"],{

/***/ "./node_modules/@theia/core/shared/@phosphor/widgets/index.js":
/*!********************************************************************!*\
  !*** ./node_modules/@theia/core/shared/@phosphor/widgets/index.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! @phosphor/widgets */ "./node_modules/@phosphor/widgets/lib/index.js");


/***/ }),

/***/ "./node_modules/@theia/core/shared/lodash.throttle/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/@theia/core/shared/lodash.throttle/index.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! lodash.throttle */ "./node_modules/lodash.throttle/index.js");


/***/ }),

/***/ "./node_modules/@theia/core/shared/react-dom/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@theia/core/shared/react-dom/index.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");


/***/ }),

/***/ "./node_modules/@theia/core/shared/react/index.js":
/*!********************************************************!*\
  !*** ./node_modules/@theia/core/shared/react/index.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! react */ "./node_modules/react/index.js");


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-container.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-container.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createSaveFileDialogContainer = exports.createOpenFileDialogContainer = exports.createFileDialogContainer = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const file_tree_1 = __webpack_require__(/*! ../file-tree */ "./node_modules/@theia/filesystem/lib/browser/file-tree/index.js");
const file_dialog_1 = __webpack_require__(/*! ./file-dialog */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog.js");
const file_dialog_model_1 = __webpack_require__(/*! ./file-dialog-model */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-model.js");
const file_dialog_widget_1 = __webpack_require__(/*! ./file-dialog-widget */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-widget.js");
const file_dialog_tree_1 = __webpack_require__(/*! ./file-dialog-tree */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-tree.js");
function createFileDialogContainer(parent) {
    const child = file_tree_1.createFileTreeContainer(parent);
    child.unbind(file_tree_1.FileTreeModel);
    child.bind(file_dialog_model_1.FileDialogModel).toSelf();
    child.rebind(browser_1.TreeModel).toService(file_dialog_model_1.FileDialogModel);
    child.unbind(file_tree_1.FileTreeWidget);
    child.bind(file_dialog_widget_1.FileDialogWidget).toSelf();
    child.bind(file_dialog_tree_1.FileDialogTree).toSelf();
    child.rebind(browser_1.Tree).toService(file_dialog_tree_1.FileDialogTree);
    return child;
}
exports.createFileDialogContainer = createFileDialogContainer;
function createOpenFileDialogContainer(parent, props) {
    const container = createFileDialogContainer(parent);
    container.rebind(browser_1.TreeProps).toConstantValue(Object.assign(Object.assign({}, browser_1.defaultTreeProps), { multiSelect: props.canSelectMany, search: true }));
    container.bind(file_dialog_1.OpenFileDialogProps).toConstantValue(props);
    container.bind(file_dialog_1.OpenFileDialog).toSelf();
    return container;
}
exports.createOpenFileDialogContainer = createOpenFileDialogContainer;
function createSaveFileDialogContainer(parent, props) {
    const container = createFileDialogContainer(parent);
    container.rebind(browser_1.TreeProps).toConstantValue(Object.assign(Object.assign({}, browser_1.defaultTreeProps), { multiSelect: false, search: true }));
    container.bind(file_dialog_1.SaveFileDialogProps).toConstantValue(props);
    container.bind(file_dialog_1.SaveFileDialog).toSelf();
    return container;
}
exports.createSaveFileDialogContainer = createSaveFileDialogContainer;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-model.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-model.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileDialogModel = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const file_tree_1 = __webpack_require__(/*! ../file-tree */ "./node_modules/@theia/filesystem/lib/browser/file-tree/index.js");
const file_dialog_tree_1 = __webpack_require__(/*! ./file-dialog-tree */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-tree.js");
let FileDialogModel = class FileDialogModel extends file_tree_1.FileTreeModel {
    constructor() {
        super(...arguments);
        this.onDidOpenFileEmitter = new common_1.Emitter();
        this._disableFileSelection = false;
    }
    init() {
        super.init();
        this.toDispose.push(this.onDidOpenFileEmitter);
    }
    /**
     * Returns the first valid location that was set by calling the `navigateTo` method. Once the initial location has a defined value, it will not change.
     * Can be `undefined`.
     */
    get initialLocation() {
        return this._initialLocation;
    }
    set disableFileSelection(isSelectable) {
        this._disableFileSelection = isSelectable;
    }
    async navigateTo(nodeOrId) {
        const result = await super.navigateTo(nodeOrId);
        if (!this._initialLocation && file_tree_1.FileStatNode.is(result)) {
            this._initialLocation = result.uri;
        }
        return result;
    }
    get onDidOpenFile() {
        return this.onDidOpenFileEmitter.event;
    }
    doOpenNode(node) {
        if (file_tree_1.FileNode.is(node)) {
            this.onDidOpenFileEmitter.fire(undefined);
        }
        else if (file_tree_1.DirNode.is(node)) {
            this.navigateTo(node);
        }
        else {
            super.doOpenNode(node);
        }
    }
    getNextSelectableNode(node = this.selectedNodes[0]) {
        let nextNode = node;
        do {
            nextNode = super.getNextSelectableNode(nextNode);
        } while (file_tree_1.FileStatNode.is(nextNode) && !this.isFileStatNodeSelectable(nextNode));
        return nextNode;
    }
    getPrevSelectableNode(node = this.selectedNodes[0]) {
        let prevNode = node;
        do {
            prevNode = super.getPrevSelectableNode(prevNode);
        } while (file_tree_1.FileStatNode.is(prevNode) && !this.isFileStatNodeSelectable(prevNode));
        return prevNode;
    }
    isFileStatNodeSelectable(node) {
        return !(!node.fileStat.isDirectory && this._disableFileSelection);
    }
    canNavigateUpward() {
        const treeRoot = this.tree.root;
        return file_tree_1.FileStatNode.is(treeRoot) && !treeRoot.uri.path.isRoot;
    }
};
__decorate([
    inversify_1.inject(file_dialog_tree_1.FileDialogTree),
    __metadata("design:type", file_dialog_tree_1.FileDialogTree)
], FileDialogModel.prototype, "tree", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], FileDialogModel.prototype, "init", null);
FileDialogModel = __decorate([
    inversify_1.injectable()
], FileDialogModel);
exports.FileDialogModel = FileDialogModel;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-service.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-service.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultFileDialogService = exports.FileDialogService = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const file_tree_1 = __webpack_require__(/*! ../file-tree */ "./node_modules/@theia/filesystem/lib/browser/file-tree/index.js");
const file_dialog_1 = __webpack_require__(/*! ./file-dialog */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog.js");
const file_service_1 = __webpack_require__(/*! ../file-service */ "./node_modules/@theia/filesystem/lib/browser/file-service.js");
const env_variables_1 = __webpack_require__(/*! @theia/core/lib/common/env-variables */ "./node_modules/@theia/core/lib/common/env-variables/index.js");
exports.FileDialogService = Symbol('FileDialogService');
let DefaultFileDialogService = class DefaultFileDialogService {
    async showOpenDialog(props, folder) {
        const title = props.title || 'Open';
        const rootNode = await this.getRootNode(folder);
        if (rootNode) {
            const dialog = this.openFileDialogFactory(Object.assign(props, { title }));
            await dialog.model.navigateTo(rootNode);
            const value = await dialog.open();
            if (value) {
                if (!Array.isArray(value)) {
                    return value.uri;
                }
                return value.map(node => node.uri);
            }
        }
        return undefined;
    }
    async showSaveDialog(props, folder) {
        const title = props.title || 'Save';
        const rootNode = await this.getRootNode(folder);
        if (rootNode) {
            const dialog = this.saveFileDialogFactory(Object.assign(props, { title }));
            await dialog.model.navigateTo(rootNode);
            return dialog.open();
        }
        return undefined;
    }
    async getRootNode(folderToOpen) {
        const folderExists = folderToOpen && await this.fileService.exists(folderToOpen.resource);
        const folder = folderToOpen && folderExists ? folderToOpen : {
            resource: new uri_1.default(await this.environments.getHomeDirUri()),
            isDirectory: true
        };
        const folderUri = folder.resource;
        const rootUri = folder.isDirectory ? folderUri : folderUri.parent;
        try {
            const rootStat = await this.fileService.resolve(rootUri);
            return file_tree_1.DirNode.createRoot(rootStat);
        }
        catch (_a) { }
        return undefined;
    }
};
__decorate([
    inversify_1.inject(env_variables_1.EnvVariablesServer),
    __metadata("design:type", Object)
], DefaultFileDialogService.prototype, "environments", void 0);
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], DefaultFileDialogService.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(file_dialog_1.OpenFileDialogFactory),
    __metadata("design:type", Function)
], DefaultFileDialogService.prototype, "openFileDialogFactory", void 0);
__decorate([
    inversify_1.inject(browser_1.LabelProvider),
    __metadata("design:type", browser_1.LabelProvider)
], DefaultFileDialogService.prototype, "labelProvider", void 0);
__decorate([
    inversify_1.inject(file_dialog_1.SaveFileDialogFactory),
    __metadata("design:type", Function)
], DefaultFileDialogService.prototype, "saveFileDialogFactory", void 0);
DefaultFileDialogService = __decorate([
    inversify_1.injectable()
], DefaultFileDialogService);
exports.DefaultFileDialogService = DefaultFileDialogService;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-tree-filters-renderer.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-tree-filters-renderer.js ***!
  \*****************************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileDialogTreeFiltersRenderer = exports.FileDialogTreeFiltersRendererOptions = exports.FileDialogTreeFiltersRendererFactory = exports.FileDialogTreeFilters = exports.FILE_TREE_FILTERS_LIST_CLASS = void 0;
const react_renderer_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/react-renderer */ "./node_modules/@theia/core/lib/browser/widgets/react-renderer.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
exports.FILE_TREE_FILTERS_LIST_CLASS = 'theia-FileTreeFiltersList';
/**
 * A set of file filters that are used by the dialog. Each entry is a human readable label,
 * like "TypeScript", and an array of extensions, e.g.
 * ```ts
 * {
 *  'Images': ['png', 'jpg']
 *  'TypeScript': ['ts', 'tsx']
 * }
 * ```
 */
class FileDialogTreeFilters {
}
exports.FileDialogTreeFilters = FileDialogTreeFilters;
exports.FileDialogTreeFiltersRendererFactory = Symbol('FileDialogTreeFiltersRendererFactory');
exports.FileDialogTreeFiltersRendererOptions = Symbol('FileDialogTreeFiltersRendererOptions');
let FileDialogTreeFiltersRenderer = class FileDialogTreeFiltersRenderer extends react_renderer_1.ReactRenderer {
    constructor(options) {
        super();
        this.options = options;
        this.handleFilterChanged = (e) => this.onFilterChanged(e);
        this.suppliedFilters = options.suppliedFilters;
        this.fileDialogTree = options.fileDialogTree;
        this.appliedFilters = Object.assign(Object.assign({}, this.suppliedFilters), { 'All Files': [] });
    }
    doRender() {
        if (!this.appliedFilters) {
            return undefined;
        }
        const options = Object.keys(this.appliedFilters).map(value => this.renderLocation(value));
        return React.createElement("select", { className: 'theia-select ' + exports.FILE_TREE_FILTERS_LIST_CLASS, onChange: this.handleFilterChanged }, options);
    }
    renderLocation(value) {
        return React.createElement("option", { value: value, key: value }, value);
    }
    onFilterChanged(e) {
        const locationList = this.locationList;
        if (locationList) {
            const value = locationList.value;
            const filters = this.appliedFilters[value];
            this.fileDialogTree.setFilter(filters);
        }
        e.preventDefault();
        e.stopPropagation();
    }
    get locationList() {
        const locationList = this.host.getElementsByClassName(exports.FILE_TREE_FILTERS_LIST_CLASS)[0];
        if (locationList instanceof HTMLSelectElement) {
            return locationList;
        }
        return undefined;
    }
};
FileDialogTreeFiltersRenderer = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(exports.FileDialogTreeFiltersRendererOptions)),
    __metadata("design:paramtypes", [Object])
], FileDialogTreeFiltersRenderer);
exports.FileDialogTreeFiltersRenderer = FileDialogTreeFiltersRenderer;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-tree.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-tree.js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileDialogTree = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const file_tree_1 = __webpack_require__(/*! ../file-tree */ "./node_modules/@theia/filesystem/lib/browser/file-tree/index.js");
let FileDialogTree = class FileDialogTree extends file_tree_1.FileTree {
    constructor() {
        super(...arguments);
        /**
         * Extensions for files to be shown
         */
        this.fileExtensions = [];
    }
    /**
     * Sets extensions for filtering files
     *
     * @param fileExtensions array of extensions
     */
    setFilter(fileExtensions) {
        this.fileExtensions = fileExtensions.slice();
        this.refresh();
    }
    async toNodes(fileStat, parent) {
        if (!fileStat.children) {
            return [];
        }
        const result = await Promise.all(fileStat.children
            .filter(child => this.isVisible(child))
            .map(child => this.toNode(child, parent)));
        return result.sort(file_tree_1.DirNode.compare);
    }
    /**
     * Determines whether file or folder can be shown
     *
     * @param fileStat resource to check
     */
    isVisible(fileStat) {
        if (fileStat.isDirectory) {
            return true;
        }
        if (this.fileExtensions.length === 0) {
            return true;
        }
        return !this.fileExtensions.every(value => fileStat.resource.path.ext !== '.' + value);
    }
};
FileDialogTree = __decorate([
    inversify_1.injectable()
], FileDialogTree);
exports.FileDialogTree = FileDialogTree;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-widget.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-widget.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileDialogWidget = exports.NOT_SELECTABLE_CLASS = exports.FILE_DIALOG_CLASS = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const file_tree_1 = __webpack_require__(/*! ../file-tree */ "./node_modules/@theia/filesystem/lib/browser/file-tree/index.js");
const file_dialog_model_1 = __webpack_require__(/*! ./file-dialog-model */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-model.js");
exports.FILE_DIALOG_CLASS = 'theia-FileDialog';
exports.NOT_SELECTABLE_CLASS = 'theia-mod-not-selectable';
let FileDialogWidget = class FileDialogWidget extends file_tree_1.FileTreeWidget {
    constructor(props, model, contextMenuRenderer) {
        super(props, model, contextMenuRenderer);
        this.props = props;
        this.model = model;
        this._disableFileSelection = false;
        this.addClass(exports.FILE_DIALOG_CLASS);
    }
    set disableFileSelection(isSelectable) {
        this._disableFileSelection = isSelectable;
        this.model.disableFileSelection = isSelectable;
    }
    createNodeAttributes(node, props) {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const attr = super.createNodeAttributes(node, props);
        if (this.shouldDisableSelection(node)) {
            const keys = Object.keys(attr);
            keys.forEach(k => {
                if (['className', 'style', 'title'].indexOf(k) < 0) {
                    delete attr[k];
                }
            });
        }
        return attr;
    }
    createNodeClassNames(node, props) {
        const classNames = super.createNodeClassNames(node, props);
        if (this.shouldDisableSelection(node)) {
            [browser_1.SELECTED_CLASS, browser_1.FOCUS_CLASS].forEach(name => {
                const ind = classNames.indexOf(name);
                if (ind >= 0) {
                    classNames.splice(ind, 1);
                }
            });
            classNames.push(exports.NOT_SELECTABLE_CLASS);
        }
        return classNames;
    }
    shouldDisableSelection(node) {
        return file_tree_1.FileStatNode.is(node) && !node.fileStat.isDirectory && this._disableFileSelection;
    }
};
FileDialogWidget = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(browser_1.TreeProps)),
    __param(1, inversify_1.inject(file_dialog_model_1.FileDialogModel)),
    __param(2, inversify_1.inject(browser_1.ContextMenuRenderer)),
    __metadata("design:paramtypes", [Object, file_dialog_model_1.FileDialogModel,
        browser_1.ContextMenuRenderer])
], FileDialogWidget);
exports.FileDialogWidget = FileDialogWidget;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SaveFileDialog = exports.OpenFileDialog = exports.FileDialog = exports.SaveFileDialogProps = exports.OpenFileDialogProps = exports.FileDialogProps = exports.TOOLBAR_ITEM_TRANSFORM_TIMEOUT = exports.CONTROL_PANEL_CLASS = exports.FILENAME_TEXTFIELD_CLASS = exports.FILENAME_LABEL_CLASS = exports.FILENAME_PANEL_CLASS = exports.FILTERS_LIST_PANEL_CLASS = exports.FILTERS_LABEL_CLASS = exports.FILTERS_PANEL_CLASS = exports.NAVIGATION_LOCATION_LIST_PANEL_CLASS = exports.NAVIGATION_UP_CLASS = exports.NAVIGATION_HOME_CLASS = exports.NAVIGATION_FORWARD_CLASS = exports.NAVIGATION_BACK_CLASS = exports.NAVIGATION_PANEL_CLASS = exports.SAVE_DIALOG_CLASS = exports.SaveFileDialogFactory = exports.OpenFileDialogFactory = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const location_1 = __webpack_require__(/*! ../location */ "./node_modules/@theia/filesystem/lib/browser/location/index.js");
const file_dialog_widget_1 = __webpack_require__(/*! ./file-dialog-widget */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-widget.js");
const file_dialog_tree_filters_renderer_1 = __webpack_require__(/*! ./file-dialog-tree-filters-renderer */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-tree-filters-renderer.js");
const widgets_1 = __webpack_require__(/*! @theia/core/shared/@phosphor/widgets */ "./node_modules/@theia/core/shared/@phosphor/widgets/index.js");
exports.OpenFileDialogFactory = Symbol('OpenFileDialogFactory');
exports.SaveFileDialogFactory = Symbol('SaveFileDialogFactory');
exports.SAVE_DIALOG_CLASS = 'theia-SaveFileDialog';
exports.NAVIGATION_PANEL_CLASS = 'theia-NavigationPanel';
exports.NAVIGATION_BACK_CLASS = 'theia-NavigationBack';
exports.NAVIGATION_FORWARD_CLASS = 'theia-NavigationForward';
exports.NAVIGATION_HOME_CLASS = 'theia-NavigationHome';
exports.NAVIGATION_UP_CLASS = 'theia-NavigationUp';
exports.NAVIGATION_LOCATION_LIST_PANEL_CLASS = 'theia-LocationListPanel';
exports.FILTERS_PANEL_CLASS = 'theia-FiltersPanel';
exports.FILTERS_LABEL_CLASS = 'theia-FiltersLabel';
exports.FILTERS_LIST_PANEL_CLASS = 'theia-FiltersListPanel';
exports.FILENAME_PANEL_CLASS = 'theia-FileNamePanel';
exports.FILENAME_LABEL_CLASS = 'theia-FileNameLabel';
exports.FILENAME_TEXTFIELD_CLASS = 'theia-FileNameTextField';
exports.CONTROL_PANEL_CLASS = 'theia-ControlPanel';
exports.TOOLBAR_ITEM_TRANSFORM_TIMEOUT = 100;
class FileDialogProps extends browser_1.DialogProps {
}
exports.FileDialogProps = FileDialogProps;
let OpenFileDialogProps = class OpenFileDialogProps extends FileDialogProps {
};
OpenFileDialogProps = __decorate([
    inversify_1.injectable()
], OpenFileDialogProps);
exports.OpenFileDialogProps = OpenFileDialogProps;
let SaveFileDialogProps = class SaveFileDialogProps extends FileDialogProps {
};
SaveFileDialogProps = __decorate([
    inversify_1.injectable()
], SaveFileDialogProps);
exports.SaveFileDialogProps = SaveFileDialogProps;
let FileDialog = class FileDialog extends browser_1.AbstractDialog {
    constructor(props) {
        super(props);
        this.props = props;
    }
    init() {
        this.treePanel = new widgets_1.Panel();
        this.treePanel.addWidget(this.widget);
        this.toDispose.push(this.treePanel);
        this.toDispose.push(this.model.onChanged(() => this.update()));
        this.toDispose.push(this.model.onDidOpenFile(() => this.accept()));
        this.toDispose.push(this.model.onSelectionChanged(() => this.update()));
        const navigationPanel = document.createElement('div');
        navigationPanel.classList.add(exports.NAVIGATION_PANEL_CLASS);
        this.contentNode.appendChild(navigationPanel);
        navigationPanel.appendChild(this.back = browser_1.createIconButton(...browser_1.codiconArray('chevron-left', true)));
        this.back.classList.add(exports.NAVIGATION_BACK_CLASS);
        this.back.title = 'Navigate Back';
        navigationPanel.appendChild(this.forward = browser_1.createIconButton(...browser_1.codiconArray('chevron-right', true)));
        this.forward.classList.add(exports.NAVIGATION_FORWARD_CLASS);
        this.forward.title = 'Navigate Forward';
        navigationPanel.appendChild(this.home = browser_1.createIconButton(...browser_1.codiconArray('home', true)));
        this.home.classList.add(exports.NAVIGATION_HOME_CLASS);
        this.home.title = 'Go To Initial Location';
        navigationPanel.appendChild(this.up = browser_1.createIconButton(...browser_1.codiconArray('arrow-up', true)));
        this.up.classList.add(exports.NAVIGATION_UP_CLASS);
        this.up.title = 'Navigate Up One Directory';
        const locationListRendererHost = document.createElement('div');
        this.locationListRenderer = this.locationListFactory({ model: this.model, host: locationListRendererHost });
        this.toDispose.push(this.locationListRenderer);
        this.locationListRenderer.host.classList.add(exports.NAVIGATION_LOCATION_LIST_PANEL_CLASS);
        navigationPanel.appendChild(this.locationListRenderer.host);
        if (this.props.filters) {
            this.treeFiltersRenderer = this.treeFiltersFactory({ suppliedFilters: this.props.filters, fileDialogTree: this.widget.model.tree });
            const filters = Object.keys(this.props.filters);
            if (filters.length) {
                this.widget.model.tree.setFilter(this.props.filters[filters[0]]);
            }
        }
    }
    get model() {
        return this.widget.model;
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        browser_1.setEnabled(this.back, this.model.canNavigateBackward());
        browser_1.setEnabled(this.forward, this.model.canNavigateForward());
        browser_1.setEnabled(this.home, !!this.model.initialLocation
            && !!this.model.location
            && this.model.initialLocation.toString() !== this.model.location.toString());
        browser_1.setEnabled(this.up, this.model.canNavigateUpward());
        this.locationListRenderer.render();
        if (this.treeFiltersRenderer) {
            this.treeFiltersRenderer.render();
        }
        this.widget.update();
    }
    handleEnter(event) {
        if (event.target instanceof HTMLTextAreaElement || this.targetIsDirectoryInput(event.target) || this.targetIsInputToggle(event.target)) {
            return false;
        }
        this.accept();
    }
    handleEscape(event) {
        if (event.target instanceof HTMLTextAreaElement || this.targetIsDirectoryInput(event.target)) {
            return false;
        }
        this.close();
    }
    targetIsDirectoryInput(target) {
        return target instanceof HTMLInputElement && target.classList.contains(location_1.LocationListRenderer.Styles.LOCATION_TEXT_INPUT_CLASS);
    }
    targetIsInputToggle(target) {
        return target instanceof HTMLSpanElement && target.classList.contains(location_1.LocationListRenderer.Styles.LOCATION_INPUT_TOGGLE_CLASS);
    }
    appendFiltersPanel() {
        if (this.treeFiltersRenderer) {
            const filtersPanel = document.createElement('div');
            filtersPanel.classList.add(exports.FILTERS_PANEL_CLASS);
            this.contentNode.appendChild(filtersPanel);
            const titlePanel = document.createElement('div');
            titlePanel.innerHTML = 'Format:';
            titlePanel.classList.add(exports.FILTERS_LABEL_CLASS);
            filtersPanel.appendChild(titlePanel);
            this.treeFiltersRenderer.host.classList.add(exports.FILTERS_LIST_PANEL_CLASS);
            filtersPanel.appendChild(this.treeFiltersRenderer.host);
        }
    }
    onAfterAttach(msg) {
        browser_1.Widget.attach(this.treePanel, this.contentNode);
        this.toDisposeOnDetach.push(common_1.Disposable.create(() => {
            browser_1.Widget.detach(this.treePanel);
            this.locationListRenderer.dispose();
            if (this.treeFiltersRenderer) {
                this.treeFiltersRenderer.dispose();
            }
        }));
        this.appendFiltersPanel();
        this.appendCloseButton(common_1.nls.localizeByDefault('Cancel'));
        this.appendAcceptButton(this.getAcceptButtonLabel());
        this.addKeyListener(this.back, browser_1.Key.ENTER, () => {
            this.addTransformEffectToIcon(this.back);
            this.model.navigateBackward();
        }, 'click');
        this.addKeyListener(this.forward, browser_1.Key.ENTER, () => {
            this.addTransformEffectToIcon(this.forward);
            this.model.navigateForward();
        }, 'click');
        this.addKeyListener(this.home, browser_1.Key.ENTER, () => {
            this.addTransformEffectToIcon(this.home);
            if (this.model.initialLocation) {
                this.model.location = this.model.initialLocation;
            }
        }, 'click');
        this.addKeyListener(this.up, browser_1.Key.ENTER, () => {
            this.addTransformEffectToIcon(this.up);
            if (this.model.location) {
                this.model.location = this.model.location.parent;
            }
        }, 'click');
        super.onAfterAttach(msg);
    }
    addTransformEffectToIcon(element) {
        const icon = element.getElementsByTagName('i')[0];
        icon.classList.add('active');
        setTimeout(() => icon.classList.remove('active'), exports.TOOLBAR_ITEM_TRANSFORM_TIMEOUT);
    }
    onActivateRequest(msg) {
        this.widget.activate();
    }
};
__decorate([
    inversify_1.inject(file_dialog_widget_1.FileDialogWidget),
    __metadata("design:type", file_dialog_widget_1.FileDialogWidget)
], FileDialog.prototype, "widget", void 0);
__decorate([
    inversify_1.inject(location_1.LocationListRendererFactory),
    __metadata("design:type", Function)
], FileDialog.prototype, "locationListFactory", void 0);
__decorate([
    inversify_1.inject(file_dialog_tree_filters_renderer_1.FileDialogTreeFiltersRendererFactory),
    __metadata("design:type", Function)
], FileDialog.prototype, "treeFiltersFactory", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], FileDialog.prototype, "init", null);
FileDialog = __decorate([
    __param(0, inversify_1.inject(FileDialogProps)),
    __metadata("design:paramtypes", [FileDialogProps])
], FileDialog);
exports.FileDialog = FileDialog;
let OpenFileDialog = class OpenFileDialog extends FileDialog {
    constructor(props) {
        super(props);
        this.props = props;
    }
    init() {
        super.init();
        const { props } = this;
        if (props.canSelectFiles !== undefined) {
            this.widget.disableFileSelection = !props.canSelectFiles;
        }
    }
    getAcceptButtonLabel() {
        return this.props.openLabel ? this.props.openLabel : 'Open';
    }
    isValid(value) {
        if (value && !this.props.canSelectMany && value instanceof Array) {
            return 'You can select only one item';
        }
        return '';
    }
    get value() {
        if (this.widget.model.selectedFileStatNodes.length === 1) {
            return this.widget.model.selectedFileStatNodes[0];
        }
        else {
            return this.widget.model.selectedFileStatNodes;
        }
    }
    async accept() {
        const selection = this.value;
        if (!this.props.canSelectFolders
            && !Array.isArray(selection)
            && selection.fileStat.isDirectory) {
            this.widget.model.openNode(selection);
            return;
        }
        super.accept();
    }
};
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], OpenFileDialog.prototype, "init", null);
OpenFileDialog = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(OpenFileDialogProps)),
    __metadata("design:paramtypes", [OpenFileDialogProps])
], OpenFileDialog);
exports.OpenFileDialog = OpenFileDialog;
let SaveFileDialog = class SaveFileDialog extends FileDialog {
    constructor(props) {
        super(props);
        this.props = props;
    }
    init() {
        super.init();
        const { widget } = this;
        widget.addClass(exports.SAVE_DIALOG_CLASS);
    }
    getAcceptButtonLabel() {
        return this.props.saveLabel ? this.props.saveLabel : 'Save';
    }
    onUpdateRequest(msg) {
        // Update file name field when changing a selection
        if (this.fileNameField) {
            if (this.widget.model.selectedFileStatNodes.length === 1) {
                const node = this.widget.model.selectedFileStatNodes[0];
                if (!node.fileStat.isDirectory) {
                    this.fileNameField.value = this.labelProvider.getName(node);
                }
            }
            else {
                this.fileNameField.value = '';
            }
        }
        // Continue updating the dialog
        super.onUpdateRequest(msg);
    }
    isValid(value) {
        if (this.fileNameField && this.fileNameField.value) {
            return '';
        }
        return false;
    }
    get value() {
        if (this.fileNameField && this.widget.model.selectedFileStatNodes.length === 1) {
            const node = this.widget.model.selectedFileStatNodes[0];
            if (node.fileStat.isDirectory) {
                return node.uri.resolve(this.fileNameField.value);
            }
            return node.uri.parent.resolve(this.fileNameField.value);
        }
        return undefined;
    }
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        const fileNamePanel = document.createElement('div');
        fileNamePanel.classList.add(exports.FILENAME_PANEL_CLASS);
        this.contentNode.appendChild(fileNamePanel);
        const titlePanel = document.createElement('div');
        titlePanel.innerHTML = 'Name:';
        titlePanel.classList.add(exports.FILENAME_LABEL_CLASS);
        fileNamePanel.appendChild(titlePanel);
        this.fileNameField = document.createElement('input');
        this.fileNameField.type = 'text';
        this.fileNameField.spellcheck = false;
        this.fileNameField.classList.add('theia-input', exports.FILENAME_TEXTFIELD_CLASS);
        this.fileNameField.value = this.props.inputValue || '';
        fileNamePanel.appendChild(this.fileNameField);
        this.fileNameField.onkeyup = () => this.validate();
    }
};
__decorate([
    inversify_1.inject(browser_1.LabelProvider),
    __metadata("design:type", browser_1.LabelProvider)
], SaveFileDialog.prototype, "labelProvider", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SaveFileDialog.prototype, "init", null);
SaveFileDialog = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(SaveFileDialogProps)),
    __metadata("design:paramtypes", [SaveFileDialogProps])
], SaveFileDialog);
exports.SaveFileDialog = SaveFileDialog;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-dialog/index.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-dialog/index.js ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./file-dialog */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog.js"), exports);
__exportStar(__webpack_require__(/*! ./file-dialog-container */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-container.js"), exports);
__exportStar(__webpack_require__(/*! ./file-dialog-tree-filters-renderer */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-tree-filters-renderer.js"), exports);
__exportStar(__webpack_require__(/*! ./file-dialog-service */ "./node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-service.js"), exports);


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree-container.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree-container.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createFileTreeContainer = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const file_tree_1 = __webpack_require__(/*! ./file-tree */ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree.js");
const file_tree_model_1 = __webpack_require__(/*! ./file-tree-model */ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree-model.js");
const file_tree_widget_1 = __webpack_require__(/*! ./file-tree-widget */ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree-widget.js");
function createFileTreeContainer(parent) {
    const child = browser_1.createTreeContainer(parent);
    child.unbind(browser_1.TreeImpl);
    child.bind(file_tree_1.FileTree).toSelf();
    child.rebind(browser_1.Tree).toService(file_tree_1.FileTree);
    child.unbind(browser_1.TreeModelImpl);
    child.bind(file_tree_model_1.FileTreeModel).toSelf();
    child.rebind(browser_1.TreeModel).toService(file_tree_model_1.FileTreeModel);
    child.unbind(browser_1.TreeWidget);
    child.bind(file_tree_widget_1.FileTreeWidget).toSelf();
    return child;
}
exports.createFileTreeContainer = createFileTreeContainer;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree-model.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree-model.js ***!
  \*********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileTreeModel = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const file_tree_1 = __webpack_require__(/*! ./file-tree */ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree.js");
const label_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/label-provider */ "./node_modules/@theia/core/lib/browser/label-provider.js");
const file_service_1 = __webpack_require__(/*! ../file-service */ "./node_modules/@theia/filesystem/lib/browser/file-service.js");
const files_1 = __webpack_require__(/*! ../../common/files */ "./node_modules/@theia/filesystem/lib/common/files.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "./node_modules/@theia/core/lib/common/message-service.js");
const env_variables_1 = __webpack_require__(/*! @theia/core/lib/common/env-variables */ "./node_modules/@theia/core/lib/common/env-variables/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "./node_modules/@theia/filesystem/lib/common/index.js");
let FileTreeModel = class FileTreeModel extends browser_1.TreeModelImpl {
    init() {
        super.init();
        this.toDispose.push(this.fileService.onDidFilesChange(changes => this.onFilesChanged(changes)));
        this.toDispose.push(this.fileService.onDidRunOperation(event => this.onDidMove(event)));
    }
    get location() {
        const root = this.root;
        if (file_tree_1.FileStatNode.is(root)) {
            return root.uri;
        }
        return undefined;
    }
    set location(uri) {
        if (uri) {
            this.fileService.resolve(uri).then(fileStat => {
                if (fileStat) {
                    const node = file_tree_1.DirNode.createRoot(fileStat);
                    this.navigateTo(node);
                }
            }).catch(() => {
                // no-op, allow failures for file dialog text input
            });
        }
        else {
            this.navigateTo(undefined);
        }
    }
    async drives() {
        try {
            const drives = await this.environments.getDrives();
            return drives.map(uri => new uri_1.default(uri));
        }
        catch (e) {
            this.logger.error('Error when loading drives.', e);
            return [];
        }
    }
    get selectedFileStatNodes() {
        return this.selectedNodes.filter(file_tree_1.FileStatNode.is);
    }
    *getNodesByUri(uri) {
        const node = this.getNode(uri.toString());
        if (node) {
            yield node;
        }
    }
    /**
     * to workaround https://github.com/Axosoft/nsfw/issues/42
     */
    onDidMove(event) {
        if (!event.isOperation(2 /* MOVE */)) {
            return;
        }
        if (event.resource.parent.toString() === event.target.resource.parent.toString()) {
            // file rename
            return;
        }
        this.refreshAffectedNodes([
            event.resource,
            event.target.resource
        ]);
    }
    onFilesChanged(changes) {
        if (!this.refreshAffectedNodes(this.getAffectedUris(changes)) && this.isRootAffected(changes)) {
            this.refresh();
        }
    }
    isRootAffected(changes) {
        const root = this.root;
        if (file_tree_1.FileStatNode.is(root)) {
            return changes.contains(root.uri, 1 /* ADDED */) || changes.contains(root.uri, 0 /* UPDATED */);
        }
        return false;
    }
    getAffectedUris(changes) {
        return changes.changes.filter(change => !this.isFileContentChanged(change)).map(change => change.resource);
    }
    isFileContentChanged(change) {
        return change.type === 0 /* UPDATED */ && file_tree_1.FileNode.is(this.getNodesByUri(change.resource).next().value);
    }
    refreshAffectedNodes(uris) {
        const nodes = this.getAffectedNodes(uris);
        for (const node of nodes.values()) {
            this.refresh(node);
        }
        return nodes.size !== 0;
    }
    getAffectedNodes(uris) {
        const nodes = new Map();
        for (const uri of uris) {
            for (const node of this.getNodesByUri(uri.parent)) {
                if (file_tree_1.DirNode.is(node) && node.expanded) {
                    nodes.set(node.id, node);
                }
            }
        }
        return nodes;
    }
    async copy(source, target) {
        let targetUri = target.uri.resolve(source.path.base);
        try {
            if (source.path.toString() === target.uri.path.toString()) {
                const parent = await this.fileService.resolve(source.parent);
                const name = source.path.name + '_copy';
                targetUri = common_1.FileSystemUtils.generateUniqueResourceURI(source.parent, parent, name, source.path.ext);
            }
            await this.fileService.copy(source, targetUri);
        }
        catch (e) {
            this.messageService.error(e.message);
        }
        return targetUri;
    }
    /**
     * Move the given source file or directory to the given target directory.
     */
    async move(source, target) {
        if (file_tree_1.DirNode.is(target) && file_tree_1.FileStatNode.is(source)) {
            const name = source.fileStat.name;
            const targetUri = target.uri.resolve(name);
            try {
                await this.fileService.move(source.uri, targetUri);
                return targetUri;
            }
            catch (e) {
                if (e instanceof files_1.FileOperationError && e.fileOperationResult === 4 /* FILE_MOVE_CONFLICT */) {
                    const fileName = this.labelProvider.getName(source);
                    if (await this.shouldReplace(fileName)) {
                        try {
                            await this.fileService.move(source.uri, targetUri, { overwrite: true });
                            return targetUri;
                        }
                        catch (e2) {
                            this.messageService.error(e2.message);
                        }
                    }
                }
                else {
                    this.messageService.error(e.message);
                }
            }
        }
        return undefined;
    }
    async shouldReplace(fileName) {
        const dialog = new browser_1.ConfirmDialog({
            title: 'Replace file',
            msg: `File '${fileName}' already exists in the destination folder. Do you want to replace it?`,
            ok: 'Yes',
            cancel: 'No'
        });
        return !!await dialog.open();
    }
};
__decorate([
    inversify_1.inject(label_provider_1.LabelProvider),
    __metadata("design:type", label_provider_1.LabelProvider)
], FileTreeModel.prototype, "labelProvider", void 0);
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], FileTreeModel.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], FileTreeModel.prototype, "messageService", void 0);
__decorate([
    inversify_1.inject(env_variables_1.EnvVariablesServer),
    __metadata("design:type", Object)
], FileTreeModel.prototype, "environments", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], FileTreeModel.prototype, "init", null);
FileTreeModel = __decorate([
    inversify_1.injectable()
], FileTreeModel);
exports.FileTreeModel = FileTreeModel;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree-widget.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree-widget.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileTreeWidget = exports.FILE_STAT_ICON_CLASS = exports.DIR_NODE_CLASS = exports.FILE_STAT_NODE_CLASS = exports.FILE_TREE_CLASS = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "./node_modules/@theia/core/lib/common/disposable.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const selection_1 = __webpack_require__(/*! @theia/core/lib/common/selection */ "./node_modules/@theia/core/lib/common/selection.js");
const cancellation_1 = __webpack_require__(/*! @theia/core/lib/common/cancellation */ "./node_modules/@theia/core/lib/common/cancellation.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const file_upload_service_1 = __webpack_require__(/*! ../file-upload-service */ "./node_modules/@theia/filesystem/lib/browser/file-upload-service.js");
const file_tree_1 = __webpack_require__(/*! ./file-tree */ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree.js");
const file_tree_model_1 = __webpack_require__(/*! ./file-tree-model */ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree-model.js");
const icon_theme_service_1 = __webpack_require__(/*! @theia/core/lib/browser/icon-theme-service */ "./node_modules/@theia/core/lib/browser/icon-theme-service.js");
const files_1 = __webpack_require__(/*! ../../common/files */ "./node_modules/@theia/filesystem/lib/common/files.js");
exports.FILE_TREE_CLASS = 'theia-FileTree';
exports.FILE_STAT_NODE_CLASS = 'theia-FileStatNode';
exports.DIR_NODE_CLASS = 'theia-DirNode';
exports.FILE_STAT_ICON_CLASS = 'theia-FileStatIcon';
let FileTreeWidget = class FileTreeWidget extends browser_1.TreeViewWelcomeWidget {
    constructor(props, model, contextMenuRenderer) {
        super(props, model, contextMenuRenderer);
        this.props = props;
        this.model = model;
        this.toCancelNodeExpansion = new disposable_1.DisposableCollection();
        this.addClass(exports.FILE_TREE_CLASS);
        this.toDispose.push(this.toCancelNodeExpansion);
    }
    createNodeClassNames(node, props) {
        const classNames = super.createNodeClassNames(node, props);
        if (file_tree_1.FileStatNode.is(node)) {
            classNames.push(exports.FILE_STAT_NODE_CLASS);
        }
        if (file_tree_1.DirNode.is(node)) {
            classNames.push(exports.DIR_NODE_CLASS);
        }
        return classNames;
    }
    renderIcon(node, props) {
        const icon = this.toNodeIcon(node);
        if (icon) {
            return React.createElement("div", { className: icon + ' file-icon' });
        }
        // eslint-disable-next-line no-null/no-null
        return null;
    }
    createContainerAttributes() {
        const attrs = super.createContainerAttributes();
        return Object.assign(Object.assign({}, attrs), { onDragEnter: event => this.handleDragEnterEvent(this.model.root, event), onDragOver: event => this.handleDragOverEvent(this.model.root, event), onDragLeave: event => this.handleDragLeaveEvent(this.model.root, event), onDrop: event => this.handleDropEvent(this.model.root, event) });
    }
    createNodeAttributes(node, props) {
        const elementAttrs = super.createNodeAttributes(node, props);
        return Object.assign(Object.assign({}, elementAttrs), { draggable: file_tree_1.FileStatNode.is(node), onDragStart: event => this.handleDragStartEvent(node, event), onDragEnter: event => this.handleDragEnterEvent(node, event), onDragOver: event => this.handleDragOverEvent(node, event), onDragLeave: event => this.handleDragLeaveEvent(node, event), onDrop: event => this.handleDropEvent(node, event), title: this.getNodeTooltip(node) });
    }
    getNodeTooltip(node) {
        const uri = selection_1.UriSelection.getUri(node);
        return uri ? uri.path.toString() : undefined;
    }
    handleDragStartEvent(node, event) {
        event.stopPropagation();
        let selectedNodes;
        if (this.model.selectedNodes.find(selected => browser_1.TreeNode.equals(selected, node))) {
            selectedNodes = [...this.model.selectedNodes];
        }
        else {
            selectedNodes = [node];
        }
        this.setSelectedTreeNodesAsData(event.dataTransfer, node, selectedNodes);
        if (event.dataTransfer) {
            let label;
            if (selectedNodes.length === 1) {
                label = this.toNodeName(node);
            }
            else {
                label = String(selectedNodes.length);
            }
            const dragImage = document.createElement('div');
            dragImage.className = 'theia-file-tree-drag-image';
            dragImage.textContent = label;
            document.body.appendChild(dragImage);
            event.dataTransfer.setDragImage(dragImage, -10, -10);
            setTimeout(() => document.body.removeChild(dragImage), 0);
        }
    }
    handleDragEnterEvent(node, event) {
        event.preventDefault();
        event.stopPropagation();
        this.toCancelNodeExpansion.dispose();
        const containing = file_tree_1.DirNode.getContainingDir(node);
        if (!!containing && !containing.selected) {
            this.model.selectNode(containing);
        }
    }
    handleDragOverEvent(node, event) {
        event.preventDefault();
        event.stopPropagation();
        if (!this.toCancelNodeExpansion.disposed) {
            return;
        }
        const timer = setTimeout(() => {
            const containing = file_tree_1.DirNode.getContainingDir(node);
            if (!!containing && !containing.expanded) {
                this.model.expandNode(containing);
            }
        }, 500);
        this.toCancelNodeExpansion.push(disposable_1.Disposable.create(() => clearTimeout(timer)));
    }
    handleDragLeaveEvent(node, event) {
        event.preventDefault();
        event.stopPropagation();
        this.toCancelNodeExpansion.dispose();
    }
    async handleDropEvent(node, event) {
        try {
            event.preventDefault();
            event.stopPropagation();
            event.dataTransfer.dropEffect = 'copy'; // Explicitly show this is a copy.
            const containing = this.getDropTargetDirNode(node);
            if (containing) {
                const resources = this.getSelectedTreeNodesFromData(event.dataTransfer);
                if (resources.length > 0) {
                    for (const treeNode of resources) {
                        await this.model.move(treeNode, containing);
                    }
                }
                else {
                    await this.uploadService.upload(containing.uri, { source: event.dataTransfer });
                }
            }
        }
        catch (e) {
            if (!cancellation_1.isCancelled(e)) {
                console.error(e);
            }
        }
    }
    getDropTargetDirNode(node) {
        if (browser_1.CompositeTreeNode.is(node) && node.id === 'WorkspaceNodeId') {
            if (node.children.length === 1) {
                return file_tree_1.DirNode.getContainingDir(node.children[0]);
            }
            else if (node.children.length > 1) {
                // move file to the last root folder in multi-root scenario
                return file_tree_1.DirNode.getContainingDir(node.children[node.children.length - 1]);
            }
        }
        return file_tree_1.DirNode.getContainingDir(node);
    }
    setTreeNodeAsData(data, node) {
        data.setData('tree-node', node.id);
    }
    setSelectedTreeNodesAsData(data, sourceNode, relatedNodes) {
        this.setTreeNodeAsData(data, sourceNode);
        data.setData('selected-tree-nodes', JSON.stringify(relatedNodes.map(node => node.id)));
    }
    getTreeNodeFromData(data) {
        const id = data.getData('tree-node');
        return this.model.getNode(id);
    }
    getSelectedTreeNodesFromData(data) {
        const resources = data.getData('selected-tree-nodes');
        if (!resources) {
            return [];
        }
        const ids = JSON.parse(resources);
        return ids.map(id => this.model.getNode(id)).filter(node => node !== undefined);
    }
    get hidesExplorerArrows() {
        const theme = this.iconThemeService.getDefinition(this.iconThemeService.current);
        return !!theme && !!theme.hidesExplorerArrows;
    }
    renderExpansionToggle(node, props) {
        if (this.hidesExplorerArrows) {
            // eslint-disable-next-line no-null/no-null
            return null;
        }
        return super.renderExpansionToggle(node, props);
    }
    getPaddingLeft(node, props) {
        if (this.hidesExplorerArrows) {
            // additional left padding instead of top-level expansion toggle
            return super.getPaddingLeft(node, props) + this.props.leftPadding;
        }
        return super.getPaddingLeft(node, props);
    }
    needsExpansionTogglePadding(node) {
        const theme = this.iconThemeService.getDefinition(this.iconThemeService.current);
        if (theme && (theme.hidesExplorerArrows || (theme.hasFileIcons && !theme.hasFolderIcons))) {
            return false;
        }
        return super.needsExpansionTogglePadding(node);
    }
    deflateForStorage(node) {
        const deflated = super.deflateForStorage(node);
        if (file_tree_1.FileStatNode.is(node) && file_tree_1.FileStatNodeData.is(deflated)) {
            deflated.uri = node.uri.toString();
            delete deflated['fileStat'];
            deflated.stat = files_1.FileStat.toStat(node.fileStat);
        }
        return deflated;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    inflateFromStorage(node, parent) {
        if (file_tree_1.FileStatNodeData.is(node)) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const fileStatNode = node;
            const resource = new uri_1.default(node.uri);
            fileStatNode.uri = resource;
            let stat;
            // in order to support deprecated FileStat
            if (node.fileStat) {
                stat = {
                    type: node.fileStat.isDirectory ? files_1.FileType.Directory : files_1.FileType.File,
                    mtime: node.fileStat.lastModification,
                    size: node.fileStat.size
                };
                delete node['fileStat'];
            }
            else if (node.stat) {
                stat = node.stat;
                delete node['stat'];
            }
            if (stat) {
                fileStatNode.fileStat = files_1.FileStat.fromStat(resource, stat);
            }
        }
        const inflated = super.inflateFromStorage(node, parent);
        if (file_tree_1.DirNode.is(inflated)) {
            inflated.fileStat.children = [];
            for (const child of inflated.children) {
                if (file_tree_1.FileStatNode.is(child)) {
                    inflated.fileStat.children.push(child.fileStat);
                }
            }
        }
        return inflated;
    }
};
__decorate([
    inversify_1.inject(file_upload_service_1.FileUploadService),
    __metadata("design:type", file_upload_service_1.FileUploadService)
], FileTreeWidget.prototype, "uploadService", void 0);
__decorate([
    inversify_1.inject(icon_theme_service_1.IconThemeService),
    __metadata("design:type", icon_theme_service_1.IconThemeService)
], FileTreeWidget.prototype, "iconThemeService", void 0);
FileTreeWidget = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(browser_1.TreeProps)),
    __param(1, inversify_1.inject(file_tree_model_1.FileTreeModel)),
    __param(2, inversify_1.inject(browser_1.ContextMenuRenderer)),
    __metadata("design:paramtypes", [Object, file_tree_model_1.FileTreeModel,
        browser_1.ContextMenuRenderer])
], FileTreeWidget);
exports.FileTreeWidget = FileTreeWidget;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DirNode = exports.FileNode = exports.FileStatNodeData = exports.FileStatNode = exports.FileTree = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const files_1 = __webpack_require__(/*! ../../common/files */ "./node_modules/@theia/filesystem/lib/common/files.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "./node_modules/@theia/core/lib/common/message-service.js");
const file_service_1 = __webpack_require__(/*! ../file-service */ "./node_modules/@theia/filesystem/lib/browser/file-service.js");
let FileTree = class FileTree extends browser_1.TreeImpl {
    async resolveChildren(parent) {
        if (FileStatNode.is(parent)) {
            const fileStat = await this.resolveFileStat(parent);
            if (fileStat) {
                return this.toNodes(fileStat, parent);
            }
            return [];
        }
        return super.resolveChildren(parent);
    }
    async resolveFileStat(node) {
        try {
            const fileStat = await this.fileService.resolve(node.uri);
            node.fileStat = fileStat;
            return fileStat;
        }
        catch (e) {
            if (!(e instanceof files_1.FileOperationError && e.fileOperationResult === 1 /* FILE_NOT_FOUND */)) {
                this.messagingService.error(e.message);
            }
            return undefined;
        }
    }
    async toNodes(fileStat, parent) {
        if (!fileStat.children) {
            return [];
        }
        const result = await Promise.all(fileStat.children.map(async (child) => this.toNode(child, parent)));
        return result.sort(DirNode.compare);
    }
    toNode(fileStat, parent) {
        const uri = fileStat.resource;
        const id = this.toNodeId(uri, parent);
        const node = this.getNode(id);
        if (fileStat.isDirectory) {
            if (DirNode.is(node)) {
                node.fileStat = fileStat;
                return node;
            }
            return {
                id, uri, fileStat, parent,
                expanded: false,
                selected: false,
                children: []
            };
        }
        if (FileNode.is(node)) {
            node.fileStat = fileStat;
            return node;
        }
        return {
            id, uri, fileStat, parent,
            selected: false
        };
    }
    toNodeId(uri, parent) {
        return uri.path.toString();
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], FileTree.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], FileTree.prototype, "messagingService", void 0);
FileTree = __decorate([
    inversify_1.injectable()
], FileTree);
exports.FileTree = FileTree;
var FileStatNode;
(function (FileStatNode) {
    function is(node) {
        return !!node && 'fileStat' in node;
    }
    FileStatNode.is = is;
    function getUri(node) {
        if (is(node)) {
            return node.fileStat.resource.toString();
        }
        return undefined;
    }
    FileStatNode.getUri = getUri;
})(FileStatNode = exports.FileStatNode || (exports.FileStatNode = {}));
var FileStatNodeData;
(function (FileStatNodeData) {
    function is(node) {
        return !!node && 'uri' in node && ('fileStat' in node || 'stat' in node);
    }
    FileStatNodeData.is = is;
})(FileStatNodeData = exports.FileStatNodeData || (exports.FileStatNodeData = {}));
var FileNode;
(function (FileNode) {
    function is(node) {
        return FileStatNode.is(node) && !node.fileStat.isDirectory;
    }
    FileNode.is = is;
})(FileNode = exports.FileNode || (exports.FileNode = {}));
var DirNode;
(function (DirNode) {
    function is(node) {
        return FileStatNode.is(node) && node.fileStat.isDirectory;
    }
    DirNode.is = is;
    function compare(node, node2) {
        return DirNode.dirCompare(node, node2) || uriCompare(node, node2);
    }
    DirNode.compare = compare;
    function uriCompare(node, node2) {
        if (FileStatNode.is(node)) {
            if (FileStatNode.is(node2)) {
                return node.uri.displayName.localeCompare(node2.uri.displayName);
            }
            return 1;
        }
        if (FileStatNode.is(node2)) {
            return -1;
        }
        return 0;
    }
    DirNode.uriCompare = uriCompare;
    function dirCompare(node, node2) {
        const a = DirNode.is(node) ? 1 : 0;
        const b = DirNode.is(node2) ? 1 : 0;
        return b - a;
    }
    DirNode.dirCompare = dirCompare;
    function createRoot(fileStat) {
        const uri = fileStat.resource;
        const id = uri.toString();
        return {
            id, uri, fileStat,
            visible: true,
            parent: undefined,
            children: [],
            expanded: true,
            selected: false
        };
    }
    DirNode.createRoot = createRoot;
    function getContainingDir(node) {
        let containing = node;
        while (!!containing && !is(containing)) {
            containing = containing.parent;
        }
        return containing;
    }
    DirNode.getContainingDir = getContainingDir;
})(DirNode = exports.DirNode || (exports.DirNode = {}));


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-tree/index.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-tree/index.js ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./file-tree */ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree.js"), exports);
__exportStar(__webpack_require__(/*! ./file-tree-model */ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree-model.js"), exports);
__exportStar(__webpack_require__(/*! ./file-tree-widget */ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree-widget.js"), exports);
__exportStar(__webpack_require__(/*! ./file-tree-container */ "./node_modules/@theia/filesystem/lib/browser/file-tree/file-tree-container.js"), exports);


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/file-upload-service.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/file-upload-service.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var FileUploadService_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileUploadService = exports.HTTP_UPLOAD_URL = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const cancellation_1 = __webpack_require__(/*! @theia/core/lib/common/cancellation */ "./node_modules/@theia/core/lib/common/cancellation.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "./node_modules/@theia/core/lib/common/promise-util.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "./node_modules/@theia/core/lib/common/message-service.js");
const endpoint_1 = __webpack_require__(/*! @theia/core/lib/browser/endpoint */ "./node_modules/@theia/core/lib/browser/endpoint.js");
const throttle = __webpack_require__(/*! @theia/core/shared/lodash.throttle */ "./node_modules/@theia/core/shared/lodash.throttle/index.js");
const file_upload_1 = __webpack_require__(/*! ../common/file-upload */ "./node_modules/@theia/filesystem/lib/common/file-upload.js");
const async_mutex_1 = __webpack_require__(/*! async-mutex */ "./node_modules/async-mutex/lib/index.js");
const filesystem_preferences_1 = __webpack_require__(/*! ./filesystem-preferences */ "./node_modules/@theia/filesystem/lib/browser/filesystem-preferences.js");
const file_service_1 = __webpack_require__(/*! ./file-service */ "./node_modules/@theia/filesystem/lib/browser/file-service.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "./node_modules/@theia/core/lib/common/nls.js");
exports.HTTP_UPLOAD_URL = new endpoint_1.Endpoint({ path: file_upload_1.HTTP_FILE_UPLOAD_PATH }).getRestUrl().toString(true);
let FileUploadService = FileUploadService_1 = class FileUploadService {
    get maxConcurrentUploads() {
        const maxConcurrentUploads = this.fileSystemPreferences['files.maxConcurrentUploads'];
        return maxConcurrentUploads > 0 ? maxConcurrentUploads : Infinity;
    }
    init() {
        this.uploadForm = this.createUploadForm();
    }
    createUploadForm() {
        const targetInput = document.createElement('input');
        targetInput.type = 'text';
        targetInput.spellcheck = false;
        targetInput.name = FileUploadService_1.TARGET;
        targetInput.classList.add('theia-input');
        const fileInput = document.createElement('input');
        fileInput.type = 'file';
        fileInput.classList.add('theia-input');
        fileInput.name = FileUploadService_1.UPLOAD;
        fileInput.multiple = true;
        const form = document.createElement('form');
        form.style.display = 'none';
        form.enctype = 'multipart/form-data';
        form.append(targetInput);
        form.append(fileInput);
        document.body.appendChild(form);
        fileInput.addEventListener('change', () => {
            if (this.deferredUpload && fileInput.value) {
                const source = new FormData(form);
                // clean up to allow upload to the same folder twice
                fileInput.value = '';
                const targetUri = new uri_1.default(source.get(FileUploadService_1.TARGET));
                const { resolve, reject } = this.deferredUpload;
                this.deferredUpload = undefined;
                const { onDidUpload } = this.uploadForm;
                this.withProgress((progress, token) => this.uploadAll(targetUri, { source, progress, token, onDidUpload }), this.uploadForm.progress).then(resolve, reject);
            }
        });
        return { targetInput, fileInput };
    }
    async upload(targetUri, params = {}) {
        const { source, onDidUpload } = params;
        if (source) {
            return this.withProgress((progress, token) => this.uploadAll(typeof targetUri === 'string' ? new uri_1.default(targetUri) : targetUri, { source, progress, token, onDidUpload }), params.progress);
        }
        this.deferredUpload = new promise_util_1.Deferred();
        this.uploadForm.targetInput.value = String(targetUri);
        this.uploadForm.fileInput.click();
        this.uploadForm.progress = params.progress;
        this.uploadForm.onDidUpload = params.onDidUpload;
        return this.deferredUpload.promise;
    }
    getUploadUrl() {
        return exports.HTTP_UPLOAD_URL;
    }
    async uploadAll(targetUri, params) {
        const responses = [];
        const status = new Map();
        const result = {
            uploaded: []
        };
        /**
         * When `false`: display the uploading progress.
         * When `true`: display the server-processing progress.
         */
        let waitingForResponses = false;
        const report = throttle(() => {
            if (waitingForResponses) {
                /** Number of files being processed. */
                const total = status.size;
                /** Number of files uploaded and processed. */
                let done = 0;
                for (const item of status.values()) {
                    if (item.uploaded) {
                        done += 1;
                    }
                }
                params.progress.report({
                    message: nls_1.nls.localize('theia/filesystem/processedOutOf', 'Processed {0} out of {1}', done, total),
                    work: { total, done }
                });
            }
            else {
                /** Total number of bytes being uploaded. */
                let total = 0;
                /** Current number of bytes uploaded. */
                let done = 0;
                for (const item of status.values()) {
                    total += item.total;
                    done += item.done;
                }
                params.progress.report({
                    message: nls_1.nls.localize('theia/filesystem/uploadedOutOf', 'Uploaded {0} out of {1}', result.uploaded.length, status.size),
                    work: { total, done }
                });
            }
        }, 100);
        const uploads = [];
        const uploadSemaphore = new async_mutex_1.Semaphore(this.maxConcurrentUploads);
        try {
            await this.index(targetUri, params.source, {
                token: params.token,
                progress: params.progress,
                accept: async (item) => {
                    if (await this.fileService.exists(item.uri) && !await this.confirmOverwrite(item.uri)) {
                        return;
                    }
                    // Track and initialize the file in the status map:
                    status.set(item.file, { total: item.file.size, done: 0 });
                    report();
                    // Don't await here: the semaphore will organize the uploading tasks, not the async indexer.
                    uploads.push(uploadSemaphore.runExclusive(async () => {
                        cancellation_1.checkCancelled(params.token);
                        const { upload, response } = this.uploadFile(item.file, item.uri, params.token, (total, done) => {
                            const entry = status.get(item.file);
                            if (entry) {
                                entry.total = total;
                                entry.done = done;
                                report();
                            }
                        });
                        function onError(error) {
                            status.delete(item.file);
                            throw error;
                        }
                        responses.push(response
                            .then(() => {
                            cancellation_1.checkCancelled(params.token);
                            // Consider the file uploaded once the server sends OK back.
                            result.uploaded.push(item.uri.toString(true));
                            const entry = status.get(item.file);
                            if (entry) {
                                entry.uploaded = true;
                                report();
                            }
                        })
                            .catch(onError));
                        // Have the queue wait for the upload only.
                        return upload
                            .catch(onError);
                    }));
                }
            });
            cancellation_1.checkCancelled(params.token);
            await Promise.all(uploads);
            cancellation_1.checkCancelled(params.token);
            waitingForResponses = true;
            report();
            await Promise.all(responses);
        }
        catch (error) {
            uploadSemaphore.cancel();
            if (!cancellation_1.isCancelled(error)) {
                throw error;
            }
        }
        return result;
    }
    async confirmOverwrite(fileUri) {
        const dialog = new browser_1.ConfirmDialog({
            title: nls_1.nls.localizeByDefault('Replace file'),
            msg: nls_1.nls.localizeByDefault('File "{0}" already exists in the destination folder. Do you want to replace it?', fileUri.path.base),
            ok: nls_1.nls.localizeByDefault('Replace file'),
            cancel: browser_1.Dialog.CANCEL
        });
        return !!await dialog.open();
    }
    uploadFile(file, targetUri, token, onProgress) {
        const data = new FormData();
        data.set('uri', targetUri.toString(true));
        data.set('file', file);
        // TODO: Use Fetch API once it supports upload monitoring.
        const xhr = new XMLHttpRequest();
        token.onCancellationRequested(() => xhr.abort());
        const upload = new Promise((resolve, reject) => {
            this.registerEvents(xhr.upload, unregister => ({
                progress: (event) => {
                    if (event.total === event.loaded) {
                        unregister();
                        resolve();
                    }
                    else {
                        onProgress(event.total, event.loaded);
                    }
                },
                abort: () => {
                    unregister();
                    reject(cancellation_1.cancelled());
                },
                error: () => {
                    unregister();
                    reject(new Error('POST upload error'));
                },
                // `load` fires once the response is received, not when the upload is finished.
                // `resolve` should be called earlier within `progress` but this is a safety catch.
                load: () => {
                    unregister();
                    if (xhr.status === 200) {
                        resolve();
                    }
                    else {
                        reject(new Error(`POST request failed: ${xhr.status} ${xhr.statusText}`));
                    }
                },
            }));
        });
        const response = new Promise((resolve, reject) => {
            this.registerEvents(xhr, unregister => ({
                abort: () => {
                    unregister();
                    reject(cancellation_1.cancelled());
                },
                error: () => {
                    unregister();
                    reject(new Error('POST request error'));
                },
                load: () => {
                    unregister();
                    if (xhr.status === 200) {
                        resolve();
                    }
                    else {
                        reject(new Error(`POST request failed: ${xhr.status} ${xhr.statusText}`));
                    }
                }
            }));
        });
        xhr.open('POST', this.getUploadUrl(), /* async: */ true);
        xhr.send(data);
        return {
            upload,
            response
        };
    }
    /**
     * Utility function to attach events and get a callback to unregister those.
     *
     * You may not call `unregister` in the same tick as `register` is invoked.
     */
    registerEvents(target, register) {
        const events = register(() => {
            for (const [event, fn] of Object.entries(events)) {
                target.removeEventListener(event, fn);
            }
        });
        for (const [event, fn] of Object.entries(events)) {
            target.addEventListener(event, fn);
        }
    }
    async withProgress(cb, { text } = { text: nls_1.nls.localize('theia/filesystem/uploadFiles', 'Uploading Files') }) {
        const cancellationSource = new cancellation_1.CancellationTokenSource();
        const { token } = cancellationSource;
        const progress = await this.messageService.showProgress({ text, options: { cancelable: true } }, () => cancellationSource.cancel());
        try {
            return await cb(progress, token);
        }
        finally {
            progress.cancel();
        }
    }
    async index(targetUri, source, context) {
        if (source instanceof FormData) {
            await this.indexFormData(targetUri, source, context);
        }
        else {
            await this.indexDataTransfer(targetUri, source, context);
        }
    }
    async indexFormData(targetUri, formData, context) {
        for (const entry of formData.getAll(FileUploadService_1.UPLOAD)) {
            if (entry instanceof File) {
                await this.indexFile(targetUri, entry, context);
            }
        }
    }
    async indexDataTransfer(targetUri, dataTransfer, context) {
        cancellation_1.checkCancelled(context.token);
        if (dataTransfer.items) {
            await this.indexDataTransferItemList(targetUri, dataTransfer.items, context);
        }
        else {
            await this.indexFileList(targetUri, dataTransfer.files, context);
        }
    }
    async indexFileList(targetUri, files, context) {
        for (let i = 0; i < files.length; i++) {
            const file = files[i];
            if (file) {
                await this.indexFile(targetUri, file, context);
            }
        }
    }
    async indexFile(targetUri, file, context) {
        await context.accept({
            uri: targetUri.resolve(file.name),
            file
        });
    }
    async indexDataTransferItemList(targetUri, items, context) {
        cancellation_1.checkCancelled(context.token);
        const entries = [];
        for (let i = 0; i < items.length; i++) {
            const entry = items[i].webkitGetAsEntry();
            entries.push(entry);
        }
        await this.indexEntries(targetUri, entries, context);
    }
    async indexEntry(targetUri, entry, context) {
        cancellation_1.checkCancelled(context.token);
        if (!entry) {
            return;
        }
        if (entry.isDirectory) {
            await this.indexDirectoryEntry(targetUri, entry, context);
        }
        else {
            await this.indexFileEntry(targetUri, entry, context);
        }
    }
    /**
     *  Read all entries within a folder by block of 100 files or folders until the
     *  whole folder has been read.
     */
    async indexDirectoryEntry(targetUri, entry, context) {
        cancellation_1.checkCancelled(context.token);
        const newTargetUri = targetUri.resolve(entry.name);
        return new Promise(async (resolve, reject) => {
            const reader = entry.createReader();
            const getEntries = () => reader.readEntries(async (results) => {
                try {
                    if (!context.token.isCancellationRequested && results && results.length) {
                        await this.indexEntries(newTargetUri, results, context);
                        getEntries(); // loop to read all getEntries
                    }
                    else {
                        resolve();
                    }
                }
                catch (e) {
                    reject(e);
                }
            }, reject);
            getEntries();
        });
    }
    async indexEntries(targetUri, entries, context) {
        cancellation_1.checkCancelled(context.token);
        for (let i = 0; i < entries.length; i++) {
            await this.indexEntry(targetUri, entries[i], context);
        }
    }
    async indexFileEntry(targetUri, entry, context) {
        await new Promise((resolve, reject) => {
            try {
                entry.file(file => this.indexFile(targetUri, file, context).then(resolve, reject), reject);
            }
            catch (e) {
                reject(e);
            }
        });
    }
};
FileUploadService.TARGET = 'target';
FileUploadService.UPLOAD = 'upload';
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], FileUploadService.prototype, "messageService", void 0);
__decorate([
    inversify_1.inject(filesystem_preferences_1.FileSystemPreferences),
    __metadata("design:type", Object)
], FileUploadService.prototype, "fileSystemPreferences", void 0);
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], FileUploadService.prototype, "fileService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], FileUploadService.prototype, "init", null);
FileUploadService = FileUploadService_1 = __decorate([
    inversify_1.injectable()
], FileUploadService);
exports.FileUploadService = FileUploadService;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/location/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/location/index.js ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./location-service */ "./node_modules/@theia/filesystem/lib/browser/location/location-service.js"), exports);
__exportStar(__webpack_require__(/*! ./location-renderer */ "./node_modules/@theia/filesystem/lib/browser/location/location-renderer.js"), exports);


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/location/location-renderer.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/location/location-renderer.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var LocationListRenderer_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LocationListRenderer = exports.LocationListRendererOptions = exports.LocationListRendererFactory = void 0;
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
const ReactDOM = __webpack_require__(/*! @theia/core/shared/react-dom */ "./node_modules/@theia/core/shared/react-dom/index.js");
const file_service_1 = __webpack_require__(/*! ../file-service */ "./node_modules/@theia/filesystem/lib/browser/file-service.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const env_variables_1 = __webpack_require__(/*! @theia/core/lib/common/env-variables */ "./node_modules/@theia/core/lib/common/env-variables/index.js");
const react_renderer_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/react-renderer */ "./node_modules/@theia/core/lib/browser/widgets/react-renderer.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
class ResolvedDirectoryCache {
    constructor(fileService) {
        this.fileService = fileService;
        this.pendingResolvedDirectories = new Map();
        this.cachedDirectories = new Map();
        this.directoryResolvedEmitter = new common_1.Emitter();
        this.onDirectoryDidResolve = this.directoryResolvedEmitter.event;
    }
    tryResolveChildDirectories(inputAsURI) {
        const parentDirectory = inputAsURI.path.dir.toString();
        const cachedDirectories = this.cachedDirectories.get(parentDirectory);
        const pendingDirectories = this.pendingResolvedDirectories.get(parentDirectory);
        if (cachedDirectories) {
            return cachedDirectories;
        }
        else if (!pendingDirectories) {
            this.pendingResolvedDirectories.set(parentDirectory, this.createResolutionPromise(parentDirectory));
        }
        return undefined;
    }
    async createResolutionPromise(directoryToResolve) {
        return this.fileService.resolve(new uri_1.default(directoryToResolve)).then(({ children }) => {
            if (children) {
                const childDirectories = children.filter(child => child.isDirectory)
                    .map(directory => `${directory.resource.path}/`);
                this.cachedDirectories.set(directoryToResolve, childDirectories);
                this.directoryResolvedEmitter.fire({ parent: directoryToResolve, children: childDirectories });
            }
        }).catch(e => {
            // no-op
        });
    }
}
exports.LocationListRendererFactory = Symbol('LocationListRendererFactory');
exports.LocationListRendererOptions = Symbol('LocationListRendererOptions');
let LocationListRenderer = LocationListRenderer_1 = class LocationListRenderer extends react_renderer_1.ReactRenderer {
    constructor(options) {
        super(options.host);
        this.options = options;
        this.toDisposeOnNewCache = new common_1.DisposableCollection();
        this._doShowTextInput = false;
        this.doAttemptAutocomplete = true;
        this.doAfterRender = () => {
            const locationList = this.locationList;
            const locationListTextInput = this.locationTextInput;
            if (locationList) {
                const currentLocation = this.service.location;
                locationList.value = currentLocation ? currentLocation.toString() : '';
            }
            else if (locationListTextInput) {
                locationListTextInput.focus();
            }
        };
        this.handleLocationChanged = (e) => this.onLocationChanged(e);
        this.handleTextInputOnChange = (e) => this.trySuggestDirectory(e);
        this.handleTextInputKeyDown = (e) => this.handleControlKeys(e);
        this.handleIconKeyDown = (e) => this.toggleInputOnKeyDown(e);
        this.handleTextInputOnBlur = () => this.toggleToSelectInput();
        this.handleTextInputMouseDown = (e) => this.toggleToTextInputOnMouseDown(e);
        this.service = options.model;
        this.doLoadDrives();
    }
    get doShowTextInput() {
        return this._doShowTextInput;
    }
    set doShowTextInput(doShow) {
        this._doShowTextInput = doShow;
        if (doShow) {
            this.initResolveDirectoryCache();
        }
    }
    async init() {
        const homeDirWithPrefix = await this.variablesServer.getHomeDirUri();
        this.homeDir = (new uri_1.default(homeDirWithPrefix)).path.toString();
    }
    render() {
        ReactDOM.render(this.doRender(), this.host, this.doAfterRender);
    }
    initResolveDirectoryCache() {
        this.toDisposeOnNewCache.dispose();
        this.directoryCache = new ResolvedDirectoryCache(this.fileService);
        this.toDisposeOnNewCache.push(this.directoryCache.onDirectoryDidResolve(({ parent, children }) => {
            if (this.locationTextInput) {
                const expandedPath = common_1.Path.untildify(this.locationTextInput.value, this.homeDir);
                const inputParent = (new uri_1.default(expandedPath)).path.dir.toString();
                if (inputParent === parent) {
                    this.tryRenderFirstMatch(this.locationTextInput, children);
                }
            }
        }));
    }
    doRender() {
        return (React.createElement(React.Fragment, null,
            this.renderInputIcon(),
            this.doShowTextInput
                ? this.renderTextInput()
                : this.renderSelectInput()));
    }
    renderInputIcon() {
        return (React.createElement("span", { 
            // onMouseDown is used since it will fire before 'onBlur'. This prevents
            // a re-render when textinput is in focus and user clicks toggle icon
            onMouseDown: this.handleTextInputMouseDown, onKeyDown: this.handleIconKeyDown, className: LocationListRenderer_1.Styles.LOCATION_INPUT_TOGGLE_CLASS, tabIndex: 0, id: `${this.doShowTextInput ? 'text-input' : 'select-input'}`, title: this.doShowTextInput
                ? LocationListRenderer_1.Tooltips.TOGGLE_SELECT_INPUT
                : LocationListRenderer_1.Tooltips.TOGGLE_TEXT_INPUT },
            React.createElement("i", { className: browser_1.codicon(this.doShowTextInput ? 'folder-opened' : 'edit') })));
    }
    renderTextInput() {
        var _a;
        return (React.createElement("input", { className: 'theia-select ' + LocationListRenderer_1.Styles.LOCATION_TEXT_INPUT_CLASS, defaultValue: (_a = this.service.location) === null || _a === void 0 ? void 0 : _a.path.toString(), onBlur: this.handleTextInputOnBlur, onChange: this.handleTextInputOnChange, onKeyDown: this.handleTextInputKeyDown, spellCheck: false }));
    }
    renderSelectInput() {
        const options = this.collectLocations().map(value => this.renderLocation(value));
        return (React.createElement("select", { className: `theia-select ${LocationListRenderer_1.Styles.LOCATION_LIST_CLASS}`, onChange: this.handleLocationChanged }, options));
    }
    toggleInputOnKeyDown(e) {
        if (e.key === 'Enter') {
            this.doShowTextInput = true;
            this.render();
        }
    }
    toggleToTextInputOnMouseDown(e) {
        if (e.currentTarget.id === 'select-input') {
            e.preventDefault();
            this.doShowTextInput = true;
            this.render();
        }
    }
    toggleToSelectInput() {
        if (this.doShowTextInput) {
            this.doShowTextInput = false;
            this.render();
        }
    }
    /**
     * Collects the available locations based on the currently selected, and appends the available drives to it.
     */
    collectLocations() {
        const location = this.service.location;
        const locations = (!!location ? location.allLocations : []).map(uri => ({ uri }));
        if (this._drives) {
            const drives = this._drives.map(uri => ({ uri, isDrive: true }));
            // `URI.allLocations` returns with the URI without the trailing slash unlike `FileUri.create(fsPath)`.
            // to be able to compare file:///path/to/resource with file:///path/to/resource/.
            const toUriString = (uri) => {
                const toString = uri.toString();
                return toString.endsWith('/') ? toString.slice(0, -1) : toString;
            };
            drives.forEach(drive => {
                const index = locations.findIndex(loc => toUriString(loc.uri) === toUriString(drive.uri));
                // Ignore drives which are already discovered as a location based on the current model root URI.
                if (index === -1) {
                    // Make sure, it does not have the trailing slash.
                    locations.push({ uri: new uri_1.default(toUriString(drive.uri)), isDrive: true });
                }
                else {
                    // This is necessary for Windows to be able to show `/e:/` as a drive and `c:` as "non-drive" in the same way.
                    // `URI.path.toString()` Vs. `URI.displayName` behaves a bit differently on Windows.
                    // https://github.com/eclipse-theia/theia/pull/3038#issuecomment-425944189
                    locations[index].isDrive = true;
                }
            });
        }
        this.doLoadDrives();
        return locations;
    }
    /**
     * Asynchronously loads the drives (if not yet available) and triggers a UI update on success with the new values.
     */
    doLoadDrives() {
        if (!this._drives) {
            this.service.drives().then(drives => {
                // If the `drives` are empty, something already went wrong.
                if (drives.length > 0) {
                    this._drives = drives;
                    this.render();
                }
            });
        }
    }
    renderLocation(location) {
        const { uri, isDrive } = location;
        const value = uri.toString();
        return React.createElement("option", { value: value, key: uri.toString() }, isDrive ? uri.path.toString() : uri.displayName);
    }
    onLocationChanged(e) {
        const locationList = this.locationList;
        if (locationList) {
            const value = locationList.value;
            const uri = new uri_1.default(value);
            this.trySetNewLocation(uri);
            e.preventDefault();
            e.stopPropagation();
        }
    }
    trySetNewLocation(newLocation) {
        var _a;
        if (this.lastUniqueTextInputLocation === undefined) {
            this.lastUniqueTextInputLocation = this.service.location;
        }
        // prevent consecutive repeated locations from being added to location history
        if (((_a = this.lastUniqueTextInputLocation) === null || _a === void 0 ? void 0 : _a.path.toString()) !== newLocation.path.toString()) {
            this.lastUniqueTextInputLocation = newLocation;
            this.service.location = newLocation;
        }
    }
    trySuggestDirectory(e) {
        if (this.doAttemptAutocomplete) {
            const inputElement = e.currentTarget;
            const { value } = inputElement;
            if ((value.startsWith('/') || value.startsWith('~/')) && value.slice(-1) !== '/') {
                const expandedPath = common_1.Path.untildify(value, this.homeDir);
                const valueAsURI = new uri_1.default(expandedPath);
                const autocompleteDirectories = this.directoryCache.tryResolveChildDirectories(valueAsURI);
                if (autocompleteDirectories) {
                    this.tryRenderFirstMatch(inputElement, autocompleteDirectories);
                }
            }
        }
    }
    tryRenderFirstMatch(inputElement, children) {
        const { value, selectionStart } = inputElement;
        if (this.locationTextInput) {
            const expandedPath = common_1.Path.untildify(value, this.homeDir);
            const firstMatch = children === null || children === void 0 ? void 0 : children.find(child => child.includes(expandedPath));
            if (firstMatch) {
                const contractedPath = value.startsWith('~') ? common_1.Path.tildify(firstMatch, this.homeDir) : firstMatch;
                this.locationTextInput.value = contractedPath;
                this.locationTextInput.selectionStart = selectionStart;
                this.locationTextInput.selectionEnd = firstMatch.length;
            }
        }
    }
    handleControlKeys(e) {
        this.doAttemptAutocomplete = e.key !== 'Backspace';
        if (e.key === 'Enter') {
            const locationTextInput = this.locationTextInput;
            if (locationTextInput) {
                // expand '~' if present and remove extra whitespace and any trailing slashes or periods.
                const sanitizedInput = locationTextInput.value.trim().replace(/[\/\\.]*$/, '');
                const untildifiedInput = common_1.Path.untildify(sanitizedInput, this.homeDir);
                const uri = new uri_1.default(untildifiedInput);
                this.trySetNewLocation(uri);
                this.toggleToSelectInput();
            }
        }
        else if (e.key === 'Escape') {
            this.toggleToSelectInput();
        }
        else if (e.key === 'Tab') {
            e.preventDefault();
            const textInput = this.locationTextInput;
            if (textInput) {
                textInput.selectionStart = textInput.value.length;
            }
        }
        e.stopPropagation();
    }
    get locationList() {
        const locationList = this.host.getElementsByClassName(LocationListRenderer_1.Styles.LOCATION_LIST_CLASS)[0];
        if (locationList instanceof HTMLSelectElement) {
            return locationList;
        }
        return undefined;
    }
    get locationTextInput() {
        const locationTextInput = this.host.getElementsByClassName(LocationListRenderer_1.Styles.LOCATION_TEXT_INPUT_CLASS)[0];
        if (locationTextInput instanceof HTMLInputElement) {
            return locationTextInput;
        }
        return undefined;
    }
    dispose() {
        super.dispose();
        this.toDisposeOnNewCache.dispose();
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], LocationListRenderer.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(env_variables_1.EnvVariablesServer),
    __metadata("design:type", Object)
], LocationListRenderer.prototype, "variablesServer", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], LocationListRenderer.prototype, "init", null);
LocationListRenderer = LocationListRenderer_1 = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(exports.LocationListRendererOptions)),
    __metadata("design:paramtypes", [Object])
], LocationListRenderer);
exports.LocationListRenderer = LocationListRenderer;
(function (LocationListRenderer) {
    let Styles;
    (function (Styles) {
        Styles.LOCATION_LIST_CLASS = 'theia-LocationList';
        Styles.LOCATION_INPUT_TOGGLE_CLASS = 'theia-LocationInputToggle';
        Styles.LOCATION_TEXT_INPUT_CLASS = 'theia-LocationTextInput';
    })(Styles = LocationListRenderer.Styles || (LocationListRenderer.Styles = {}));
    let Tooltips;
    (function (Tooltips) {
        Tooltips.TOGGLE_TEXT_INPUT = 'Switch to text-based input';
        Tooltips.TOGGLE_SELECT_INPUT = 'Switch to location list';
    })(Tooltips = LocationListRenderer.Tooltips || (LocationListRenderer.Tooltips = {}));
})(LocationListRenderer = exports.LocationListRenderer || (exports.LocationListRenderer = {}));
exports.LocationListRenderer = LocationListRenderer;


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/browser/location/location-service.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/browser/location/location-service.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/common/file-upload.js":
/*!******************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/common/file-upload.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HTTP_FILE_UPLOAD_PATH = void 0;
exports.HTTP_FILE_UPLOAD_PATH = '/file-upload';


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/common/filesystem.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/common/filesystem.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileSystemError = exports.FileStat = exports.FileAccess = exports.FileSystem = void 0;
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
/**
 * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908), use `FileService` instead
 */
exports.FileSystem = Symbol('FileSystem');
/**
 * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908), use `FileService.access` instead
 */
var FileAccess;
(function (FileAccess) {
    let Constants;
    (function (Constants) {
        /**
         * Flag indicating that the file is visible to the calling process.
         * This is useful for determining if a file exists, but says nothing about rwx permissions. Default if no mode is specified.
         */
        Constants.F_OK = 0;
        /**
         * Flag indicating that the file can be read by the calling process.
         */
        Constants.R_OK = 4;
        /**
         * Flag indicating that the file can be written by the calling process.
         */
        Constants.W_OK = 2;
        /**
         * Flag indicating that the file can be executed by the calling process.
         * This has no effect on Windows (will behave like `FileAccess.F_OK`).
         */
        Constants.X_OK = 1;
    })(Constants = FileAccess.Constants || (FileAccess.Constants = {}));
})(FileAccess = exports.FileAccess || (exports.FileAccess = {}));
var FileStat;
(function (FileStat) {
    function is(candidate) {
        return typeof candidate === 'object' && ('uri' in candidate) && ('lastModification' in candidate) && ('isDirectory' in candidate);
    }
    FileStat.is = is;
    function equals(one, other) {
        if (!one || !other || !is(one) || !is(other)) {
            return false;
        }
        return one.uri === other.uri
            && one.lastModification === other.lastModification
            && one.isDirectory === other.isDirectory;
    }
    FileStat.equals = equals;
})(FileStat = exports.FileStat || (exports.FileStat = {}));
/**
 * @deprecated since 1.4.0 - in order to support VS Code FS API (https://github.com/eclipse-theia/theia/pull/7908), use `FileOperationError` instead
 */
var FileSystemError;
(function (FileSystemError) {
    FileSystemError.FileNotFound = common_1.ApplicationError.declare(-33000, (uri, prefix) => ({
        message: `${prefix ? prefix + ' ' : ''}'${uri}' has not been found.`,
        data: { uri }
    }));
    FileSystemError.FileExists = common_1.ApplicationError.declare(-33001, (uri, prefix) => ({
        message: `${prefix ? prefix + ' ' : ''}'${uri}' already exists.`,
        data: { uri }
    }));
    FileSystemError.FileIsDirectory = common_1.ApplicationError.declare(-33002, (uri, prefix) => ({
        message: `${prefix ? prefix + ' ' : ''}'${uri}' is a directory.`,
        data: { uri }
    }));
    FileSystemError.FileNotDirectory = common_1.ApplicationError.declare(-33003, (uri, prefix) => ({
        message: `${prefix ? prefix + ' ' : ''}'${uri}' is not a directory.`,
        data: { uri }
    }));
    FileSystemError.FileIsOutOfSync = common_1.ApplicationError.declare(-33004, (file, stat) => ({
        message: `'${file.uri}' is out of sync.`,
        data: { file, stat }
    }));
})(FileSystemError = exports.FileSystemError || (exports.FileSystemError = {}));


/***/ }),

/***/ "./node_modules/@theia/filesystem/lib/common/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@theia/filesystem/lib/common/index.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./filesystem */ "./node_modules/@theia/filesystem/lib/common/filesystem.js"), exports);
__exportStar(__webpack_require__(/*! ./filesystem-utils */ "./node_modules/@theia/filesystem/lib/common/filesystem-utils.js"), exports);


/***/ }),

/***/ "./node_modules/async-mutex/lib/Mutex.js":
/*!***********************************************!*\
  !*** ./node_modules/async-mutex/lib/Mutex.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(/*! tslib */ "./node_modules/async-mutex/node_modules/tslib/tslib.es6.js");
var Semaphore_1 = __webpack_require__(/*! ./Semaphore */ "./node_modules/async-mutex/lib/Semaphore.js");
var Mutex = /** @class */ (function () {
    function Mutex(cancelError) {
        this._semaphore = new Semaphore_1.default(1, cancelError);
    }
    Mutex.prototype.acquire = function () {
        return (0, tslib_1.__awaiter)(this, void 0, void 0, function () {
            var _a, releaser;
            return (0, tslib_1.__generator)(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this._semaphore.acquire()];
                    case 1:
                        _a = _b.sent(), releaser = _a[1];
                        return [2 /*return*/, releaser];
                }
            });
        });
    };
    Mutex.prototype.runExclusive = function (callback) {
        return this._semaphore.runExclusive(function () { return callback(); });
    };
    Mutex.prototype.isLocked = function () {
        return this._semaphore.isLocked();
    };
    Mutex.prototype.waitForUnlock = function () {
        return this._semaphore.waitForUnlock();
    };
    /** @deprecated Deprecated in 0.3.0, will be removed in 0.4.0. Use runExclusive instead. */
    Mutex.prototype.release = function () {
        this._semaphore.release();
    };
    Mutex.prototype.cancel = function () {
        return this._semaphore.cancel();
    };
    return Mutex;
}());
exports["default"] = Mutex;


/***/ }),

/***/ "./node_modules/async-mutex/lib/Semaphore.js":
/*!***************************************************!*\
  !*** ./node_modules/async-mutex/lib/Semaphore.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(/*! tslib */ "./node_modules/async-mutex/node_modules/tslib/tslib.es6.js");
var errors_1 = __webpack_require__(/*! ./errors */ "./node_modules/async-mutex/lib/errors.js");
var Semaphore = /** @class */ (function () {
    function Semaphore(_maxConcurrency, _cancelError) {
        if (_cancelError === void 0) { _cancelError = errors_1.E_CANCELED; }
        this._maxConcurrency = _maxConcurrency;
        this._cancelError = _cancelError;
        this._queue = [];
        this._waiters = [];
        if (_maxConcurrency <= 0) {
            throw new Error('semaphore must be initialized to a positive value');
        }
        this._value = _maxConcurrency;
    }
    Semaphore.prototype.acquire = function () {
        var _this = this;
        var locked = this.isLocked();
        var ticketPromise = new Promise(function (resolve, reject) {
            return _this._queue.push({ resolve: resolve, reject: reject });
        });
        if (!locked)
            this._dispatch();
        return ticketPromise;
    };
    Semaphore.prototype.runExclusive = function (callback) {
        return (0, tslib_1.__awaiter)(this, void 0, void 0, function () {
            var _a, value, release;
            return (0, tslib_1.__generator)(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.acquire()];
                    case 1:
                        _a = _b.sent(), value = _a[0], release = _a[1];
                        _b.label = 2;
                    case 2:
                        _b.trys.push([2, , 4, 5]);
                        return [4 /*yield*/, callback(value)];
                    case 3: return [2 /*return*/, _b.sent()];
                    case 4:
                        release();
                        return [7 /*endfinally*/];
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    Semaphore.prototype.waitForUnlock = function () {
        return (0, tslib_1.__awaiter)(this, void 0, void 0, function () {
            var waitPromise;
            var _this = this;
            return (0, tslib_1.__generator)(this, function (_a) {
                if (!this.isLocked()) {
                    return [2 /*return*/, Promise.resolve()];
                }
                waitPromise = new Promise(function (resolve) { return _this._waiters.push({ resolve: resolve }); });
                return [2 /*return*/, waitPromise];
            });
        });
    };
    Semaphore.prototype.isLocked = function () {
        return this._value <= 0;
    };
    /** @deprecated Deprecated in 0.3.0, will be removed in 0.4.0. Use runExclusive instead. */
    Semaphore.prototype.release = function () {
        if (this._maxConcurrency > 1) {
            throw new Error('this method is unavailable on semaphores with concurrency > 1; use the scoped release returned by acquire instead');
        }
        if (this._currentReleaser) {
            var releaser = this._currentReleaser;
            this._currentReleaser = undefined;
            releaser();
        }
    };
    Semaphore.prototype.cancel = function () {
        var _this = this;
        this._queue.forEach(function (ticket) { return ticket.reject(_this._cancelError); });
        this._queue = [];
    };
    Semaphore.prototype._dispatch = function () {
        var _this = this;
        var nextTicket = this._queue.shift();
        if (!nextTicket)
            return;
        var released = false;
        this._currentReleaser = function () {
            if (released)
                return;
            released = true;
            _this._value++;
            _this._resolveWaiters();
            _this._dispatch();
        };
        nextTicket.resolve([this._value--, this._currentReleaser]);
    };
    Semaphore.prototype._resolveWaiters = function () {
        this._waiters.forEach(function (waiter) { return waiter.resolve(); });
        this._waiters = [];
    };
    return Semaphore;
}());
exports["default"] = Semaphore;


/***/ }),

/***/ "./node_modules/async-mutex/lib/errors.js":
/*!************************************************!*\
  !*** ./node_modules/async-mutex/lib/errors.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.E_CANCELED = exports.E_ALREADY_LOCKED = exports.E_TIMEOUT = void 0;
exports.E_TIMEOUT = new Error('timeout while waiting for mutex to become available');
exports.E_ALREADY_LOCKED = new Error('mutex already locked');
exports.E_CANCELED = new Error('request for lock canceled');


/***/ }),

/***/ "./node_modules/async-mutex/lib/index.js":
/*!***********************************************!*\
  !*** ./node_modules/async-mutex/lib/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.tryAcquire = exports.withTimeout = exports.Semaphore = exports.Mutex = void 0;
var tslib_1 = __webpack_require__(/*! tslib */ "./node_modules/async-mutex/node_modules/tslib/tslib.es6.js");
var Mutex_1 = __webpack_require__(/*! ./Mutex */ "./node_modules/async-mutex/lib/Mutex.js");
Object.defineProperty(exports, "Mutex", ({ enumerable: true, get: function () { return Mutex_1.default; } }));
var Semaphore_1 = __webpack_require__(/*! ./Semaphore */ "./node_modules/async-mutex/lib/Semaphore.js");
Object.defineProperty(exports, "Semaphore", ({ enumerable: true, get: function () { return Semaphore_1.default; } }));
var withTimeout_1 = __webpack_require__(/*! ./withTimeout */ "./node_modules/async-mutex/lib/withTimeout.js");
Object.defineProperty(exports, "withTimeout", ({ enumerable: true, get: function () { return withTimeout_1.withTimeout; } }));
var tryAcquire_1 = __webpack_require__(/*! ./tryAcquire */ "./node_modules/async-mutex/lib/tryAcquire.js");
Object.defineProperty(exports, "tryAcquire", ({ enumerable: true, get: function () { return tryAcquire_1.tryAcquire; } }));
(0, tslib_1.__exportStar)(__webpack_require__(/*! ./errors */ "./node_modules/async-mutex/lib/errors.js"), exports);


/***/ }),

/***/ "./node_modules/async-mutex/lib/tryAcquire.js":
/*!****************************************************!*\
  !*** ./node_modules/async-mutex/lib/tryAcquire.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.tryAcquire = void 0;
var errors_1 = __webpack_require__(/*! ./errors */ "./node_modules/async-mutex/lib/errors.js");
var withTimeout_1 = __webpack_require__(/*! ./withTimeout */ "./node_modules/async-mutex/lib/withTimeout.js");
// eslint-disable-next-lisne @typescript-eslint/explicit-module-boundary-types
function tryAcquire(sync, alreadyAcquiredError) {
    if (alreadyAcquiredError === void 0) { alreadyAcquiredError = errors_1.E_ALREADY_LOCKED; }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return (0, withTimeout_1.withTimeout)(sync, 0, alreadyAcquiredError);
}
exports.tryAcquire = tryAcquire;


/***/ }),

/***/ "./node_modules/async-mutex/lib/withTimeout.js":
/*!*****************************************************!*\
  !*** ./node_modules/async-mutex/lib/withTimeout.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.withTimeout = void 0;
var tslib_1 = __webpack_require__(/*! tslib */ "./node_modules/async-mutex/node_modules/tslib/tslib.es6.js");
var errors_1 = __webpack_require__(/*! ./errors */ "./node_modules/async-mutex/lib/errors.js");
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function withTimeout(sync, timeout, timeoutError) {
    var _this = this;
    if (timeoutError === void 0) { timeoutError = errors_1.E_TIMEOUT; }
    return {
        acquire: function () {
            return new Promise(function (resolve, reject) { return (0, tslib_1.__awaiter)(_this, void 0, void 0, function () {
                var isTimeout, handle, ticket, release, e_1;
                return (0, tslib_1.__generator)(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            isTimeout = false;
                            handle = setTimeout(function () {
                                isTimeout = true;
                                reject(timeoutError);
                            }, timeout);
                            _a.label = 1;
                        case 1:
                            _a.trys.push([1, 3, , 4]);
                            return [4 /*yield*/, sync.acquire()];
                        case 2:
                            ticket = _a.sent();
                            if (isTimeout) {
                                release = Array.isArray(ticket) ? ticket[1] : ticket;
                                release();
                            }
                            else {
                                clearTimeout(handle);
                                resolve(ticket);
                            }
                            return [3 /*break*/, 4];
                        case 3:
                            e_1 = _a.sent();
                            if (!isTimeout) {
                                clearTimeout(handle);
                                reject(e_1);
                            }
                            return [3 /*break*/, 4];
                        case 4: return [2 /*return*/];
                    }
                });
            }); });
        },
        runExclusive: function (callback) {
            return (0, tslib_1.__awaiter)(this, void 0, void 0, function () {
                var release, ticket;
                return (0, tslib_1.__generator)(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            release = function () { return undefined; };
                            _a.label = 1;
                        case 1:
                            _a.trys.push([1, , 7, 8]);
                            return [4 /*yield*/, this.acquire()];
                        case 2:
                            ticket = _a.sent();
                            if (!Array.isArray(ticket)) return [3 /*break*/, 4];
                            release = ticket[1];
                            return [4 /*yield*/, callback(ticket[0])];
                        case 3: return [2 /*return*/, _a.sent()];
                        case 4:
                            release = ticket;
                            return [4 /*yield*/, callback()];
                        case 5: return [2 /*return*/, _a.sent()];
                        case 6: return [3 /*break*/, 8];
                        case 7:
                            release();
                            return [7 /*endfinally*/];
                        case 8: return [2 /*return*/];
                    }
                });
            });
        },
        /** @deprecated Deprecated in 0.3.0, will be removed in 0.4.0. Use runExclusive instead. */
        release: function () {
            sync.release();
        },
        cancel: function () {
            return sync.cancel();
        },
        waitForUnlock: function () { return sync.waitForUnlock(); },
        isLocked: function () { return sync.isLocked(); },
    };
}
exports.withTimeout = withTimeout;


/***/ }),

/***/ "./node_modules/async-mutex/node_modules/tslib/tslib.es6.js":
/*!******************************************************************!*\
  !*** ./node_modules/async-mutex/node_modules/tslib/tslib.es6.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "__extends": () => (/* binding */ __extends),
/* harmony export */   "__assign": () => (/* binding */ __assign),
/* harmony export */   "__rest": () => (/* binding */ __rest),
/* harmony export */   "__decorate": () => (/* binding */ __decorate),
/* harmony export */   "__param": () => (/* binding */ __param),
/* harmony export */   "__metadata": () => (/* binding */ __metadata),
/* harmony export */   "__awaiter": () => (/* binding */ __awaiter),
/* harmony export */   "__generator": () => (/* binding */ __generator),
/* harmony export */   "__createBinding": () => (/* binding */ __createBinding),
/* harmony export */   "__exportStar": () => (/* binding */ __exportStar),
/* harmony export */   "__values": () => (/* binding */ __values),
/* harmony export */   "__read": () => (/* binding */ __read),
/* harmony export */   "__spread": () => (/* binding */ __spread),
/* harmony export */   "__spreadArrays": () => (/* binding */ __spreadArrays),
/* harmony export */   "__spreadArray": () => (/* binding */ __spreadArray),
/* harmony export */   "__await": () => (/* binding */ __await),
/* harmony export */   "__asyncGenerator": () => (/* binding */ __asyncGenerator),
/* harmony export */   "__asyncDelegator": () => (/* binding */ __asyncDelegator),
/* harmony export */   "__asyncValues": () => (/* binding */ __asyncValues),
/* harmony export */   "__makeTemplateObject": () => (/* binding */ __makeTemplateObject),
/* harmony export */   "__importStar": () => (/* binding */ __importStar),
/* harmony export */   "__importDefault": () => (/* binding */ __importDefault),
/* harmony export */   "__classPrivateFieldGet": () => (/* binding */ __classPrivateFieldGet),
/* harmony export */   "__classPrivateFieldSet": () => (/* binding */ __classPrivateFieldSet)
/* harmony export */ });
/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_filesystem_lib_browser_file-dialog_index_js.bundle.js.map