"use strict";
(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_core_lib_electron-browser_window_electron-window-service_js"],{

/***/ "./node_modules/@theia/core/lib/browser/window/default-window-service.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@theia/core/lib/browser/window/default-window-service.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultWindowService = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const common_1 = __webpack_require__(/*! ../../common */ "./node_modules/@theia/core/lib/common/index.js");
const core_preferences_1 = __webpack_require__(/*! ../core-preferences */ "./node_modules/@theia/core/lib/browser/core-preferences.js");
const contribution_provider_1 = __webpack_require__(/*! ../../common/contribution-provider */ "./node_modules/@theia/core/lib/common/contribution-provider.js");
const frontend_application_1 = __webpack_require__(/*! ../frontend-application */ "./node_modules/@theia/core/lib/browser/frontend-application.js");
const window_1 = __webpack_require__(/*! ../../common/window */ "./node_modules/@theia/core/lib/common/window.js");
const dialogs_1 = __webpack_require__(/*! ../dialogs */ "./node_modules/@theia/core/lib/browser/dialogs.js");
let DefaultWindowService = class DefaultWindowService {
    constructor() {
        this.allowVetoes = true;
        this.onUnloadEmitter = new common_1.Emitter();
    }
    get onUnload() {
        return this.onUnloadEmitter.event;
    }
    onStart(app) {
        this.frontendApplication = app;
        this.registerUnloadListeners();
    }
    openNewWindow(url) {
        window.open(url, undefined, 'noopener');
        return undefined;
    }
    openNewDefaultWindow() {
        this.openNewWindow(`#${window_1.DEFAULT_WINDOW_HASH}`);
    }
    /**
     * Returns a list of actions that {@link FrontendApplicationContribution}s would like to take before shutdown
     * It is expected that this will succeed - i.e. return an empty array - at most once per session. If no vetoes are received
     * during any cycle, no further checks will be made. In that case, shutdown should proceed unconditionally.
     */
    collectContributionUnloadVetoes() {
        var _a;
        const vetoes = [];
        if (this.allowVetoes) {
            const shouldConfirmExit = this.corePreferences['application.confirmExit'];
            for (const contribution of this.contributions.getContributions()) {
                const veto = (_a = contribution.onWillStop) === null || _a === void 0 ? void 0 : _a.call(contribution, this.frontendApplication);
                if (veto && shouldConfirmExit !== 'never') { // Ignore vetoes if we should not prompt the user on exit.
                    if (frontend_application_1.OnWillStopAction.is(veto)) {
                        vetoes.push(veto);
                    }
                    else {
                        vetoes.push({ reason: 'No reason given', action: () => false });
                    }
                }
            }
            vetoes.sort((a, b) => { var _a, _b; return ((_a = a.priority) !== null && _a !== void 0 ? _a : -Infinity) - ((_b = b.priority) !== null && _b !== void 0 ? _b : -Infinity); });
            if (vetoes.length === 0 && shouldConfirmExit === 'always') {
                vetoes.push({ reason: 'application.confirmExit preference', action: () => dialogs_1.confirmExit() });
            }
            if (vetoes.length === 0) {
                this.allowVetoes = false;
            }
        }
        return vetoes;
    }
    /**
     * Implement the mechanism to detect unloading of the page.
     */
    registerUnloadListeners() {
        window.addEventListener('beforeunload', event => this.handleBeforeUnloadEvent(event));
        // In a browser, `unload` is correctly fired when the page unloads, unlike Electron.
        // If `beforeunload` is cancelled, the user will be prompted to leave or stay.
        // If the user stays, the page won't be unloaded, so `unload` is not fired.
        // If the user leaves, the page will be unloaded, so `unload` is fired.
        window.addEventListener('unload', () => this.onUnloadEmitter.fire());
    }
    async isSafeToShutDown() {
        const vetoes = this.collectContributionUnloadVetoes();
        if (vetoes.length === 0) {
            return true;
        }
        console.debug('Shutdown prevented by', vetoes.map(({ reason }) => reason).join(', '));
        const resolvedVetoes = await Promise.allSettled(vetoes.map(({ action }) => action()));
        if (resolvedVetoes.every(resolution => resolution.status === 'rejected' || resolution.value === true)) {
            console.debug('OnWillStop actions resolved; allowing shutdown');
            this.allowVetoes = false;
            return true;
        }
        else {
            return false;
        }
    }
    setSafeToShutDown() {
        this.allowVetoes = false;
    }
    /**
     * Called when the `window` is about to `unload` its resources.
     * At this point, the `document` is still visible and the [`BeforeUnloadEvent`](https://developer.mozilla.org/en-US/docs/Web/API/Window/beforeunload_event)
     * event will be canceled if the return value of this method is `false`.
     *
     * In Electron, handleCloseRequestEvent is is run instead.
     */
    handleBeforeUnloadEvent(event) {
        const vetoes = this.collectContributionUnloadVetoes();
        if (vetoes.length) {
            // In the browser, we don't call the functions because this has to finish in a single tick, so we treat any desired action as a veto.
            console.debug('Shutdown prevented by', vetoes.map(({ reason }) => reason).join(', '));
            return this.preventUnload(event);
        }
        console.debug('Shutdown will proceed.');
    }
    /**
     * Notify the browser that we do not want to unload.
     *
     * Notes:
     *  - Shows a confirmation popup in browsers.
     *  - Prevents the window from closing without confirmation in electron.
     *
     * @param event The beforeunload event
     */
    preventUnload(event) {
        event.returnValue = '';
        event.preventDefault();
        return '';
    }
    reload() {
        window.location.reload();
    }
};
__decorate([
    inversify_1.inject(core_preferences_1.CorePreferences),
    __metadata("design:type", Object)
], DefaultWindowService.prototype, "corePreferences", void 0);
__decorate([
    inversify_1.inject(contribution_provider_1.ContributionProvider),
    inversify_1.named(frontend_application_1.FrontendApplicationContribution),
    __metadata("design:type", Object)
], DefaultWindowService.prototype, "contributions", void 0);
DefaultWindowService = __decorate([
    inversify_1.injectable()
], DefaultWindowService);
exports.DefaultWindowService = DefaultWindowService;


/***/ }),

/***/ "./node_modules/@theia/core/lib/common/window.js":
/*!*******************************************************!*\
  !*** ./node_modules/@theia/core/lib/common/window.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports) => {


/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DEFAULT_WINDOW_HASH = void 0;
/**
 * The window hash value that is used to spawn a new default window.
 */
exports.DEFAULT_WINDOW_HASH = '!empty';


/***/ }),

/***/ "./node_modules/@theia/core/lib/electron-browser/window/electron-window-service.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@theia/core/lib/electron-browser/window/electron-window-service.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ElectronWindowService = void 0;
const electronRemote = __webpack_require__(/*! ../../../electron-shared/@electron/remote */ "./node_modules/@theia/core/electron-shared/@electron/remote/index.js");
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const electron = __webpack_require__(/*! ../../../electron-shared/electron */ "./node_modules/@theia/core/electron-shared/electron/index.js");
const default_window_service_1 = __webpack_require__(/*! ../../browser/window/default-window-service */ "./node_modules/@theia/core/lib/browser/window/default-window-service.js");
const electron_main_window_service_1 = __webpack_require__(/*! ../../electron-common/electron-main-window-service */ "./node_modules/@theia/core/lib/electron-common/electron-main-window-service.js");
const electron_window_preferences_1 = __webpack_require__(/*! ./electron-window-preferences */ "./node_modules/@theia/core/lib/electron-browser/window/electron-window-preferences.js");
const electron_messages_1 = __webpack_require__(/*! ../../electron-common/messaging/electron-messages */ "./node_modules/@theia/core/lib/electron-common/messaging/electron-messages.js");
let ElectronWindowService = class ElectronWindowService extends default_window_service_1.DefaultWindowService {
    constructor() {
        super(...arguments);
        /**
         * Lock to prevent multiple parallel executions of the `beforeunload` listener.
         */
        this.isUnloading = false;
        /**
         * Close the window right away when `true`, else check if we can unload.
         */
        this.closeOnUnload = false;
    }
    openNewWindow(url, { external } = {}) {
        this.delegate.openNewWindow(url, { external });
        return undefined;
    }
    openNewDefaultWindow() {
        this.delegate.openNewDefaultWindow();
    }
    init() {
        // Update the default zoom level on startup when the preferences event is fired.
        this.electronWindowPreferences.onPreferenceChanged(e => {
            if (e.preferenceName === 'window.zoomLevel') {
                this.updateWindowZoomLevel();
            }
        });
    }
    registerUnloadListeners() {
        electron.ipcRenderer.on(electron_messages_1.CLOSE_REQUESTED_SIGNAL, (_event, closeRequestEvent) => this.handleCloseRequestedEvent(closeRequestEvent));
        window.addEventListener('unload', () => this.onUnloadEmitter.fire());
    }
    /**
     * Run when ElectronMain detects a `close` event and emits a `close-requested` event.
     * Should send an event to `electron.ipcRenderer` on the event's `confirmChannel` if it is safe to exit
     * after running FrontendApplication `onWillStop` handlers or on the `cancelChannel` if it is not safe to exit.
     */
    async handleCloseRequestedEvent(event) {
        const safeToClose = await this.isSafeToShutDown();
        if (safeToClose) {
            console.debug(`Shutting down because of ${electron_messages_1.StopReason[event.reason]} request.`);
            electron.ipcRenderer.send(event.confirmChannel);
        }
        else {
            electron.ipcRenderer.send(event.cancelChannel);
        }
    }
    /**
     * Updates the window zoom level based on the preference value.
     */
    updateWindowZoomLevel() {
        const preferredZoomLevel = this.electronWindowPreferences['window.zoomLevel'];
        const webContents = electronRemote.getCurrentWindow().webContents;
        if (webContents.getZoomLevel() !== preferredZoomLevel) {
            webContents.setZoomLevel(preferredZoomLevel);
        }
    }
    reload() {
        electron.ipcRenderer.send(electron_messages_1.RELOAD_REQUESTED_SIGNAL);
    }
};
__decorate([
    inversify_1.inject(electron_main_window_service_1.ElectronMainWindowService),
    __metadata("design:type", Object)
], ElectronWindowService.prototype, "delegate", void 0);
__decorate([
    inversify_1.inject(electron_window_preferences_1.ElectronWindowPreferences),
    __metadata("design:type", Object)
], ElectronWindowService.prototype, "electronWindowPreferences", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ElectronWindowService.prototype, "init", null);
ElectronWindowService = __decorate([
    inversify_1.injectable()
], ElectronWindowService);
exports.ElectronWindowService = ElectronWindowService;


/***/ }),

/***/ "./node_modules/@theia/core/lib/electron-common/electron-main-window-service.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@theia/core/lib/electron-common/electron-main-window-service.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ElectronMainWindowService = exports.electronMainWindowServicePath = void 0;
exports.electronMainWindowServicePath = '/services/electron-window';
exports.ElectronMainWindowService = Symbol('ElectronMainWindowService');


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_core_lib_electron-browser_window_electron-window-service_js.bundle.js.map