"use strict";
(global["webpackChunkarduino_ide"] = global["webpackChunkarduino_ide"] || []).push([["vendors-node_modules_theia_callhierarchy_lib_browser_index_js-node_modules_theia_plugin-ext_l-25966f"],{

/***/ "./node_modules/@theia/callhierarchy/lib/browser/index.js":
/*!****************************************************************!*\
  !*** ./node_modules/@theia/callhierarchy/lib/browser/index.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./callhierarchy */ "./node_modules/@theia/callhierarchy/lib/browser/callhierarchy.js"), exports);
__exportStar(__webpack_require__(/*! ./callhierarchy-contribution */ "./node_modules/@theia/callhierarchy/lib/browser/callhierarchy-contribution.js"), exports);
__exportStar(__webpack_require__(/*! ./callhierarchy-frontend-module */ "./node_modules/@theia/callhierarchy/lib/browser/callhierarchy-frontend-module.js"), exports);
__exportStar(__webpack_require__(/*! ./callhierarchy-service */ "./node_modules/@theia/callhierarchy/lib/browser/callhierarchy-service.js"), exports);


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/callhierarchy/callhierarchy-type-converters.js":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/callhierarchy/callhierarchy-type-converters.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.fromCallHierarchyCalleeToModelCallHierarchyOutgoingCall = exports.fromCallHierarchyCallerToModelCallHierarchyIncomingCall = exports.toCallee = exports.fromCaller = exports.toCaller = exports.fromDefinition = exports.toDefinition = exports.SymbolKindConverter = exports.toRange = exports.fromRange = exports.fromPosition = exports.toLocation = exports.fromLocation = exports.fromUriComponents = exports.toUriComponents = void 0;
const model = __webpack_require__(/*! ../../../common/plugin-api-rpc-model */ "./node_modules/@theia/plugin-ext/lib/common/plugin-api-rpc-model.js");
const callhierarchy = __webpack_require__(/*! @theia/core/shared/vscode-languageserver-protocol */ "./node_modules/@theia/core/shared/vscode-languageserver-protocol/index.js");
const vscode_uri_1 = __webpack_require__(/*! @theia/core/shared/vscode-uri */ "./node_modules/@theia/core/shared/vscode-uri/index.js");
function toUriComponents(uri) {
    return vscode_uri_1.URI.parse(uri);
}
exports.toUriComponents = toUriComponents;
function fromUriComponents(uri) {
    return vscode_uri_1.URI.revive(uri).toString();
}
exports.fromUriComponents = fromUriComponents;
function fromLocation(location) {
    return {
        uri: vscode_uri_1.URI.parse(location.uri),
        range: fromRange(location.range)
    };
}
exports.fromLocation = fromLocation;
function toLocation(uri, range) {
    return {
        uri: vscode_uri_1.URI.revive(uri).toString(),
        range: toRange(range)
    };
}
exports.toLocation = toLocation;
function fromPosition(position) {
    return {
        lineNumber: position.line,
        column: position.character
    };
}
exports.fromPosition = fromPosition;
function fromRange(range) {
    const { start, end } = range;
    return {
        startLineNumber: start.line + 1,
        startColumn: start.character + 1,
        endLineNumber: end.line + 1,
        endColumn: end.character + 1,
    };
}
exports.fromRange = fromRange;
function toRange(range) {
    return callhierarchy.Range.create(range.startLineNumber - 1, range.startColumn - 1, range.endLineNumber - 1, range.endColumn - 1);
}
exports.toRange = toRange;
var SymbolKindConverter;
(function (SymbolKindConverter) {
    // tslint:disable-next-line:no-null-keyword
    const fromMapping = Object.create(null);
    fromMapping[callhierarchy.SymbolKind.File] = model.SymbolKind.File;
    fromMapping[callhierarchy.SymbolKind.Module] = model.SymbolKind.Module;
    fromMapping[callhierarchy.SymbolKind.Namespace] = model.SymbolKind.Namespace;
    fromMapping[callhierarchy.SymbolKind.Package] = model.SymbolKind.Package;
    fromMapping[callhierarchy.SymbolKind.Class] = model.SymbolKind.Class;
    fromMapping[callhierarchy.SymbolKind.Method] = model.SymbolKind.Method;
    fromMapping[callhierarchy.SymbolKind.Property] = model.SymbolKind.Property;
    fromMapping[callhierarchy.SymbolKind.Field] = model.SymbolKind.Field;
    fromMapping[callhierarchy.SymbolKind.Constructor] = model.SymbolKind.Constructor;
    fromMapping[callhierarchy.SymbolKind.Enum] = model.SymbolKind.Enum;
    fromMapping[callhierarchy.SymbolKind.Interface] = model.SymbolKind.Interface;
    fromMapping[callhierarchy.SymbolKind.Function] = model.SymbolKind.Function;
    fromMapping[callhierarchy.SymbolKind.Variable] = model.SymbolKind.Variable;
    fromMapping[callhierarchy.SymbolKind.Constant] = model.SymbolKind.Constant;
    fromMapping[callhierarchy.SymbolKind.String] = model.SymbolKind.String;
    fromMapping[callhierarchy.SymbolKind.Number] = model.SymbolKind.Number;
    fromMapping[callhierarchy.SymbolKind.Boolean] = model.SymbolKind.Boolean;
    fromMapping[callhierarchy.SymbolKind.Array] = model.SymbolKind.Array;
    fromMapping[callhierarchy.SymbolKind.Object] = model.SymbolKind.Object;
    fromMapping[callhierarchy.SymbolKind.Key] = model.SymbolKind.Key;
    fromMapping[callhierarchy.SymbolKind.Null] = model.SymbolKind.Null;
    fromMapping[callhierarchy.SymbolKind.EnumMember] = model.SymbolKind.EnumMember;
    fromMapping[callhierarchy.SymbolKind.Struct] = model.SymbolKind.Struct;
    fromMapping[callhierarchy.SymbolKind.Event] = model.SymbolKind.Event;
    fromMapping[callhierarchy.SymbolKind.Operator] = model.SymbolKind.Operator;
    fromMapping[callhierarchy.SymbolKind.TypeParameter] = model.SymbolKind.TypeParameter;
    function fromSymbolKind(kind) {
        return fromMapping[kind] || model.SymbolKind.Property;
    }
    SymbolKindConverter.fromSymbolKind = fromSymbolKind;
    // tslint:disable-next-line:no-null-keyword
    const toMapping = Object.create(null);
    toMapping[model.SymbolKind.File] = callhierarchy.SymbolKind.File;
    toMapping[model.SymbolKind.Module] = callhierarchy.SymbolKind.Module;
    toMapping[model.SymbolKind.Namespace] = callhierarchy.SymbolKind.Namespace;
    toMapping[model.SymbolKind.Package] = callhierarchy.SymbolKind.Package;
    toMapping[model.SymbolKind.Class] = callhierarchy.SymbolKind.Class;
    toMapping[model.SymbolKind.Method] = callhierarchy.SymbolKind.Method;
    toMapping[model.SymbolKind.Property] = callhierarchy.SymbolKind.Property;
    toMapping[model.SymbolKind.Field] = callhierarchy.SymbolKind.Field;
    toMapping[model.SymbolKind.Constructor] = callhierarchy.SymbolKind.Constructor;
    toMapping[model.SymbolKind.Enum] = callhierarchy.SymbolKind.Enum;
    toMapping[model.SymbolKind.Interface] = callhierarchy.SymbolKind.Interface;
    toMapping[model.SymbolKind.Function] = callhierarchy.SymbolKind.Function;
    toMapping[model.SymbolKind.Variable] = callhierarchy.SymbolKind.Variable;
    toMapping[model.SymbolKind.Constant] = callhierarchy.SymbolKind.Constant;
    toMapping[model.SymbolKind.String] = callhierarchy.SymbolKind.String;
    toMapping[model.SymbolKind.Number] = callhierarchy.SymbolKind.Number;
    toMapping[model.SymbolKind.Boolean] = callhierarchy.SymbolKind.Boolean;
    toMapping[model.SymbolKind.Array] = callhierarchy.SymbolKind.Array;
    toMapping[model.SymbolKind.Object] = callhierarchy.SymbolKind.Object;
    toMapping[model.SymbolKind.Key] = callhierarchy.SymbolKind.Key;
    toMapping[model.SymbolKind.Null] = callhierarchy.SymbolKind.Null;
    toMapping[model.SymbolKind.EnumMember] = callhierarchy.SymbolKind.EnumMember;
    toMapping[model.SymbolKind.Struct] = callhierarchy.SymbolKind.Struct;
    toMapping[model.SymbolKind.Event] = callhierarchy.SymbolKind.Event;
    toMapping[model.SymbolKind.Operator] = callhierarchy.SymbolKind.Operator;
    toMapping[model.SymbolKind.TypeParameter] = callhierarchy.SymbolKind.TypeParameter;
    function toSymbolKind(kind) {
        return toMapping[kind] || model.SymbolKind.Property;
    }
    SymbolKindConverter.toSymbolKind = toSymbolKind;
})(SymbolKindConverter = exports.SymbolKindConverter || (exports.SymbolKindConverter = {}));
function toDefinition(definition) {
    if (!definition) {
        return undefined;
    }
    return {
        location: {
            uri: fromUriComponents(definition.uri),
            range: toRange(definition.range)
        },
        selectionRange: toRange(definition.selectionRange),
        symbolName: definition.name,
        symbolKind: SymbolKindConverter.toSymbolKind(definition.kind),
        containerName: undefined,
        tags: definition.tags,
        data: definition.data,
    };
}
exports.toDefinition = toDefinition;
function fromDefinition(definition) {
    return {
        uri: toUriComponents(definition.location.uri),
        range: fromRange(definition.location.range),
        selectionRange: fromRange(definition.selectionRange),
        name: definition.symbolName,
        kind: SymbolKindConverter.fromSymbolKind(definition.symbolKind),
        tags: definition.tags,
        data: definition.data,
    };
}
exports.fromDefinition = fromDefinition;
function toCaller(caller) {
    return {
        callerDefinition: toDefinition(caller.callerDefinition),
        references: caller.references.map(toRange)
    };
}
exports.toCaller = toCaller;
function fromCaller(caller) {
    return {
        callerDefinition: fromDefinition(caller.callerDefinition),
        references: caller.references.map(fromRange)
    };
}
exports.fromCaller = fromCaller;
function toCallee(callee) {
    return {
        calleeDefinition: toDefinition(callee.callerDefinition),
        references: callee.references.map(toRange),
    };
}
exports.toCallee = toCallee;
function fromCallHierarchyCallerToModelCallHierarchyIncomingCall(caller) {
    return {
        from: fromDefinition(caller.callerDefinition),
        fromRanges: caller.references.map(fromRange),
    };
}
exports.fromCallHierarchyCallerToModelCallHierarchyIncomingCall = fromCallHierarchyCallerToModelCallHierarchyIncomingCall;
function fromCallHierarchyCalleeToModelCallHierarchyOutgoingCall(callee) {
    return {
        to: fromDefinition(callee.calleeDefinition),
        fromRanges: callee.references.map(fromRange),
    };
}
exports.fromCallHierarchyCalleeToModelCallHierarchyOutgoingCall = fromCallHierarchyCalleeToModelCallHierarchyOutgoingCall;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/comments/comment-glyph-widget.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/comments/comment-glyph-widget.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommentGlyphWidget = void 0;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// some code copied and modified from https://github.com/microsoft/vscode/blob/1.49.3/src/vs/workbench/contrib/comments/browser/commentGlyphWidget.ts
class CommentGlyphWidget {
    constructor(editor) {
        this.commentsDecorations = [];
        this.commentsOptions = {
            isWholeLine: true,
            linesDecorationsClassName: 'comment-range-glyph comment-thread'
        };
        this.editor = editor;
    }
    getPosition() {
        const model = this.editor.getModel();
        const range = model && this.commentsDecorations && this.commentsDecorations.length
            ? model.getDecorationRange(this.commentsDecorations[0])
            : null;
        return range ? range.startLineNumber : this.lineNumber;
    }
    setLineNumber(lineNumber) {
        this.lineNumber = lineNumber;
        const commentsDecorations = [{
                range: {
                    startLineNumber: lineNumber, startColumn: 1,
                    endLineNumber: lineNumber, endColumn: 1
                },
                options: this.commentsOptions
            }];
        this.commentsDecorations = this.editor.deltaDecorations(this.commentsDecorations, commentsDecorations);
    }
    dispose() {
        if (this.commentsDecorations) {
            this.editor.deltaDecorations(this.commentsDecorations, []);
        }
    }
}
exports.CommentGlyphWidget = CommentGlyphWidget;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/comments/comment-thread-widget.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/comments/comment-thread-widget.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommentAction = exports.CommentActions = exports.CommentsInlineAction = exports.CommentEditContainer = exports.CommentBody = exports.ReviewComment = exports.CommentForm = exports.CommentThreadWidget = exports.COMMENT_TITLE = exports.COMMENT_CONTEXT = exports.COMMENT_THREAD_CONTEXT = void 0;
/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
const monaco_editor_zone_widget_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor-zone-widget */ "./node_modules/@theia/monaco/lib/browser/monaco-editor-zone-widget.js");
const plugin_api_rpc_model_1 = __webpack_require__(/*! ../../../common/plugin-api-rpc-model */ "./node_modules/@theia/plugin-ext/lib/common/plugin-api-rpc-model.js");
const comment_glyph_widget_1 = __webpack_require__(/*! ./comment-glyph-widget */ "./node_modules/@theia/plugin-ext/lib/main/browser/comments/comment-glyph-widget.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const ReactDOM = __webpack_require__(/*! @theia/core/shared/react-dom */ "./node_modules/@theia/core/shared/react-dom/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "./node_modules/@theia/editor/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// some code copied and modified from https://github.com/microsoft/vscode/blob/1.49.3/src/vs/workbench/contrib/comments/browser/commentThreadWidget.ts
exports.COMMENT_THREAD_CONTEXT = ['comment_thread-context-menu'];
exports.COMMENT_CONTEXT = ['comment-context-menu'];
exports.COMMENT_TITLE = ['comment-title-menu'];
class CommentThreadWidget extends browser_1.BaseWidget {
    constructor(editor, _owner, _commentThread, commentService, menus, contextKeyService, commands) {
        super();
        this._owner = _owner;
        this._commentThread = _commentThread;
        this.commentService = commentService;
        this.menus = menus;
        this.contextKeyService = contextKeyService;
        this.commands = commands;
        this.commentFormRef = React.createRef();
        this.toDispose.push(this.zoneWidget = new monaco_editor_zone_widget_1.MonacoEditorZoneWidget(editor));
        this.toDispose.push(this.commentGlyphWidget = new comment_glyph_widget_1.CommentGlyphWidget(editor));
        this.toDispose.push(this._commentThread.onDidChangeCollapsibleState(state => {
            if (state === plugin_api_rpc_model_1.CommentThreadCollapsibleState.Expanded && !this.isExpanded) {
                const lineNumber = this._commentThread.range.startLineNumber;
                this.display({ afterLineNumber: lineNumber, afterColumn: 1, heightInLines: 2 });
                return;
            }
            if (state === plugin_api_rpc_model_1.CommentThreadCollapsibleState.Collapsed && this.isExpanded) {
                this.hide();
                return;
            }
        }));
        this.contextKeyService.commentIsEmpty.set(true);
        this.toDispose.push(this.zoneWidget.editor.onMouseDown(e => this.onEditorMouseDown(e)));
        this.toDispose.push(this.contextKeyService.onDidChange(() => {
            const commentForm = this.commentFormRef.current;
            if (commentForm) {
                commentForm.update();
            }
        }));
        this.contextMenu = this.menus.getMenu(exports.COMMENT_THREAD_CONTEXT);
        this.contextMenu.children.map(node => node instanceof common_1.ActionMenuNode && node.action.when).forEach(exp => {
            if (typeof exp === 'string') {
                this.contextKeyService.setExpression(exp);
            }
        });
    }
    getGlyphPosition() {
        return this.commentGlyphWidget.getPosition();
    }
    collapse() {
        this._commentThread.collapsibleState = plugin_api_rpc_model_1.CommentThreadCollapsibleState.Collapsed;
        if (this._commentThread.comments && this._commentThread.comments.length === 0) {
            this.deleteCommentThread();
        }
        this.hide();
    }
    deleteCommentThread() {
        this.dispose();
        this.commentService.disposeCommentThread(this.owner, this._commentThread.threadId);
    }
    dispose() {
        super.dispose();
        if (this.commentGlyphWidget) {
            this.commentGlyphWidget.dispose();
        }
    }
    toggleExpand(lineNumber) {
        if (this.isExpanded) {
            this._commentThread.collapsibleState = plugin_api_rpc_model_1.CommentThreadCollapsibleState.Collapsed;
            this.hide();
            if (!this._commentThread.comments || !this._commentThread.comments.length) {
                this.deleteCommentThread();
            }
        }
        else {
            this._commentThread.collapsibleState = plugin_api_rpc_model_1.CommentThreadCollapsibleState.Expanded;
            this.display({ afterLineNumber: lineNumber, afterColumn: 1, heightInLines: 2 });
        }
    }
    hide() {
        this.zoneWidget.hide();
        this.isExpanded = false;
        super.hide();
    }
    display(options) {
        this.isExpanded = true;
        if (this._commentThread.collapsibleState && this._commentThread.collapsibleState !== plugin_api_rpc_model_1.CommentThreadCollapsibleState.Expanded) {
            return;
        }
        this.commentGlyphWidget.setLineNumber(options.afterLineNumber);
        this._commentThread.collapsibleState = plugin_api_rpc_model_1.CommentThreadCollapsibleState.Expanded;
        this.zoneWidget.show(options);
        this.update();
    }
    onEditorMouseDown(e) {
        const range = e.target.range;
        if (!range) {
            return;
        }
        if (!e.event.leftButton) {
            return;
        }
        if (e.target.type !== browser_2.MouseTargetType.GUTTER_LINE_DECORATIONS) {
            return;
        }
        const data = e.target.detail;
        const gutterOffsetX = data.offsetX - data.glyphMarginWidth - data.lineNumbersWidth - data.glyphMarginLeft;
        // don't collide with folding and git decorations
        if (gutterOffsetX > 14) {
            return;
        }
        const mouseDownInfo = { lineNumber: range.startLineNumber };
        const { lineNumber } = mouseDownInfo;
        if (!range || range.startLineNumber !== lineNumber) {
            return;
        }
        if (e.target.type !== browser_2.MouseTargetType.GUTTER_LINE_DECORATIONS) {
            return;
        }
        if (!e.target.element) {
            return;
        }
        if (this.commentGlyphWidget && this.commentGlyphWidget.getPosition() !== lineNumber) {
            return;
        }
        if (e.target.element.className.indexOf('comment-thread') >= 0) {
            this.toggleExpand(lineNumber);
            return;
        }
        if (this._commentThread.collapsibleState === plugin_api_rpc_model_1.CommentThreadCollapsibleState.Collapsed) {
            this.display({ afterLineNumber: mouseDownInfo.lineNumber, heightInLines: 2 });
        }
        else {
            this.hide();
        }
    }
    get owner() {
        return this._owner;
    }
    get commentThread() {
        return this._commentThread;
    }
    getThreadLabel() {
        let label;
        label = this._commentThread.label;
        if (label === undefined) {
            if (this._commentThread.comments && this._commentThread.comments.length) {
                const onlyUnique = (value, index, self) => self.indexOf(value) === index;
                const participantsList = this._commentThread.comments.filter(onlyUnique).map(comment => `@${comment.userName}`).join(', ');
                label = `Participants: ${participantsList}`;
            }
            else {
                label = 'Start discussion';
            }
        }
        return label;
    }
    update() {
        if (!this.isExpanded) {
            return;
        }
        this.render();
        const headHeight = Math.ceil(this.zoneWidget.editor.getOption(monaco.editor.EditorOption.lineHeight) * 1.2);
        const lineHeight = this.zoneWidget.editor.getOption(monaco.editor.EditorOption.lineHeight);
        const arrowHeight = Math.round(lineHeight / 3);
        const frameThickness = Math.round(lineHeight / 9) * 2;
        const body = this.zoneWidget.containerNode.getElementsByClassName('body')[0];
        const computedLinesNumber = Math.ceil((headHeight + body.clientHeight + arrowHeight + frameThickness + 8 /** margin bottom to avoid margin collapse */) / lineHeight);
        this.zoneWidget.show({ afterLineNumber: this._commentThread.range.startLineNumber, heightInLines: computedLinesNumber });
    }
    render() {
        var _a;
        const headHeight = Math.ceil(this.zoneWidget.editor.getOption(monaco.editor.EditorOption.lineHeight) * 1.2);
        ReactDOM.render(React.createElement("div", { className: 'review-widget' },
            React.createElement("div", { className: 'head', style: { height: headHeight, lineHeight: `${headHeight}px` } },
                React.createElement("div", { className: 'review-title' },
                    React.createElement("span", { className: 'filename' }, this.getThreadLabel())),
                React.createElement("div", { className: 'review-actions' },
                    React.createElement("div", { className: 'monaco-action-bar animated' },
                        React.createElement("ul", { className: 'actions-container', role: 'toolbar' },
                            React.createElement("li", { className: 'action-item', role: 'presentation' },
                                React.createElement("a", { className: 'action-label codicon expand-review-action codicon-chevron-up', role: 'button', tabIndex: 0, title: 'Collapse', onClick: () => this.collapse() })))))),
            React.createElement("div", { className: 'body' },
                React.createElement("div", { className: 'comments-container', role: 'presentation', tabIndex: 0 }, (_a = this._commentThread.comments) === null || _a === void 0 ? void 0 : _a.map((comment, index) => React.createElement(ReviewComment, { key: index, contextKeyService: this.contextKeyService, menus: this.menus, comment: comment, commentForm: this.commentFormRef, commands: this.commands, commentThread: this._commentThread }))),
                React.createElement(CommentForm, { contextKeyService: this.contextKeyService, commands: this.commands, commentThread: this._commentThread, menus: this.menus, widget: this, ref: this.commentFormRef }))), this.zoneWidget.containerNode);
    }
}
exports.CommentThreadWidget = CommentThreadWidget;
class CommentForm extends React.Component {
    constructor(props) {
        super(props);
        this.inputRef = React.createRef();
        this.inputValue = '';
        this.getInput = () => this.inputValue;
        this.clearInput = () => {
            const input = this.inputRef.current;
            if (input) {
                this.inputValue = '';
                input.value = this.inputValue;
                this.props.contextKeyService.commentIsEmpty.set(true);
            }
        };
        this.expand = () => {
            this.setState({ expanded: true });
            // Wait for the widget to be rendered.
            setTimeout(() => {
                var _a;
                // Update the widget's height.
                this.props.widget.update();
                (_a = this.inputRef.current) === null || _a === void 0 ? void 0 : _a.focus();
            }, 100);
        };
        this.collapse = () => {
            this.setState({ expanded: false });
            // Wait for the widget to be rendered.
            setTimeout(() => {
                // Update the widget's height.
                this.props.widget.update();
            }, 100);
        };
        this.onInput = (event) => {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const value = event.target.value;
            if (this.inputValue.length === 0 || value.length === 0) {
                this.props.contextKeyService.commentIsEmpty.set(value.length === 0);
            }
            this.inputValue = value;
        };
        this.state = {
            expanded: false
        };
        const setState = this.setState.bind(this);
        this.setState = newState => {
            setState(newState);
        };
        this.menu = this.props.menus.getMenu(exports.COMMENT_THREAD_CONTEXT);
        this.menu.children.map(node => node instanceof common_1.ActionMenuNode && node.action.when).forEach(exp => {
            if (typeof exp === 'string') {
                this.props.contextKeyService.setExpression(exp);
            }
        });
    }
    update() {
        this.setState(this.state);
    }
    componentDidMount() {
        // Wait for the widget to be rendered.
        setTimeout(() => {
            var _a;
            (_a = this.inputRef.current) === null || _a === void 0 ? void 0 : _a.focus();
        }, 100);
    }
    render() {
        const { commands, commentThread, contextKeyService } = this.props;
        const hasExistingComments = commentThread.comments && commentThread.comments.length > 0;
        return React.createElement("div", { className: 'comment-form' + (this.state.expanded || commentThread.comments && commentThread.comments.length === 0 ? ' expand' : '') },
            React.createElement("div", { className: 'theia-comments-input-message-container' },
                React.createElement("textarea", { className: 'theia-comments-input-message theia-input', spellCheck: false, placeholder: hasExistingComments ? 'Reply...' : 'Type a new comment', onInput: this.onInput, 
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                    onBlur: (event) => {
                        if (event.target.value.length > 0) {
                            return;
                        }
                        if (event.relatedTarget && event.relatedTarget.className === 'comments-button comments-text-button theia-button') {
                            this.state = { expanded: false };
                            return;
                        }
                        this.collapse();
                    }, ref: this.inputRef })),
            React.createElement(CommentActions, { menu: this.menu, contextKeyService: contextKeyService, commands: commands, commentThread: commentThread, getInput: this.getInput, clearInput: this.clearInput }),
            React.createElement("button", { className: 'review-thread-reply-button', title: 'Reply...', onClick: this.expand }, "Reply..."));
    }
}
exports.CommentForm = CommentForm;
class ReviewComment extends React.Component {
    constructor(props) {
        super(props);
        this.detectHover = (element) => {
            if (element) {
                window.requestAnimationFrame(() => {
                    const hover = element.matches(':hover');
                    this.setState({ hover });
                });
            }
        };
        this.showHover = () => this.setState({ hover: true });
        this.hideHover = () => this.setState({ hover: false });
        this.state = {
            hover: false
        };
        const setState = this.setState.bind(this);
        this.setState = newState => {
            setState(newState);
        };
    }
    render() {
        const { comment, commentForm, contextKeyService, menus, commands, commentThread } = this.props;
        const commentUniqueId = comment.uniqueIdInThread;
        const { hover } = this.state;
        contextKeyService.comment.set(comment.contextValue);
        return React.createElement("div", { className: 'review-comment', tabIndex: -1, "aria-label": `${comment.userName}, ${comment.body.value}`, ref: this.detectHover, onMouseEnter: this.showHover, onMouseLeave: this.hideHover },
            React.createElement("div", { className: 'avatar-container' },
                React.createElement("img", { className: 'avatar', src: comment.userIconPath })),
            React.createElement("div", { className: 'review-comment-contents' },
                React.createElement("div", { className: 'comment-title monaco-mouse-cursor-text' },
                    React.createElement("strong", { className: 'author' }, comment.userName),
                    React.createElement("span", { className: 'isPending' }, comment.label),
                    React.createElement("div", { className: 'theia-comments-inline-actions-container' },
                        React.createElement("div", { className: 'theia-comments-inline-actions', role: 'toolbar' }, hover && menus.getMenu(exports.COMMENT_TITLE).children.map((node, index) => node instanceof common_1.ActionMenuNode &&
                            React.createElement(CommentsInlineAction, Object.assign({ key: index }, { node, commands, commentThread, commentUniqueId, contextKeyService })))))),
                React.createElement(CommentBody, { value: comment.body.value, isVisible: comment.mode === undefined || comment.mode === plugin_api_rpc_model_1.CommentMode.Preview }),
                React.createElement(CommentEditContainer, { contextKeyService: contextKeyService, menus: menus, comment: comment, commentThread: commentThread, commentForm: commentForm, commands: commands })));
    }
}
exports.ReviewComment = ReviewComment;
class CommentBody extends React.Component {
    render() {
        const { value, isVisible } = this.props;
        if (!isVisible) {
            return false;
        }
        return React.createElement("div", { className: 'comment-body monaco-mouse-cursor-text' },
            React.createElement("div", null,
                React.createElement("p", null, value)));
    }
}
exports.CommentBody = CommentBody;
class CommentEditContainer extends React.Component {
    constructor() {
        super(...arguments);
        this.inputRef = React.createRef();
    }
    componentDidUpdate(prevProps, prevState) {
        var _a;
        const commentFormState = (_a = this.props.commentForm.current) === null || _a === void 0 ? void 0 : _a.state;
        const mode = this.props.comment.mode;
        if (this.dirtyCommentMode !== mode || (this.dirtyCommentFormState !== (commentFormState === null || commentFormState === void 0 ? void 0 : commentFormState.expanded) && !(commentFormState === null || commentFormState === void 0 ? void 0 : commentFormState.expanded))) {
            const currentInput = this.inputRef.current;
            if (currentInput) {
                // Wait for the widget to be rendered.
                setTimeout(() => {
                    currentInput.focus();
                    currentInput.setSelectionRange(currentInput.value.length, currentInput.value.length);
                }, 50);
            }
        }
        this.dirtyCommentMode = mode;
        this.dirtyCommentFormState = commentFormState === null || commentFormState === void 0 ? void 0 : commentFormState.expanded;
    }
    render() {
        const { menus, comment, commands, commentThread, contextKeyService } = this.props;
        if (!(comment.mode === plugin_api_rpc_model_1.CommentMode.Editing)) {
            return false;
        }
        return React.createElement("div", { className: 'edit-container' },
            React.createElement("div", { className: 'edit-textarea' },
                React.createElement("div", { className: 'theia-comments-input-message-container' },
                    React.createElement("textarea", { className: 'theia-comments-input-message theia-input', spellCheck: false, defaultValue: comment.body.value, ref: this.inputRef }))),
            React.createElement("div", { className: 'form-actions' }, menus.getMenu(exports.COMMENT_CONTEXT).children.map((node, index) => {
                const onClick = () => {
                    commands.executeCommand(node.id, {
                        thread: commentThread,
                        commentUniqueId: comment.uniqueIdInThread,
                        text: this.inputRef.current ? this.inputRef.current.value : ''
                    });
                };
                return node instanceof common_1.ActionMenuNode &&
                    React.createElement(CommentAction, Object.assign({ key: index }, { node, commands, onClick, contextKeyService }));
            })));
    }
}
exports.CommentEditContainer = CommentEditContainer;
class CommentsInlineAction extends React.Component {
    render() {
        const { node, commands, contextKeyService, commentThread, commentUniqueId } = this.props;
        if (node.action.when && !contextKeyService.match(node.action.when)) {
            return false;
        }
        return React.createElement("div", { className: 'theia-comments-inline-action' },
            React.createElement("a", { className: node.icon, title: node.label, onClick: () => {
                    commands.executeCommand(node.id, {
                        thread: commentThread,
                        commentUniqueId
                    });
                } }));
    }
}
exports.CommentsInlineAction = CommentsInlineAction;
class CommentActions extends React.Component {
    render() {
        const { contextKeyService, commands, menu, commentThread, getInput, clearInput } = this.props;
        return React.createElement("div", { className: 'form-actions' }, menu.children.map((node, index) => node instanceof common_1.ActionMenuNode &&
            React.createElement(CommentAction, { key: index, commands: commands, node: node, onClick: () => {
                    commands.executeCommand(node.id, {
                        thread: commentThread,
                        text: getInput()
                    });
                    clearInput();
                }, contextKeyService: contextKeyService })));
    }
}
exports.CommentActions = CommentActions;
class CommentAction extends React.Component {
    render() {
        const classNames = ['comments-button', 'comments-text-button', 'theia-button'];
        const { node, commands, contextKeyService, onClick } = this.props;
        if (node.action.when && !contextKeyService.match(node.action.when)) {
            return false;
        }
        const isEnabled = commands.isEnabled(node.action.commandId);
        if (!isEnabled) {
            classNames.push(browser_1.DISABLED_CLASS);
        }
        return React.createElement("button", { className: classNames.join(' '), tabIndex: 0, role: 'button', onClick: () => {
                if (isEnabled) {
                    onClick();
                }
            } }, node.label);
    }
}
exports.CommentAction = CommentAction;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/custom-editors/custom-editor-opener.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/custom-editors/custom-editor-opener.js ***!
  \************************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CustomEditorOpener = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! ../../../common */ "./node_modules/@theia/plugin-ext/lib/common/index.js");
const glob = __webpack_require__(/*! ./glob */ "./node_modules/@theia/plugin-ext/lib/main/browser/custom-editors/glob.js");
const custom_editor_widget_1 = __webpack_require__(/*! ./custom-editor-widget */ "./node_modules/@theia/plugin-ext/lib/main/browser/custom-editors/custom-editor-widget.js");
const uuid_1 = __webpack_require__(/*! uuid */ "./node_modules/uuid/dist/esm-browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
let CustomEditorOpener = class CustomEditorOpener {
    constructor(editor, shell, widgetManager) {
        this.editor = editor;
        this.shell = shell;
        this.widgetManager = widgetManager;
        this.onDidOpenCustomEditorEmitter = new core_1.Emitter();
        this.onDidOpenCustomEditor = this.onDidOpenCustomEditorEmitter.event;
        this.pendingWidgetPromises = new Map();
        this.id = CustomEditorOpener.toCustomEditorId(this.editor.viewType);
        this.label = this.editor.displayName;
    }
    static toCustomEditorId(editorViewType) {
        return `custom-editor-${editorViewType}`;
    }
    canHandle(uri) {
        if (this.matches(this.editor.selector, uri)) {
            return this.getPriority();
        }
        return 0;
    }
    getPriority() {
        switch (this.editor.priority) {
            case common_1.CustomEditorPriority.default: return 500;
            case common_1.CustomEditorPriority.builtin: return 400;
            /** `option` should not open the custom-editor by default. */
            case common_1.CustomEditorPriority.option: return 1;
            default: return 200;
        }
    }
    async open(uri, options) {
        let widget;
        const widgets = this.widgetManager.getWidgets(custom_editor_widget_1.CustomEditorWidget.FACTORY_ID);
        widget = widgets.find(w => w.viewType === this.editor.viewType && w.resource.toString() === uri.toString());
        if (widget === null || widget === void 0 ? void 0 : widget.isVisible) {
            return this.shell.revealWidget(widget.id);
        }
        if (widget === null || widget === void 0 ? void 0 : widget.isAttached) {
            return this.shell.activateWidget(widget.id);
        }
        if (!widget) {
            const uriString = uri.toString();
            let widgetPromise = this.pendingWidgetPromises.get(uriString);
            if (!widgetPromise) {
                const id = uuid_1.v4();
                widgetPromise = this.widgetManager.getOrCreateWidget(custom_editor_widget_1.CustomEditorWidget.FACTORY_ID, { id });
                this.pendingWidgetPromises.set(uriString, widgetPromise);
                widget = await widgetPromise;
                this.pendingWidgetPromises.delete(uriString);
                widget.viewType = this.editor.viewType;
                widget.resource = uri;
                this.onDidOpenCustomEditorEmitter.fire([widget, options]);
            }
        }
        return widget;
    }
    matches(selectors, resource) {
        return selectors.some(selector => this.selectorMatches(selector, resource));
    }
    selectorMatches(selector, resource) {
        if (selector.filenamePattern) {
            if (glob.match(selector.filenamePattern.toLowerCase(), resource.path.name.toLowerCase() + resource.path.ext.toLowerCase())) {
                return true;
            }
        }
        return false;
    }
};
CustomEditorOpener = __decorate([
    __param(1, inversify_1.inject(browser_1.ApplicationShell)),
    __param(2, inversify_1.inject(browser_1.WidgetManager)),
    __metadata("design:paramtypes", [Object, browser_1.ApplicationShell,
        browser_1.WidgetManager])
], CustomEditorOpener);
exports.CustomEditorOpener = CustomEditorOpener;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/custom-editors/glob.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/custom-editors/glob.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
// copied from https://github.com/Microsoft/vscode/blob/bf7ac9201e7a7d01741d4e6e64b5dc9f3197d97b/src/vs/base/common/glob.ts
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getPathTerms = exports.getBasenameTerms = exports.parseToAsync = exports.isRelativePattern = exports.hasSiblingFn = exports.hasSiblingPromiseFn = exports.parse = exports.match = exports.splitGlobAware = exports.getEmptyExpression = void 0;
const strings = __webpack_require__(/*! @theia/core/lib/common/strings */ "./node_modules/@theia/core/lib/common/strings.js");
const paths = __webpack_require__(/*! ./paths */ "./node_modules/@theia/plugin-ext/lib/main/browser/custom-editors/paths.js");
function getEmptyExpression() {
    return Object.create(null);
}
exports.getEmptyExpression = getEmptyExpression;
const GLOBSTAR = '**';
const GLOB_SPLIT = '/';
const PATH_REGEX = '[/\\\\]'; // any slash or backslash
const NO_PATH_REGEX = '[^/\\\\]'; // any non-slash and non-backslash
const ALL_FORWARD_SLASHES = /\//g;
function starsToRegExp(starCount) {
    switch (starCount) {
        case 0:
            return '';
        case 1:
            return `${NO_PATH_REGEX}*?`; // 1 star matches any number of characters except path separator (/ and \) - non greedy (?)
        default:
            // Matches:  (Path Sep OR Path Val followed by Path Sep OR Path Sep followed by Path Val) 0-many times
            // Group is non capturing because we don't need to capture at all (?:...)
            // Overall we use non-greedy matching because it could be that we match too much
            return `(?:${PATH_REGEX}|${NO_PATH_REGEX}+${PATH_REGEX}|${PATH_REGEX}${NO_PATH_REGEX}+)*?`;
    }
}
function splitGlobAware(pattern, splitChar) {
    if (!pattern) {
        return [];
    }
    const segments = [];
    let inBraces = false;
    let inBrackets = false;
    let char;
    let curVal = '';
    for (let i = 0; i < pattern.length; i++) {
        char = pattern[i];
        switch (char) {
            case splitChar:
                if (!inBraces && !inBrackets) {
                    segments.push(curVal);
                    curVal = '';
                    continue;
                }
                break;
            case '{':
                inBraces = true;
                break;
            case '}':
                inBraces = false;
                break;
            case '[':
                inBrackets = true;
                break;
            case ']':
                inBrackets = false;
                break;
        }
        curVal += char;
    }
    // Tail
    if (curVal) {
        segments.push(curVal);
    }
    return segments;
}
exports.splitGlobAware = splitGlobAware;
function parseRegExp(pattern) {
    if (!pattern) {
        return '';
    }
    let regEx = '';
    // Split up into segments for each slash found
    // eslint-disable-next-line prefer-const
    let segments = splitGlobAware(pattern, GLOB_SPLIT);
    // Special case where we only have globstars
    if (segments.every(s => s === GLOBSTAR)) {
        regEx = '.*';
    }
    // Build regex over segments
    // tslint:disable-next-line:one-line
    else {
        let previousSegmentWasGlobStar = false;
        segments.forEach((segment, index) => {
            // Globstar is special
            if (segment === GLOBSTAR) {
                // if we have more than one globstar after another, just ignore it
                if (!previousSegmentWasGlobStar) {
                    regEx += starsToRegExp(2);
                    previousSegmentWasGlobStar = true;
                }
                return;
            }
            // States
            let inBraces = false;
            let braceVal = '';
            let inBrackets = false;
            let bracketVal = '';
            let char;
            for (let i = 0; i < segment.length; i++) {
                char = segment[i];
                // Support brace expansion
                if (char !== '}' && inBraces) {
                    braceVal += char;
                    continue;
                }
                // Support brackets
                if (inBrackets && (char !== ']' || !bracketVal) /* ] is literally only allowed as first character in brackets to match it */) {
                    let res;
                    // range operator
                    if (char === '-') {
                        res = char;
                    }
                    // negation operator (only valid on first index in bracket)
                    // tslint:disable-next-line:one-line
                    else if ((char === '^' || char === '!') && !bracketVal) {
                        res = '^';
                    }
                    // glob split matching is not allowed within character ranges
                    // see http://man7.org/linux/man-pages/man7/glob.7.html
                    // tslint:disable-next-line:one-line
                    else if (char === GLOB_SPLIT) {
                        res = '';
                    }
                    // anything else gets escaped
                    // tslint:disable-next-line:one-line
                    else {
                        res = strings.escapeRegExpCharacters(char);
                    }
                    bracketVal += res;
                    continue;
                }
                switch (char) {
                    case '{':
                        inBraces = true;
                        continue;
                    case '[':
                        inBrackets = true;
                        continue;
                    case '}':
                        // eslint-disable-next-line prefer-const
                        let choices = splitGlobAware(braceVal, ',');
                        // Converts {foo,bar} => [foo|bar]
                        // eslint-disable-next-line prefer-const
                        let braceRegExp = `(?:${choices.map(c => parseRegExp(c)).join('|')})`;
                        regEx += braceRegExp;
                        inBraces = false;
                        braceVal = '';
                        break;
                    case ']':
                        regEx += ('[' + bracketVal + ']');
                        inBrackets = false;
                        bracketVal = '';
                        break;
                    case '?':
                        regEx += NO_PATH_REGEX; // 1 ? matches any single character except path separator (/ and \)
                        continue;
                    case '*':
                        regEx += starsToRegExp(1);
                        continue;
                    default:
                        regEx += strings.escapeRegExpCharacters(char);
                }
            }
            // Tail: Add the slash we had split on if there is more to come and the remaining pattern is not a globstar
            // For example if pattern: some/**/*.js we want the "/" after some to be included in the RegEx to prevent
            // a folder called "something" to match as well.
            // However, if pattern: some/**, we tolerate that we also match on "something" because our globstar behavior
            // is to match 0-N segments.
            if (index < segments.length - 1 && (segments[index + 1] !== GLOBSTAR || index + 2 < segments.length)) {
                regEx += PATH_REGEX;
            }
            // reset state
            previousSegmentWasGlobStar = false;
        });
    }
    return regEx;
}
// regexes to check for trivial glob patterns that just check for String#endsWith
const T1 = /^\*\*\/\*\.[\w\.-]+$/; // **/*.something
const T2 = /^\*\*\/([\w\.-]+)\/?$/; // **/something
const T3 = /^{\*\*\/[\*\.]?[\w\.-]+\/?(,\*\*\/[\*\.]?[\w\.-]+\/?)*}$/; // {**/*.something,**/*.else} or {**/package.json,**/project.json}
const T3_2 = /^{\*\*\/[\*\.]?[\w\.-]+(\/(\*\*)?)?(,\*\*\/[\*\.]?[\w\.-]+(\/(\*\*)?)?)*}$/; // Like T3, with optional trailing /**
const T4 = /^\*\*((\/[\w\.-]+)+)\/?$/; // **/something/else
const T5 = /^([\w\.-]+(\/[\w\.-]+)*)\/?$/; // something/else
const CACHE = new Map(); // new LRUCache<string, ParsedStringPattern>(10000); // bounded to 10000 elements
const FALSE = function () {
    return false;
};
const NULL = function () {
    return null;
};
function parsePattern(arg1, options) {
    if (!arg1) {
        return NULL;
    }
    // Handle IRelativePattern
    let pattern;
    if (typeof arg1 !== 'string') {
        pattern = arg1.pattern;
    }
    else {
        pattern = arg1;
    }
    // Whitespace trimming
    pattern = pattern.trim();
    // Check cache
    const patternKey = `${pattern}_${!!options.trimForExclusions}`;
    let parsedPattern = CACHE.get(patternKey);
    if (parsedPattern) {
        return wrapRelativePattern(parsedPattern, arg1);
    }
    // Check for Trivias
    let match;
    if (T1.test(pattern)) { // common pattern: **/*.txt just need endsWith check
        const base = pattern.substr(4); // '**/*'.length === 4
        parsedPattern = function (path, basename) {
            return path && strings.endsWith(path, base) ? pattern : null;
        };
    }
    else if (match = T2.exec(trimForExclusions(pattern, options))) { // common pattern: **/some.txt just need basename check
        parsedPattern = trivia2(match[1], pattern);
    }
    else if ((options.trimForExclusions ? T3_2 : T3).test(pattern)) { // repetition of common patterns (see above) {**/*.txt,**/*.png}
        parsedPattern = trivia3(pattern, options);
    }
    else if (match = T4.exec(trimForExclusions(pattern, options))) { // common pattern: **/something/else just need endsWith check
        parsedPattern = trivia4and5(match[1].substr(1), pattern, true);
    }
    else if (match = T5.exec(trimForExclusions(pattern, options))) { // common pattern: something/else just need equals check
        parsedPattern = trivia4and5(match[1], pattern, false);
    }
    // Otherwise convert to pattern
    // tslint:disable-next-line:one-line
    else {
        parsedPattern = toRegExp(pattern);
    }
    // Cache
    CACHE.set(patternKey, parsedPattern);
    return wrapRelativePattern(parsedPattern, arg1);
}
function wrapRelativePattern(parsedPattern, arg2) {
    if (typeof arg2 === 'string') {
        return parsedPattern;
    }
    return function (path, basename) {
        if (!paths.isEqualOrParent(path, arg2.base)) {
            return null;
        }
        return parsedPattern(paths.normalize(arg2.pathToRelative(arg2.base, path)), basename);
    };
}
function trimForExclusions(pattern, options) {
    return options.trimForExclusions && strings.endsWith(pattern, '/**') ? pattern.substr(0, pattern.length - 2) : pattern; // dropping **, tailing / is dropped later
}
// common pattern: **/some.txt just need basename check
function trivia2(base, originalPattern) {
    const slashBase = `/${base}`;
    const backslashBase = `\\${base}`;
    const parsedPattern = function (path, basename) {
        if (!path) {
            return null;
        }
        if (basename) {
            return basename === base ? originalPattern : null;
        }
        return path === base || strings.endsWith(path, slashBase) || strings.endsWith(path, backslashBase) ? originalPattern : null;
    };
    const basenames = [base];
    parsedPattern.basenames = basenames;
    parsedPattern.patterns = [originalPattern];
    parsedPattern.allBasenames = basenames;
    return parsedPattern;
}
// repetition of common patterns (see above) {**/*.txt,**/*.png}
function trivia3(pattern, options) {
    const parsedPatterns = aggregateBasenameMatches(pattern.slice(1, -1).split(',')
        .map(pattern => parsePattern(pattern, options))
        .filter(pattern => pattern !== NULL), pattern);
    const n = parsedPatterns.length;
    if (!n) {
        return NULL;
    }
    if (n === 1) {
        return parsedPatterns[0];
    }
    const parsedPattern = function (path, basename) {
        for (let i = 0, n = parsedPatterns.length; i < n; i++) {
            if (parsedPatterns[i](path, basename)) {
                return pattern;
            }
        }
        return null;
    };
    const withBasenames = parsedPatterns.find(pattern => !!pattern.allBasenames);
    // const withBasenames = arrays.first(parsedPatterns, pattern => !!(<ParsedStringPattern>pattern).allBasenames);
    if (withBasenames) {
        parsedPattern.allBasenames = withBasenames.allBasenames;
    }
    const allPaths = parsedPatterns.reduce((all, current) => current.allPaths ? all.concat(current.allPaths) : all, []);
    if (allPaths.length) {
        parsedPattern.allPaths = allPaths;
    }
    return parsedPattern;
}
// common patterns: **/something/else just need endsWith check, something/else just needs and equals check
function trivia4and5(path, pattern, matchPathEnds) {
    const nativePath = paths.nativeSep !== paths.sep ? path.replace(ALL_FORWARD_SLASHES, paths.nativeSep) : path;
    const nativePathEnd = paths.nativeSep + nativePath;
    // eslint-disable-next-line @typescript-eslint/no-shadow
    const parsedPattern = matchPathEnds ? function (path, basename) {
        return path && (path === nativePath || strings.endsWith(path, nativePathEnd)) ? pattern : null;
        // eslint-disable-next-line @typescript-eslint/no-shadow
    } : function (path, basename) {
        return path && path === nativePath ? pattern : null;
    };
    parsedPattern.allPaths = [(matchPathEnds ? '*/' : './') + path];
    return parsedPattern;
}
function toRegExp(pattern) {
    try {
        const regExp = new RegExp(`^${parseRegExp(pattern)}$`);
        return function (path, basename) {
            regExp.lastIndex = 0; // reset RegExp to its initial state to reuse it!
            return path && regExp.test(path) ? pattern : null;
        };
    }
    catch (error) {
        return NULL;
    }
}
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function match(arg1, path, hasSibling) {
    if (!arg1 || !path) {
        return false;
    }
    return parse(arg1)(path, undefined, hasSibling);
}
exports.match = match;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function parse(arg1, options = {}) {
    if (!arg1) {
        return FALSE;
    }
    // Glob with String
    if (typeof arg1 === 'string' || isRelativePattern(arg1)) {
        const parsedPattern = parsePattern(arg1, options);
        if (parsedPattern === NULL) {
            return FALSE;
        }
        const resultPattern = function (path, basename) {
            return !!parsedPattern(path, basename);
        };
        if (parsedPattern.allBasenames) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            resultPattern.allBasenames = parsedPattern.allBasenames;
        }
        if (parsedPattern.allPaths) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            resultPattern.allPaths = parsedPattern.allPaths;
        }
        return resultPattern;
    }
    // Glob with Expression
    return parsedExpression(arg1, options);
}
exports.parse = parse;
function hasSiblingPromiseFn(siblingsFn) {
    if (!siblingsFn) {
        return undefined;
    }
    let siblings;
    return (name) => {
        if (!siblings) {
            siblings = (siblingsFn() || Promise.resolve([]))
                .then(list => list ? listToMap(list) : {});
        }
        return siblings.then(map => !!map[name]);
    };
}
exports.hasSiblingPromiseFn = hasSiblingPromiseFn;
function hasSiblingFn(siblingsFn) {
    if (!siblingsFn) {
        return undefined;
    }
    let siblings;
    return (name) => {
        if (!siblings) {
            const list = siblingsFn();
            siblings = list ? listToMap(list) : {};
        }
        return !!siblings[name];
    };
}
exports.hasSiblingFn = hasSiblingFn;
function listToMap(list) {
    const map = {};
    for (const key of list) {
        map[key] = true;
    }
    return map;
}
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function isRelativePattern(obj) {
    const rp = obj;
    return rp && typeof rp.base === 'string' && typeof rp.pattern === 'string' && typeof rp.pathToRelative === 'function';
}
exports.isRelativePattern = isRelativePattern;
/**
 * Same as `parse`, but the ParsedExpression is guaranteed to return a Promise
 */
function parseToAsync(expression, options) {
    // eslint-disable-next-line @typescript-eslint/no-shadow
    const parsedExpression = parse(expression, options);
    return (path, basename, hasSibling) => {
        const result = parsedExpression(path, basename, hasSibling);
        return result instanceof Promise ? result : Promise.resolve(result);
    };
}
exports.parseToAsync = parseToAsync;
function getBasenameTerms(patternOrExpression) {
    return patternOrExpression.allBasenames || [];
}
exports.getBasenameTerms = getBasenameTerms;
function getPathTerms(patternOrExpression) {
    return patternOrExpression.allPaths || [];
}
exports.getPathTerms = getPathTerms;
function parsedExpression(expression, options) {
    const parsedPatterns = aggregateBasenameMatches(Object.getOwnPropertyNames(expression)
        .map(pattern => parseExpressionPattern(pattern, expression[pattern], options))
        .filter(pattern => pattern !== NULL));
    const n = parsedPatterns.length;
    if (!n) {
        return NULL;
    }
    if (!parsedPatterns.some(parsedPattern => parsedPattern.requiresSiblings)) {
        if (n === 1) {
            return parsedPatterns[0];
        }
        // eslint-disable-next-line @typescript-eslint/no-shadow
        const resultExpression = function (path, basename) {
            // eslint-disable-next-line @typescript-eslint/no-shadow
            // tslint:disable-next-line:one-variable-per-declaration
            for (let i = 0, n = parsedPatterns.length; i < n; i++) {
                // Pattern matches path
                const result = parsedPatterns[i](path, basename);
                if (result) {
                    return result;
                }
            }
            return null;
        };
        // eslint-disable-next-line @typescript-eslint/no-shadow
        const withBasenames = parsedPatterns.find(pattern => !!pattern.allBasenames);
        if (withBasenames) {
            resultExpression.allBasenames = withBasenames.allBasenames;
        }
        // eslint-disable-next-line @typescript-eslint/no-shadow
        const allPaths = parsedPatterns.reduce((all, current) => current.allPaths ? all.concat(current.allPaths) : all, []);
        if (allPaths.length) {
            resultExpression.allPaths = allPaths;
        }
        return resultExpression;
    }
    const resultExpression = function (path, basename, hasSibling) {
        let name = null;
        // eslint-disable-next-line @typescript-eslint/no-shadow
        for (let i = 0, n = parsedPatterns.length; i < n; i++) {
            // Pattern matches path
            const parsedPattern = parsedPatterns[i];
            if (parsedPattern.requiresSiblings && hasSibling) {
                if (!basename) {
                    basename = paths.basename(path);
                }
                if (!name) {
                    name = basename.substr(0, basename.length - paths.extname(path).length);
                }
            }
            const result = parsedPattern(path, basename, name, hasSibling);
            if (result) {
                return result;
            }
        }
        return null;
    };
    const withBasenames = parsedPatterns.find(pattern => !!pattern.allBasenames);
    if (withBasenames) {
        resultExpression.allBasenames = withBasenames.allBasenames;
    }
    const allPaths = parsedPatterns.reduce((all, current) => current.allPaths ? all.concat(current.allPaths) : all, []);
    if (allPaths.length) {
        resultExpression.allPaths = allPaths;
    }
    return resultExpression;
}
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function parseExpressionPattern(pattern, value, options) {
    if (value === false) {
        return NULL; // pattern is disabled
    }
    const parsedPattern = parsePattern(pattern, options);
    if (parsedPattern === NULL) {
        return NULL;
    }
    // Expression Pattern is <boolean>
    if (typeof value === 'boolean') {
        return parsedPattern;
    }
    // Expression Pattern is <SiblingClause>
    if (value) {
        const when = value.when;
        if (typeof when === 'string') {
            const result = (path, basename, name, hasSibling) => {
                if (!hasSibling || !parsedPattern(path, basename)) {
                    return null;
                }
                const clausePattern = when.replace('$(basename)', name);
                const matched = hasSibling(clausePattern);
                return matched instanceof Promise ?
                    matched.then(m => m ? pattern : null) :
                    matched ? pattern : null;
            };
            result.requiresSiblings = true;
            return result;
        }
    }
    // Expression is Anything
    return parsedPattern;
}
function aggregateBasenameMatches(parsedPatterns, result) {
    const basenamePatterns = parsedPatterns.filter(parsedPattern => !!parsedPattern.basenames);
    if (basenamePatterns.length < 2) {
        return parsedPatterns;
    }
    const basenames = basenamePatterns.reduce((all, current) => all.concat(current.basenames), []);
    let patterns;
    if (result) {
        patterns = [];
        // tslint:disable-next-line:one-variable-per-declaration
        for (let i = 0, n = basenames.length; i < n; i++) {
            patterns.push(result);
        }
    }
    else {
        patterns = basenamePatterns.reduce((all, current) => all.concat(current.patterns), []);
    }
    const aggregate = function (path, basename) {
        if (!path) {
            return null;
        }
        if (!basename) {
            let i;
            for (i = path.length; i > 0; i--) {
                const ch = path.charCodeAt(i - 1);
                if (ch === 47 /* Slash */ || ch === 92 /* Backslash */) {
                    break;
                }
            }
            basename = path.substr(i);
        }
        const index = basenames.indexOf(basename);
        return index !== -1 ? patterns[index] : null;
    };
    aggregate.basenames = basenames;
    aggregate.patterns = patterns;
    aggregate.allBasenames = basenames;
    const aggregatedPatterns = parsedPatterns.filter(parsedPattern => !parsedPattern.basenames);
    aggregatedPatterns.push(aggregate);
    return aggregatedPatterns;
}


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/custom-editors/paths.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/custom-editors/paths.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
// copied from https://github.com/Microsoft/vscode/blob/bf7ac9201e7a7d01741d4e6e64b5dc9f3197d97b/src/vs/base/common/paths.ts
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
/* eslint-disable no-void */
/* eslint-disable no-null/no-null */

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isEqualOrParent = exports.getRoot = exports.normalize = exports.extname = exports.basename = exports.nativeSep = exports.sep = void 0;
const os_1 = __webpack_require__(/*! @theia/core/lib/common/os */ "./node_modules/@theia/core/lib/common/os.js");
const strings_1 = __webpack_require__(/*! @theia/core/lib/common/strings */ "./node_modules/@theia/core/lib/common/strings.js");
/**
 * The forward slash path separator.
 */
exports.sep = '/';
/**
 * The native path separator depending on the OS.
 */
exports.nativeSep = os_1.isWindows ? '\\' : '/';
const _posixBadPath = /(\/\.\.?\/)|(\/\.\.?)$|^(\.\.?\/)|(\/\/+)|(\\)/;
const _winBadPath = /(\\\.\.?\\)|(\\\.\.?)$|^(\.\.?\\)|(\\\\+)|(\/)/;
function _isNormal(path, win) {
    return win
        ? !_winBadPath.test(path)
        : !_posixBadPath.test(path);
}
/**
 * @returns the base name of a path.
 */
function basename(path) {
    const idx = ~path.lastIndexOf('/') || ~path.lastIndexOf('\\');
    if (idx === 0) {
        return path;
    }
    else if (~idx === path.length - 1) {
        return basename(path.substring(0, path.length - 1));
    }
    else {
        return path.substr(~idx + 1);
    }
}
exports.basename = basename;
/**
 * @returns `.far` from `boo.far` or the empty string.
 */
function extname(path) {
    path = basename(path);
    const idx = ~path.lastIndexOf('.');
    return idx ? path.substring(~idx) : '';
}
exports.extname = extname;
function normalize(path, toOSPath) {
    if (path === null || path === void 0) {
        return path;
    }
    const len = path.length;
    if (len === 0) {
        return '.';
    }
    const wantsBackslash = os_1.isWindows && toOSPath;
    if (_isNormal(path, wantsBackslash)) {
        return path;
    }
    // eslint-disable-next-line @typescript-eslint/no-shadow
    const sep = wantsBackslash ? '\\' : '/';
    const root = getRoot(path, sep);
    // skip the root-portion of the path
    let start = root.length;
    let skip = false;
    let res = '';
    for (let end = root.length; end <= len; end++) {
        // either at the end or at a path-separator character
        if (end === len || path.charCodeAt(end) === 47 /* Slash */ || path.charCodeAt(end) === 92 /* Backslash */) {
            if (streql(path, start, end, '..')) {
                // skip current and remove parent (if there is already something)
                const prev_start = res.lastIndexOf(sep);
                const prev_part = res.slice(prev_start + 1);
                if ((root || prev_part.length > 0) && prev_part !== '..') {
                    res = prev_start === -1 ? '' : res.slice(0, prev_start);
                    skip = true;
                }
            }
            else if (streql(path, start, end, '.') && (root || res || end < len - 1)) {
                // skip current (if there is already something or if there is more to come)
                skip = true;
            }
            if (!skip) {
                const part = path.slice(start, end);
                if (res !== '' && res[res.length - 1] !== sep) {
                    res += sep;
                }
                res += part;
            }
            start = end + 1;
            skip = false;
        }
    }
    return root + res;
}
exports.normalize = normalize;
function streql(value, start, end, other) {
    return start + other.length === end && value.indexOf(other, start) === start;
}
/**
 * Computes the _root_ this path, like `getRoot('c:\files') === c:\`,
 * `getRoot('files:///files/path') === files:///`,
 * or `getRoot('\\server\shares\path') === \\server\shares\`
 */
// eslint-disable-next-line @typescript-eslint/no-shadow
function getRoot(path, sep = '/') {
    if (!path) {
        return '';
    }
    const len = path.length;
    let code = path.charCodeAt(0);
    if (code === 47 /* Slash */ || code === 92 /* Backslash */) {
        code = path.charCodeAt(1);
        if (code === 47 /* Slash */ || code === 92 /* Backslash */) {
            // UNC candidate \\localhost\shares\ddd
            //               ^^^^^^^^^^^^^^^^^^^
            code = path.charCodeAt(2);
            if (code !== 47 /* Slash */ && code !== 92 /* Backslash */) {
                // eslint-disable-next-line @typescript-eslint/no-shadow
                let pos = 3;
                const start = pos;
                for (; pos < len; pos++) {
                    code = path.charCodeAt(pos);
                    if (code === 47 /* Slash */ || code === 92 /* Backslash */) {
                        break;
                    }
                }
                code = path.charCodeAt(pos + 1);
                if (start !== pos && code !== 47 /* Slash */ && code !== 92 /* Backslash */) {
                    pos += 1;
                    for (; pos < len; pos++) {
                        code = path.charCodeAt(pos);
                        if (code === 47 /* Slash */ || code === 92 /* Backslash */) {
                            return path.slice(0, pos + 1) // consume this separator
                                .replace(/[\\/]/g, sep);
                        }
                    }
                }
            }
        }
        // /user/far
        // ^
        return sep;
    }
    else if ((code >= 65 /* A */ && code <= 90 /* Z */) || (code >= 97 /* a */ && code <= 122 /* z */)) {
        // check for windows drive letter c:\ or c:
        if (path.charCodeAt(1) === 58 /* Colon */) {
            code = path.charCodeAt(2);
            if (code === 47 /* Slash */ || code === 92 /* Backslash */) {
                // C:\fff
                // ^^^
                return path.slice(0, 2) + sep;
            }
            else {
                // C:
                // ^^
                return path.slice(0, 2);
            }
        }
    }
    // check for URI
    // scheme://authority/path
    // ^^^^^^^^^^^^^^^^^^^
    let pos = path.indexOf('://');
    if (pos !== -1) {
        pos += 3; // 3 -> "://".length
        for (; pos < len; pos++) {
            code = path.charCodeAt(pos);
            if (code === 47 /* Slash */ || code === 92 /* Backslash */) {
                return path.slice(0, pos + 1); // consume this separator
            }
        }
    }
    return '';
}
exports.getRoot = getRoot;
function isEqualOrParent(path, candidate, ignoreCase) {
    if (path === candidate) {
        return true;
    }
    if (!path || !candidate) {
        return false;
    }
    if (candidate.length > path.length) {
        return false;
    }
    if (ignoreCase) {
        const beginsWith = strings_1.startsWithIgnoreCase(path, candidate);
        if (!beginsWith) {
            return false;
        }
        if (candidate.length === path.length) {
            return true; // same path, different casing
        }
        let sepOffset = candidate.length;
        if (candidate.charAt(candidate.length - 1) === exports.nativeSep) {
            sepOffset--; // adjust the expected sep offset in case our candidate already ends in separator character
        }
        return path.charAt(sepOffset) === exports.nativeSep;
    }
    if (candidate.charAt(candidate.length - 1) !== exports.nativeSep) {
        candidate += exports.nativeSep;
    }
    return path.indexOf(candidate) === 0;
}
exports.isEqualOrParent = isEqualOrParent;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/documents-main.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/documents-main.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DocumentsMainImpl = exports.ModelReferenceCollection = void 0;
/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
const plugin_api_rpc_1 = __webpack_require__(/*! ../../common/plugin-api-rpc */ "./node_modules/@theia/plugin-ext/lib/common/plugin-api-rpc.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const vscode_uri_1 = __webpack_require__(/*! @theia/core/shared/vscode-uri */ "./node_modules/@theia/core/shared/vscode-uri/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const disposable_util_1 = __webpack_require__(/*! ../../common/disposable-util */ "./node_modules/@theia/plugin-ext/lib/common/disposable-util.js");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
class ModelReferenceCollection {
    constructor(maxAge = 1000 * 60 * 3, maxLength = 1024 * 1024 * 80) {
        this.maxAge = maxAge;
        this.maxLength = maxLength;
        this.data = new Array();
        this.length = 0;
    }
    dispose() {
        this.data = disposable_util_1.dispose(this.data) || [];
    }
    add(ref) {
        const length = ref.object.textEditorModel.getValueLength();
        const handle = setTimeout(_dispose, this.maxAge);
        const entry = { length, dispose: _dispose };
        const self = this;
        function _dispose() {
            const idx = self.data.indexOf(entry);
            if (idx >= 0) {
                self.length -= length;
                ref.dispose();
                clearTimeout(handle);
                self.data.splice(idx, 1);
            }
        }
        ;
        this.data.push(entry);
        this.length += length;
        this.cleanup();
    }
    cleanup() {
        while (this.length > this.maxLength) {
            this.data[0].dispose();
        }
    }
}
exports.ModelReferenceCollection = ModelReferenceCollection;
class DocumentsMainImpl {
    constructor(editorsAndDocuments, modelService, rpc, editorManager, openerService, shell, untitledResourceResolver, fileResourceResolver) {
        this.modelService = modelService;
        this.editorManager = editorManager;
        this.openerService = openerService;
        this.shell = shell;
        this.untitledResourceResolver = untitledResourceResolver;
        this.fileResourceResolver = fileResourceResolver;
        this.syncedModels = new Map();
        this.modelReferenceCache = new ModelReferenceCollection();
        this.saveTimeout = 1750;
        this.toDispose = new core_1.DisposableCollection(this.modelReferenceCache);
        this.proxy = rpc.getProxy(plugin_api_rpc_1.MAIN_RPC_CONTEXT.DOCUMENTS_EXT);
        this.toDispose.push(editorsAndDocuments);
        this.toDispose.push(editorsAndDocuments.onDocumentAdd(documents => documents.forEach(this.onModelAdded, this)));
        this.toDispose.push(editorsAndDocuments.onDocumentRemove(documents => documents.forEach(this.onModelRemoved, this)));
        this.toDispose.push(modelService.onModelModeChanged(this.onModelChanged, this));
        this.toDispose.push(modelService.onModelSaved(m => {
            this.proxy.$acceptModelSaved(m.textEditorModel.uri);
        }));
        this.toDispose.push(modelService.onModelWillSave(onWillSaveModelEvent => {
            onWillSaveModelEvent.waitUntil(new Promise(async (resolve, reject) => {
                setTimeout(() => reject(new Error(`Aborted onWillSaveTextDocument-event after ${this.saveTimeout}ms`)), this.saveTimeout);
                const edits = await this.proxy.$acceptModelWillSave(onWillSaveModelEvent.model.textEditorModel.uri, onWillSaveModelEvent.reason, this.saveTimeout);
                const editOperations = [];
                for (const edit of edits) {
                    const { range, text } = edit;
                    if (!range && !text) {
                        continue;
                    }
                    if (range && range.startLineNumber === range.endLineNumber && range.startColumn === range.endColumn && !edit.text) {
                        continue;
                    }
                    editOperations.push({
                        range: range ? monaco.Range.lift(range) : onWillSaveModelEvent.model.textEditorModel.getFullModelRange(),
                        /* eslint-disable-next-line no-null/no-null */
                        text: text || null,
                        forceMoveMarkers: edit.forceMoveMarkers
                    });
                }
                resolve(editOperations);
            }));
        }));
        this.toDispose.push(modelService.onModelDirtyChanged(m => {
            this.proxy.$acceptDirtyStateChanged(m.textEditorModel.uri, m.dirty);
        }));
    }
    dispose() {
        this.toDispose.dispose();
    }
    onModelChanged(event) {
        const modelUrl = event.model.textEditorModel.uri;
        if (this.syncedModels.has(modelUrl.toString())) {
            this.proxy.$acceptModelModeChanged(modelUrl, event.oldModeId, event.model.languageId);
        }
    }
    onModelAdded(model) {
        const modelUri = model.textEditorModel.uri;
        const key = modelUri.toString();
        const toDispose = new core_1.DisposableCollection(model.textEditorModel.onDidChangeContent(e => this.proxy.$acceptModelChanged(modelUri, {
            eol: e.eol,
            versionId: e.versionId,
            changes: e.changes.map(c => ({
                text: c.text,
                range: c.range,
                rangeLength: c.rangeLength,
                rangeOffset: c.rangeOffset
            }))
        }, model.dirty)), core_1.Disposable.create(() => this.syncedModels.delete(key)));
        this.syncedModels.set(key, toDispose);
        this.toDispose.push(toDispose);
    }
    onModelRemoved(url) {
        const model = this.syncedModels.get(url.toString());
        if (model) {
            model.dispose();
        }
    }
    async $tryCreateDocument(options) {
        const language = options && options.language;
        const content = options && options.content;
        const resource = await this.untitledResourceResolver.createUntitledResource(this.fileResourceResolver, content, language);
        return monaco.Uri.parse(resource.uri.toString());
    }
    async $tryShowDocument(uri, options) {
        // Removing try-catch block here makes it not possible to handle errors.
        // Following message is appeared in browser console
        //   - Uncaught (in promise) Error: Cannot read property 'message' of undefined.
        try {
            const editorOptions = DocumentsMainImpl.toEditorOpenerOptions(this.shell, options);
            const uriArg = new uri_1.default(vscode_uri_1.URI.revive(uri));
            const opener = await this.openerService.getOpener(uriArg, editorOptions);
            await opener.open(uriArg, editorOptions);
        }
        catch (err) {
            throw new Error(err);
        }
    }
    async $trySaveDocument(uri) {
        const widget = await this.editorManager.getByUri(new uri_1.default(vscode_uri_1.URI.revive(uri)));
        if (widget) {
            await browser_1.Saveable.save(widget);
            return true;
        }
        return false;
    }
    async $tryOpenDocument(uri) {
        const ref = await this.modelService.createModelReference(new uri_1.default(vscode_uri_1.URI.revive(uri)));
        if (ref.object) {
            this.modelReferenceCache.add(ref);
            return true;
        }
        else {
            ref.dispose();
            return false;
        }
    }
    async $tryCloseDocument(uri) {
        const widget = await this.editorManager.getByUri(new uri_1.default(vscode_uri_1.URI.revive(uri)));
        if (widget) {
            await browser_1.Saveable.save(widget);
            widget.close();
            return true;
        }
        return false;
    }
    static toEditorOpenerOptions(shell, options) {
        if (!options) {
            return undefined;
        }
        let range;
        if (options.selection) {
            const selection = options.selection;
            range = {
                start: { line: selection.startLineNumber - 1, character: selection.startColumn - 1 },
                end: { line: selection.endLineNumber - 1, character: selection.endColumn - 1 }
            };
        }
        /* fall back to side group -> split relative to the active widget */
        let widgetOptions = { mode: 'split-right' };
        const viewColumn = options.viewColumn;
        if (viewColumn === undefined || viewColumn === -1) {
            /* active group -> skip (default behaviour) */
            widgetOptions = undefined;
        }
        else if (viewColumn > 0) {
            const tabBars = shell.mainAreaTabBars;
            // convert to zero-based index
            const tabBar = tabBars[viewColumn - 1];
            if (tabBar && tabBar.currentTitle) {
                widgetOptions = { ref: tabBar.currentTitle.owner };
            }
        }
        return {
            selection: range,
            mode: options.preserveFocus ? 'reveal' : 'activate',
            preview: options.preview,
            widgetOptions
        };
    }
}
exports.DocumentsMainImpl = DocumentsMainImpl;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/editor/untitled-resource.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/editor/untitled-resource.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createUntitledURI = exports.UntitledResource = exports.UntitledResourceResolver = void 0;
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "./node_modules/@theia/core/lib/common/event.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const uri_components_1 = __webpack_require__(/*! ../../../common/uri-components */ "./node_modules/@theia/plugin-ext/lib/common/uri-components.js");
const browser_1 = __webpack_require__(/*! @theia/filesystem/lib/browser */ "./node_modules/@theia/filesystem/lib/browser/index.js");
let index = 0;
let UntitledResourceResolver = class UntitledResourceResolver {
    constructor() {
        this.resources = new Map();
    }
    async resolve(uri) {
        if (uri.scheme !== uri_components_1.Schemes.untitled) {
            throw new Error('The given uri is not untitled file uri: ' + uri);
        }
        else {
            const untitledResource = this.resources.get(uri.toString());
            if (!untitledResource) {
                return this.createUntitledResource(this.fileResourceResolver, '', '', uri);
            }
            else {
                return untitledResource;
            }
        }
    }
    async createUntitledResource(fileResourceResolver, content, language, uri) {
        let extension;
        if (language) {
            for (const lang of monaco.languages.getLanguages()) {
                if (lang.id === language) {
                    if (lang.extensions) {
                        extension = lang.extensions[0];
                        break;
                    }
                }
            }
        }
        return new UntitledResource(this.resources, uri ? uri : new uri_1.default().withScheme(uri_components_1.Schemes.untitled).withPath(`/Untitled-${index++}${extension ? extension : ''}`), fileResourceResolver, content);
    }
};
__decorate([
    inversify_1.inject(browser_1.FileResourceResolver),
    __metadata("design:type", browser_1.FileResourceResolver)
], UntitledResourceResolver.prototype, "fileResourceResolver", void 0);
UntitledResourceResolver = __decorate([
    inversify_1.injectable()
], UntitledResourceResolver);
exports.UntitledResourceResolver = UntitledResourceResolver;
class UntitledResource {
    constructor(resources, uri, fileResourceResolver, content) {
        this.resources = resources;
        this.uri = uri;
        this.fileResourceResolver = fileResourceResolver;
        this.content = content;
        this.onDidChangeContentsEmitter = new event_1.Emitter();
        this.onDidChangeContents = this.onDidChangeContentsEmitter.event;
        this.resources.set(this.uri.toString(), this);
    }
    dispose() {
        this.resources.delete(this.uri.toString());
        this.onDidChangeContentsEmitter.dispose();
        if (this.fileResource) {
            this.fileResource.dispose();
        }
    }
    async readContents(options) {
        if (this.fileResource) {
            return this.fileResource.readContents(options);
        }
        else if (this.content) {
            return this.content;
        }
        else {
            return '';
        }
    }
    async saveContents(content, options) {
        if (!this.fileResource) {
            this.fileResource = await this.fileResourceResolver.resolve(new uri_1.default(this.uri.path.toString()));
            if (this.fileResource.onDidChangeContents) {
                this.fileResource.onDidChangeContents(() => this.fireDidChangeContents());
            }
        }
        await this.fileResource.saveContents(content, options);
    }
    async saveContentChanges(changes, options) {
        if (!this.fileResource || !this.fileResource.saveContentChanges) {
            throw new Error('FileResource is not available for: ' + this.uri.path.toString());
        }
        await this.fileResource.saveContentChanges(changes, options);
    }
    async guessEncoding() {
        if (this.fileResource) {
            return this.fileResource.guessEncoding();
        }
    }
    fireDidChangeContents() {
        this.onDidChangeContentsEmitter.fire(undefined);
    }
    get version() {
        if (this.fileResource) {
            return this.fileResource.version;
        }
        return undefined;
    }
    get encoding() {
        if (this.fileResource) {
            return this.fileResource.encoding;
        }
        return undefined;
    }
}
exports.UntitledResource = UntitledResource;
function createUntitledURI(language) {
    let extension;
    if (language) {
        for (const lang of monaco.languages.getLanguages()) {
            if (lang.id === language) {
                if (lang.extensions) {
                    extension = lang.extensions[0];
                    break;
                }
            }
        }
    }
    return new uri_1.default().withScheme(uri_components_1.Schemes.untitled).withPath(`/Untitled-${index++}${extension ? extension : ''}`);
}
exports.createUntitledURI = createUntitledURI;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/menus/menus-contribution-handler.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/menus/menus-contribution-handler.js ***!
  \*********************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var MenusContributionPointHandler_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MenuTree = exports.MenusContributionPointHandler = exports.CodeEditorWidgetUtil = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
const vscode_uri_1 = __webpack_require__(/*! @theia/core/shared/vscode-uri */ "./node_modules/@theia/core/shared/vscode-uri/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "./node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/editor/lib/browser */ "./node_modules/@theia/editor/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "./node_modules/@theia/core/lib/common/event.js");
const tab_bar_toolbar_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/tab-bar-toolbar */ "./node_modules/@theia/core/lib/browser/shell/tab-bar-toolbar.js");
const navigator_contribution_1 = __webpack_require__(/*! @theia/navigator/lib/browser/navigator-contribution */ "./node_modules/@theia/navigator/lib/browser/navigator-contribution.js");
const tree_view_widget_1 = __webpack_require__(/*! ../view/tree-view-widget */ "./node_modules/@theia/plugin-ext/lib/main/browser/view/tree-view-widget.js");
const common_2 = __webpack_require__(/*! ../../../common */ "./node_modules/@theia/plugin-ext/lib/common/index.js");
const debug_stack_frames_widget_1 = __webpack_require__(/*! @theia/debug/lib/browser/view/debug-stack-frames-widget */ "./node_modules/@theia/debug/lib/browser/view/debug-stack-frames-widget.js");
const debug_threads_widget_1 = __webpack_require__(/*! @theia/debug/lib/browser/view/debug-threads-widget */ "./node_modules/@theia/debug/lib/browser/view/debug-threads-widget.js");
const tree_widget_selection_1 = __webpack_require__(/*! @theia/core/lib/browser/tree/tree-widget-selection */ "./node_modules/@theia/core/lib/browser/tree/tree-widget-selection.js");
const scm_widget_1 = __webpack_require__(/*! @theia/scm/lib/browser/scm-widget */ "./node_modules/@theia/scm/lib/browser/scm-widget.js");
const scm_tree_widget_1 = __webpack_require__(/*! @theia/scm/lib/browser/scm-tree-widget */ "./node_modules/@theia/scm/lib/browser/scm-tree-widget.js");
const scm_service_1 = __webpack_require__(/*! @theia/scm/lib/browser/scm-service */ "./node_modules/@theia/scm/lib/browser/scm-service.js");
const scm_repository_1 = __webpack_require__(/*! @theia/scm/lib/browser/scm-repository */ "./node_modules/@theia/scm/lib/browser/scm-repository.js");
const scm_main_1 = __webpack_require__(/*! ../scm-main */ "./node_modules/@theia/plugin-ext/lib/main/browser/scm-main.js");
const resource_context_key_1 = __webpack_require__(/*! @theia/core/lib/browser/resource-context-key */ "./node_modules/@theia/core/lib/browser/resource-context-key.js");
const plugin_view_widget_1 = __webpack_require__(/*! ../view/plugin-view-widget */ "./node_modules/@theia/plugin-ext/lib/main/browser/view/plugin-view-widget.js");
const view_context_key_service_1 = __webpack_require__(/*! ../view/view-context-key-service */ "./node_modules/@theia/plugin-ext/lib/main/browser/view/view-context-key-service.js");
const webview_1 = __webpack_require__(/*! ../webview/webview */ "./node_modules/@theia/plugin-ext/lib/main/browser/webview/webview.js");
const navigatable_1 = __webpack_require__(/*! @theia/core/lib/browser/navigatable */ "./node_modules/@theia/core/lib/browser/navigatable.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "./node_modules/@theia/core/lib/browser/context-key-service.js");
const timeline_tree_widget_1 = __webpack_require__(/*! @theia/timeline/lib/browser/timeline-tree-widget */ "./node_modules/@theia/timeline/lib/browser/timeline-tree-widget.js");
const comment_thread_widget_1 = __webpack_require__(/*! ../comments/comment-thread-widget */ "./node_modules/@theia/plugin-ext/lib/main/browser/comments/comment-thread-widget.js");
const browser_2 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
let CodeEditorWidgetUtil = class CodeEditorWidgetUtil {
    is(arg) {
        return arg instanceof browser_1.EditorWidget || arg instanceof webview_1.WebviewWidget;
    }
    getResourceUri(editor) {
        const resourceUri = navigatable_1.Navigatable.is(editor) && editor.getResourceUri();
        return resourceUri ? resourceUri['codeUri'] : undefined;
    }
};
CodeEditorWidgetUtil = __decorate([
    inversify_1.injectable()
], CodeEditorWidgetUtil);
exports.CodeEditorWidgetUtil = CodeEditorWidgetUtil;
let MenusContributionPointHandler = MenusContributionPointHandler_1 = class MenusContributionPointHandler {
    handle(plugin) {
        const allMenus = plugin.contributes && plugin.contributes.menus;
        if (!allMenus) {
            return core_1.Disposable.NULL;
        }
        const toDispose = new core_1.DisposableCollection();
        const tree = this.getMenusTree(plugin);
        tree.forEach(rootMenu => {
            const registerMenuActions = (menus, group, submenusOrder = '') => {
                menus.forEach(menu => {
                    if (group) {
                        // Adding previous group to the start of current menu group.
                        menu.group = `${group}/${menu.group || '_'}`;
                    }
                    if (menu.isSubmenu) {
                        let [submenuGroup, submenuOrder = ''] = (menu.group || '_').split('@');
                        // Generating group in format: `<submenu group>/<submenu name>`
                        submenuGroup = `${submenuGroup}/${menu.label}`;
                        if (submenusOrder) {
                            // Adding previous submenus order to the start of current submenu order
                            // in format: `<submenu order>/<submenu order>.../<menu order>`.
                            submenuOrder = `${submenusOrder}/${submenuOrder}`;
                        }
                        registerMenuActions(menu.children, submenuGroup, submenuOrder);
                    }
                    else {
                        menu.submenusOrder = submenusOrder;
                        toDispose.push(this.registerAction(plugin, rootMenu.id, menu));
                    }
                });
            };
            registerMenuActions(rootMenu.children, undefined, undefined);
        });
        return toDispose;
    }
    /**
     * Transforms the structure of Menus & Submenus
     * into something more tree-like.
     */
    getMenusTree(plugin) {
        const allMenus = plugin.contributes && plugin.contributes.menus;
        if (!allMenus) {
            return [];
        }
        const allSubmenus = plugin.contributes && plugin.contributes.submenus;
        const tree = [];
        Object.keys(allMenus).forEach(location => {
            // Don't build menus tree for a submenu declaration at root.
            if (allSubmenus && allSubmenus.findIndex(submenu => submenu.id === location) > -1) {
                return;
            }
            /**
             * @param menus the menus to create a tree from.
             * @param submenusIds contains all the previous submenus ids in the current tree.
             * @returns {MenuTree[]} the trees for the given menus.
             */
            const getChildren = (menus, submenusIds) => {
                // Contains all the submenus ids of the current parent.
                const parentSubmenusIds = new Set();
                return menus.reduce((children, menuItem) => {
                    if (menuItem.submenu) {
                        if (parentSubmenusIds.has(menuItem.submenu)) {
                            console.warn(`Submenu ${menuItem.submenu} already registered`);
                        }
                        else if (submenusIds.has(menuItem.submenu)) {
                            console.warn(`Found submenu cycle: ${menuItem.submenu}`);
                        }
                        else {
                            parentSubmenusIds.add(menuItem.submenu);
                            const submenu = allSubmenus.find(s => s.id === menuItem.submenu);
                            const menuTree = new MenuTree(Object.assign({}, menuItem), menuItem.submenu, submenu.label);
                            menuTree.children = getChildren(allMenus[submenu.id], new Set([...submenusIds, menuItem.submenu]));
                            children.push(menuTree);
                        }
                    }
                    else {
                        children.push(new MenuTree(Object.assign({}, menuItem)));
                    }
                    return children;
                }, []);
            };
            const rootMenu = new MenuTree(undefined, location);
            rootMenu.children = getChildren(allMenus[location], new Set());
            tree.push(rootMenu);
        });
        return tree;
    }
    registerAction(plugin, location, action) {
        const allMenus = plugin.contributes && plugin.contributes.menus;
        if (!allMenus) {
            return core_1.Disposable.NULL;
        }
        switch (location) {
            case 'commandPalette': return this.registerCommandPaletteAction(action);
            case 'editor/title': return this.registerEditorTitleAction(location, action);
            case 'view/title': return this.registerViewTitleAction(location, action);
            case 'view/item/context': return this.registerViewItemContextAction(action);
            case 'scm/title': return this.registerScmTitleAction(location, action);
            case 'scm/resourceGroup/context': return this.registerScmResourceGroupAction(action);
            case 'scm/resourceFolder/context': return this.registerScmResourceFolderAction(action);
            case 'scm/resourceState/context': return this.registerScmResourceStateAction(action);
            case 'timeline/item/context': return this.registerTimelineItemAction(action);
            case 'comments/commentThread/context': return this.registerCommentThreadAction(action, plugin);
            case 'comments/comment/title': return this.registerCommentTitleAction(action);
            case 'comments/comment/context': return this.registerCommentContextAction(action);
            case 'debug/callstack/context': return this.registerDebugCallstackAction(action);
            default:
                if (allMenus.hasOwnProperty(location)) {
                    return this.registerGlobalMenuAction(action, location, plugin);
                }
                return core_1.Disposable.NULL;
        }
    }
    static parseMenuPaths(value) {
        switch (value) {
            case 'editor/context': return [browser_1.EDITOR_CONTEXT_MENU];
            case 'explorer/context': return [navigator_contribution_1.NAVIGATOR_CONTEXT_MENU];
        }
        return [];
    }
    registerCommandPaletteAction(menu) {
        if (menu.command && menu.when) {
            return this.quickCommandService.pushCommandContext(menu.command, menu.when);
        }
        return core_1.Disposable.NULL;
    }
    registerEditorTitleAction(location, action) {
        return this.registerTitleAction(location, action, {
            execute: widget => this.codeEditorWidgetUtil.is(widget) &&
                this.commands.executeCommand(action.command, this.codeEditorWidgetUtil.getResourceUri(widget)),
            isEnabled: widget => this.codeEditorWidgetUtil.is(widget) && this.commands.isEnabled(action.command, this.codeEditorWidgetUtil.getResourceUri(widget)),
            isVisible: widget => this.codeEditorWidgetUtil.is(widget) && this.commands.isVisible(action.command, this.codeEditorWidgetUtil.getResourceUri(widget))
        });
    }
    registerViewTitleAction(location, action) {
        return this.registerTitleAction(location, action, {
            execute: widget => widget instanceof plugin_view_widget_1.PluginViewWidget && this.commands.executeCommand(action.command),
            isEnabled: widget => widget instanceof plugin_view_widget_1.PluginViewWidget && this.commands.isEnabled(action.command),
            isVisible: widget => widget instanceof plugin_view_widget_1.PluginViewWidget && this.commands.isVisible(action.command),
        });
    }
    registerViewItemContextAction(menu) {
        const inline = menu.group && /^inline/.test(menu.group) || false;
        const menuPath = inline ? tree_view_widget_1.VIEW_ITEM_INLINE_MENU : tree_view_widget_1.VIEW_ITEM_CONTEXT_MENU;
        return this.registerTreeMenuAction(menuPath, menu);
    }
    registerScmResourceGroupAction(menu) {
        const inline = menu.group && /^inline/.test(menu.group) || false;
        const menuPath = inline ? scm_tree_widget_1.ScmTreeWidget.RESOURCE_GROUP_INLINE_MENU : scm_tree_widget_1.ScmTreeWidget.RESOURCE_GROUP_CONTEXT_MENU;
        return this.registerScmMenuAction(menuPath, menu);
    }
    registerScmResourceFolderAction(menu) {
        const inline = menu.group && /^inline/.test(menu.group) || false;
        const menuPath = inline ? scm_tree_widget_1.ScmTreeWidget.RESOURCE_FOLDER_INLINE_MENU : scm_tree_widget_1.ScmTreeWidget.RESOURCE_FOLDER_CONTEXT_MENU;
        return this.registerScmMenuAction(menuPath, menu);
    }
    registerScmResourceStateAction(menu) {
        const inline = menu.group && /^inline/.test(menu.group) || false;
        const menuPath = inline ? scm_tree_widget_1.ScmTreeWidget.RESOURCE_INLINE_MENU : scm_tree_widget_1.ScmTreeWidget.RESOURCE_CONTEXT_MENU;
        return this.registerScmMenuAction(menuPath, menu);
    }
    registerTimelineItemAction(menu) {
        return this.registerMenuAction(timeline_tree_widget_1.TIMELINE_ITEM_CONTEXT_MENU, menu, command => ({
            execute: (...args) => this.commands.executeCommand(command, ...this.toTimelineArgs(...args)),
            isEnabled: (...args) => this.commands.isEnabled(command, ...this.toTimelineArgs(...args)),
            isVisible: (...args) => this.commands.isVisible(command, ...this.toTimelineArgs(...args))
        }));
    }
    registerCommentThreadAction(menu, plugin) {
        return this.registerMenuAction(comment_thread_widget_1.COMMENT_THREAD_CONTEXT, menu, command => ({
            execute: (...args) => this.commands.executeCommand(command, ...this.toCommentArgs(...args)),
            isEnabled: () => {
                var _a;
                const commandContributions = (_a = plugin.contributes) === null || _a === void 0 ? void 0 : _a.commands;
                if (commandContributions) {
                    const commandContribution = commandContributions.find(c => c.command === command);
                    if (commandContribution && commandContribution.enablement) {
                        return this.contextKeyService.match(commandContribution.enablement);
                    }
                }
                return true;
            },
            isVisible: (...args) => this.commands.isVisible(command, ...this.toCommentArgs(...args))
        }));
    }
    registerCommentTitleAction(menu) {
        return this.registerMenuAction(comment_thread_widget_1.COMMENT_TITLE, menu, command => ({
            execute: (...args) => this.commands.executeCommand(command, ...this.toCommentArgs(...args)),
            isEnabled: (...args) => this.commands.isEnabled(command, ...this.toCommentArgs(...args)),
            isVisible: (...args) => this.commands.isVisible(command, ...this.toCommentArgs(...args))
        }));
    }
    registerCommentContextAction(menu) {
        return this.registerMenuAction(comment_thread_widget_1.COMMENT_CONTEXT, menu, command => ({
            execute: (...args) => this.commands.executeCommand(command, ...this.toCommentArgs(...args)),
            isEnabled: () => true,
            isVisible: (...args) => this.commands.isVisible(command, ...this.toCommentArgs(...args))
        }));
    }
    registerDebugCallstackAction(menu) {
        const toDispose = new core_1.DisposableCollection();
        [debug_stack_frames_widget_1.DebugStackFramesWidget.CONTEXT_MENU, debug_threads_widget_1.DebugThreadsWidget.CONTEXT_MENU].forEach(menuPath => {
            toDispose.push(this.registerMenuAction(menuPath, menu, command => ({
                execute: (...args) => this.commands.executeCommand(command, args[0]),
                isEnabled: (...args) => this.commands.isEnabled(command, args[0]),
                isVisible: (...args) => this.commands.isVisible(command, args[0])
            })));
        });
        return toDispose;
    }
    registerTreeMenuAction(menuPath, menu) {
        return this.registerMenuAction(menuPath, menu, command => ({
            execute: (...args) => this.commands.executeCommand(command, ...this.toTreeArgs(...args)),
            isEnabled: (...args) => this.commands.isEnabled(command, ...this.toTreeArgs(...args)),
            isVisible: (...args) => this.commands.isVisible(command, ...this.toTreeArgs(...args))
        }));
    }
    toTreeArgs(...args) {
        const treeArgs = [];
        for (const arg of args) {
            if (common_2.TreeViewSelection.is(arg)) {
                treeArgs.push(arg);
            }
        }
        return treeArgs;
    }
    registerTitleAction(location, action, handler) {
        if (!action.command) {
            return core_1.Disposable.NULL;
        }
        const toDispose = new core_1.DisposableCollection();
        const id = this.createSyntheticCommandId(action.command, { prefix: `__plugin.${location.replace('/', '.')}.action.` });
        const command = { id };
        toDispose.push(this.commands.registerCommand(command, handler));
        const { when } = action;
        const whenKeys = when && this.contextKeyService.parseKeys(when);
        let onDidChange;
        if (whenKeys && whenKeys.size) {
            const onDidChangeEmitter = new event_1.Emitter();
            toDispose.push(onDidChangeEmitter);
            onDidChange = onDidChangeEmitter.event;
            this.contextKeyService.onDidChange.maxListeners = this.contextKeyService.onDidChange.maxListeners + 1;
            toDispose.push(this.contextKeyService.onDidChange(event => {
                if (event.affects(whenKeys)) {
                    onDidChangeEmitter.fire(undefined);
                }
            }));
            toDispose.push(core_1.Disposable.create(() => {
                this.contextKeyService.onDidChange.maxListeners = this.contextKeyService.onDidChange.maxListeners - 1;
            }));
        }
        // handle group and priority
        // if group is empty or white space is will be set to navigation
        // ' ' => ['navigation', 0]
        // 'navigation@1' => ['navigation', 1]
        // '1_rest-client@2' => ['1_rest-client', 2]
        // if priority is not a number it will be set to 0
        // navigation@test => ['navigation', 0]
        const [group, sort] = (action.group || 'navigation').split('@');
        const item = { id, command: id, group: group.trim() || 'navigation', priority: ~~sort || undefined, when, onDidChange };
        toDispose.push(this.tabBarToolbar.registerItem(item));
        toDispose.push(this.onDidRegisterCommand(action.command, pluginCommand => {
            command.category = pluginCommand.category;
            item.tooltip = pluginCommand.label;
            if (group === 'navigation') {
                command.iconClass = pluginCommand.iconClass;
            }
        }));
        return toDispose;
    }
    registerScmTitleAction(location, action) {
        if (!action.command) {
            return core_1.Disposable.NULL;
        }
        const selectedRepository = () => this.toScmArg(this.scmService.selectedRepository);
        return this.registerTitleAction(location, action, {
            execute: widget => widget instanceof scm_widget_1.ScmWidget && this.commands.executeCommand(action.command, selectedRepository()),
            isEnabled: widget => widget instanceof scm_widget_1.ScmWidget && this.commands.isEnabled(action.command, selectedRepository()),
            isVisible: widget => widget instanceof scm_widget_1.ScmWidget && this.commands.isVisible(action.command, selectedRepository())
        });
    }
    registerScmMenuAction(menuPath, menu) {
        return this.registerMenuAction(menuPath, menu, command => ({
            execute: (...args) => this.commands.executeCommand(command, ...this.toScmArgs(...args)),
            isEnabled: (...args) => this.commands.isEnabled(command, ...this.toScmArgs(...args)),
            isVisible: (...args) => this.commands.isVisible(command, ...this.toScmArgs(...args))
        }));
    }
    toScmArgs(...args) {
        const scmArgs = [];
        for (const arg of args) {
            const scmArg = this.toScmArg(arg);
            if (scmArg) {
                scmArgs.push(scmArg);
            }
        }
        return scmArgs;
    }
    toScmArg(arg) {
        if (arg instanceof scm_repository_1.ScmRepository && arg.provider instanceof scm_main_1.PluginScmProvider) {
            return {
                sourceControlHandle: arg.provider.handle
            };
        }
        if (arg instanceof scm_main_1.PluginScmResourceGroup) {
            return {
                sourceControlHandle: arg.provider.handle,
                resourceGroupHandle: arg.handle
            };
        }
        if (arg instanceof scm_main_1.PluginScmResource) {
            return {
                sourceControlHandle: arg.group.provider.handle,
                resourceGroupHandle: arg.group.handle,
                resourceStateHandle: arg.handle
            };
        }
    }
    toTimelineArgs(...args) {
        const timelineArgs = [];
        const arg = args[0];
        timelineArgs.push(this.toTimelineArg(arg));
        timelineArgs.push(vscode_uri_1.URI.parse(arg.uri));
        timelineArgs.push('source' in arg ? arg.source : '');
        return timelineArgs;
    }
    toTimelineArg(arg) {
        return {
            timelineHandle: arg.handle,
            source: arg.source,
            uri: arg.uri
        };
    }
    toCommentArgs(...args) {
        const arg = args[0];
        if ('text' in arg) {
            if ('commentUniqueId' in arg) {
                return [{
                        commentControlHandle: arg.thread.controllerHandle,
                        commentThreadHandle: arg.thread.commentThreadHandle,
                        text: arg.text,
                        commentUniqueId: arg.commentUniqueId
                    }];
            }
            return [{
                    commentControlHandle: arg.thread.controllerHandle,
                    commentThreadHandle: arg.thread.commentThreadHandle,
                    text: arg.text
                }];
        }
        return [{
                commentControlHandle: arg.thread.controllerHandle,
                commentThreadHandle: arg.thread.commentThreadHandle,
                commentUniqueId: arg.commentUniqueId
            }];
    }
    registerGlobalMenuAction(menu, location, plugin) {
        const menuPaths = MenusContributionPointHandler_1.parseMenuPaths(location);
        if (!menuPaths.length) {
            this.logger.warn(`'${plugin.metadata.model.id}' plugin contributes items to a menu with invalid identifier: ${location}`);
            return core_1.Disposable.NULL;
        }
        const selectedResource = () => {
            const selection = this.selectionService.selection;
            if (tree_widget_selection_1.TreeWidgetSelection.is(selection) && selection.source instanceof tree_view_widget_1.TreeViewWidget && selection[0]) {
                return selection.source.toTreeViewSelection(selection[0]);
            }
            const uri = this.resourceContextKey.get();
            return uri ? uri['codeUri'] : undefined;
        };
        const toDispose = new core_1.DisposableCollection();
        menuPaths.forEach(menuPath => {
            toDispose.push(this.registerMenuAction(menuPath, menu, command => ({
                execute: () => this.commands.executeCommand(command, selectedResource()),
                isEnabled: () => this.commands.isEnabled(command, selectedResource()),
                isVisible: () => this.commands.isVisible(command, selectedResource())
            })));
        });
        return toDispose;
    }
    registerMenuAction(menuPath, menu, handler) {
        var _a, _b;
        if (!menu.command) {
            return core_1.Disposable.NULL;
        }
        const toDispose = new core_1.DisposableCollection();
        const commandId = this.createSyntheticCommandId(menu.command, { prefix: '__plugin.menu.action.' });
        const command = { id: commandId };
        toDispose.push(this.commands.registerCommand(command, handler(menu.command)));
        toDispose.push((_a = this.quickCommandService) === null || _a === void 0 ? void 0 : _a.pushCommandContext(commandId, 'false'));
        let altId;
        if (menu.alt) {
            altId = this.createSyntheticCommandId(menu.alt, { prefix: '__plugin.menu.action.' });
            const alt = { id: altId };
            toDispose.push(this.commands.registerCommand(alt, handler(menu.alt)));
            toDispose.push((_b = this.quickCommandService) === null || _b === void 0 ? void 0 : _b.pushCommandContext(altId, 'false'));
            toDispose.push(this.onDidRegisterCommand(menu.alt, pluginCommand => {
                alt.category = pluginCommand.category;
                alt.label = pluginCommand.label;
                if (inline) {
                    alt.iconClass = pluginCommand.iconClass;
                }
            }));
        }
        const { when } = menu;
        const [group, order = undefined] = (menu.group || '_').split('@');
        const action = { commandId, alt: altId, order, when };
        // Register a submenu if the group is in format `<submenu group>/<submenu name>/<submenu order>.../<menu group>`
        if (group.indexOf('/') !== -1) {
            const groupSplit = group.split('/');
            const orderSplit = (menu.submenusOrder || '').split('/');
            const paths = [];
            for (let i = 0, j = 0; i < groupSplit.length - 1; i += 2, j += 1) {
                const submenuGroup = groupSplit[i];
                const submenuLabel = groupSplit[i + 1];
                const submenuOrder = orderSplit[j];
                paths.push(submenuGroup, submenuLabel);
                toDispose.push(this.menuRegistry.registerSubmenu([...menuPath, ...paths], submenuLabel, { order: submenuOrder }));
            }
        }
        const inline = /^inline/.test(group);
        menuPath = inline ? menuPath : [...menuPath, ...group.split('/')];
        toDispose.push(this.menuRegistry.registerMenuAction(menuPath, action));
        toDispose.push(this.onDidRegisterCommand(menu.command, pluginCommand => {
            command.category = pluginCommand.category;
            command.label = pluginCommand.label;
            if (inline) {
                command.iconClass = pluginCommand.iconClass;
            }
        }));
        return toDispose;
    }
    createSyntheticCommandId(command, { prefix }) {
        let id = prefix + command;
        let index = 0;
        while (this.commands.getCommand(id)) {
            id = prefix + command + ':' + index;
            index++;
        }
        return id;
    }
    onDidRegisterCommand(id, cb) {
        const command = this.commands.getCommand(id);
        if (command) {
            cb(command);
            return core_1.Disposable.NULL;
        }
        const toDispose = new core_1.DisposableCollection();
        // Registering a menu action requires the related command to be already registered.
        // But Theia plugin registers the commands dynamically via the Commands API.
        // Let's wait for ~2 sec. It should be enough to finish registering all the contributed commands.
        // FIXME: remove this workaround (timer) once the https://github.com/theia-ide/theia/issues/3344 is fixed
        const handle = setTimeout(() => toDispose.push(this.onDidRegisterCommand(id, cb)), 2000);
        toDispose.push(core_1.Disposable.create(() => clearTimeout(handle)));
        return toDispose;
    }
};
__decorate([
    inversify_1.inject(common_1.MenuModelRegistry),
    __metadata("design:type", common_1.MenuModelRegistry)
], MenusContributionPointHandler.prototype, "menuRegistry", void 0);
__decorate([
    inversify_1.inject(core_1.CommandRegistry),
    __metadata("design:type", core_1.CommandRegistry)
], MenusContributionPointHandler.prototype, "commands", void 0);
__decorate([
    inversify_1.inject(core_1.ILogger),
    __metadata("design:type", Object)
], MenusContributionPointHandler.prototype, "logger", void 0);
__decorate([
    inversify_1.inject(scm_service_1.ScmService),
    __metadata("design:type", scm_service_1.ScmService)
], MenusContributionPointHandler.prototype, "scmService", void 0);
__decorate([
    inversify_1.inject(browser_2.QuickCommandService),
    inversify_1.optional(),
    __metadata("design:type", browser_2.QuickCommandService)
], MenusContributionPointHandler.prototype, "quickCommandService", void 0);
__decorate([
    inversify_1.inject(tab_bar_toolbar_1.TabBarToolbarRegistry),
    __metadata("design:type", tab_bar_toolbar_1.TabBarToolbarRegistry)
], MenusContributionPointHandler.prototype, "tabBarToolbar", void 0);
__decorate([
    inversify_1.inject(core_1.SelectionService),
    __metadata("design:type", core_1.SelectionService)
], MenusContributionPointHandler.prototype, "selectionService", void 0);
__decorate([
    inversify_1.inject(resource_context_key_1.ResourceContextKey),
    __metadata("design:type", resource_context_key_1.ResourceContextKey)
], MenusContributionPointHandler.prototype, "resourceContextKey", void 0);
__decorate([
    inversify_1.inject(view_context_key_service_1.ViewContextKeyService),
    __metadata("design:type", view_context_key_service_1.ViewContextKeyService)
], MenusContributionPointHandler.prototype, "viewContextKeys", void 0);
__decorate([
    inversify_1.inject(context_key_service_1.ContextKeyService),
    __metadata("design:type", Object)
], MenusContributionPointHandler.prototype, "contextKeyService", void 0);
__decorate([
    inversify_1.inject(CodeEditorWidgetUtil),
    __metadata("design:type", CodeEditorWidgetUtil)
], MenusContributionPointHandler.prototype, "codeEditorWidgetUtil", void 0);
MenusContributionPointHandler = MenusContributionPointHandler_1 = __decorate([
    inversify_1.injectable()
], MenusContributionPointHandler);
exports.MenusContributionPointHandler = MenusContributionPointHandler;
/**
 * MenuTree representing a (sub)menu in the menu tree structure.
 */
class MenuTree {
    constructor(menu, 
    /** The location where the menu item will be open from. */
    id, 
    /** The label of the menu item which leads to the submenu. */
    label) {
        this.id = id;
        this.label = label;
        this._children = [];
        if (menu) {
            this.command = menu.command;
            this.alt = menu.alt;
            this.group = menu.group;
            this.when = menu.when;
        }
    }
    get children() {
        return this._children;
    }
    set children(items) {
        this._children.push(...items);
    }
    addChild(node) {
        this._children.push(node);
    }
    get isSubmenu() {
        return this.label !== undefined;
    }
}
exports.MenuTree = MenuTree;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/scm-main.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/scm-main.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2019-2021 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ScmMainImpl = exports.PluginScmProvider = exports.PluginScmResource = exports.PluginScmResourceGroup = void 0;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// code copied and modified from https://github.com/microsoft/vscode/blob/1.52.1/src/vs/workbench/api/browser/mainThreadSCM.ts
const plugin_api_rpc_1 = __webpack_require__(/*! ../../common/plugin-api-rpc */ "./node_modules/@theia/plugin-ext/lib/common/plugin-api-rpc.js");
const scm_service_1 = __webpack_require__(/*! @theia/scm/lib/browser/scm-service */ "./node_modules/@theia/scm/lib/browser/scm-service.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "./node_modules/@theia/core/lib/common/event.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "./node_modules/@theia/core/lib/common/disposable.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const vscode_uri_1 = __webpack_require__(/*! @theia/core/shared/vscode-uri */ "./node_modules/@theia/core/shared/vscode-uri/index.js");
const color_registry_1 = __webpack_require__(/*! @theia/core/lib/browser/color-registry */ "./node_modules/@theia/core/lib/browser/color-registry.js");
class PluginScmResourceGroup {
    constructor(handle, provider, features, label, id) {
        this.handle = handle;
        this.provider = provider;
        this.features = features;
        this.label = label;
        this.id = id;
        this.resources = [];
        this.onDidSpliceEmitter = new event_1.Emitter();
        this.onDidSplice = this.onDidSpliceEmitter.event;
        this.onDidChangeEmitter = new event_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
    }
    get hideWhenEmpty() { return !!this.features.hideWhenEmpty; }
    splice(start, deleteCount, toInsert) {
        this.resources.splice(start, deleteCount, ...toInsert);
        this.onDidSpliceEmitter.fire({ start, deleteCount, toInsert });
    }
    updateGroup(features) {
        this.features = Object.assign(Object.assign({}, this.features), features);
        this.onDidChangeEmitter.fire();
    }
    updateGroupLabel(label) {
        this.label = label;
        this.onDidChangeEmitter.fire();
    }
    dispose() { }
}
exports.PluginScmResourceGroup = PluginScmResourceGroup;
class PluginScmResource {
    constructor(proxy, sourceControlHandle, groupHandle, handle, sourceUri, group, decorations, contextValue, command) {
        this.proxy = proxy;
        this.sourceControlHandle = sourceControlHandle;
        this.groupHandle = groupHandle;
        this.handle = handle;
        this.sourceUri = sourceUri;
        this.group = group;
        this.decorations = decorations;
        this.contextValue = contextValue;
        this.command = command;
    }
    open() {
        return this.proxy.$executeResourceCommand(this.sourceControlHandle, this.groupHandle, this.handle);
    }
}
exports.PluginScmResource = PluginScmResource;
class PluginScmProvider {
    constructor(proxy, colors, _handle, _contextValue, _label, _rootUri) {
        this.proxy = proxy;
        this.colors = colors;
        this._handle = _handle;
        this._contextValue = _contextValue;
        this._label = _label;
        this._rootUri = _rootUri;
        this._id = this.contextValue;
        this.groups = [];
        this.groupsByHandle = Object.create(null);
        this.onDidChangeResourcesEmitter = new event_1.Emitter();
        this.onDidChangeResources = this.onDidChangeResourcesEmitter.event;
        this.features = {};
        this.onDidChangeCommitTemplateEmitter = new event_1.Emitter();
        this.onDidChangeCommitTemplate = this.onDidChangeCommitTemplateEmitter.event;
        this.onDidChangeStatusBarCommandsEmitter = new event_1.Emitter();
        this.onDidChangeEmitter = new event_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
    }
    get id() { return this._id; }
    get handle() { return this._handle; }
    get label() { return this._label; }
    get rootUri() { return this._rootUri ? this._rootUri.toString() : ''; }
    get contextValue() { return this._contextValue; }
    get commitTemplate() { return this.features.commitTemplate || ''; }
    get acceptInputCommand() {
        const command = this.features.acceptInputCommand;
        if (command) {
            const scmCommand = command;
            scmCommand.command = command.id;
            return scmCommand;
        }
    }
    get statusBarCommands() {
        const commands = this.features.statusBarCommands;
        return commands === null || commands === void 0 ? void 0 : commands.map(command => {
            const scmCommand = command;
            scmCommand.command = command.id;
            return scmCommand;
        });
    }
    get count() { return this.features.count; }
    get onDidChangeStatusBarCommands() { return this.onDidChangeStatusBarCommandsEmitter.event; }
    updateSourceControl(features) {
        this.features = Object.assign(Object.assign({}, this.features), features);
        this.onDidChangeEmitter.fire();
        if (typeof features.commitTemplate !== 'undefined') {
            this.onDidChangeCommitTemplateEmitter.fire(this.commitTemplate);
        }
        if (typeof features.statusBarCommands !== 'undefined') {
            this.onDidChangeStatusBarCommandsEmitter.fire(this.statusBarCommands);
        }
    }
    registerGroups(resourceGroups) {
        const groups = resourceGroups.map(resourceGroup => {
            const { handle, id, label, features } = resourceGroup;
            const group = new PluginScmResourceGroup(handle, this, features, label, id);
            this.groupsByHandle[handle] = group;
            return group;
        });
        this.groups.splice(this.groups.length, 0, ...groups);
    }
    updateGroup(handle, features) {
        const group = this.groupsByHandle[handle];
        if (!group) {
            return;
        }
        group.updateGroup(features);
    }
    updateGroupLabel(handle, label) {
        const group = this.groupsByHandle[handle];
        if (!group) {
            return;
        }
        group.updateGroupLabel(label);
    }
    spliceGroupResourceStates(splices) {
        for (const splice of splices) {
            const groupHandle = splice.handle;
            const groupSlices = splice.splices;
            const group = this.groupsByHandle[groupHandle];
            if (!group) {
                console.warn(`SCM group ${groupHandle} not found in provider ${this.label}`);
                continue;
            }
            // reverse the splices sequence in order to apply them correctly
            groupSlices.reverse();
            for (const groupSlice of groupSlices) {
                const { start, deleteCount, rawResources } = groupSlice;
                const resources = rawResources.map(rawResource => {
                    const { handle, sourceUri, icons, tooltip, strikeThrough, faded, contextValue, command } = rawResource;
                    const icon = icons[0];
                    const iconDark = icons[1] || icon;
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                    const colorVariable = rawResource.colorId && this.colors.toCssVariableName(rawResource.colorId);
                    const decorations = {
                        icon: icon ? vscode_uri_1.URI.revive(icon) : undefined,
                        iconDark: iconDark ? vscode_uri_1.URI.revive(iconDark) : undefined,
                        tooltip,
                        strikeThrough,
                        // TODO remove the letter and colorId fields when the FileDecorationProvider is applied, see https://github.com/eclipse-theia/theia/pull/8911
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        letter: rawResource.letter || '',
                        color: colorVariable && `var(${colorVariable})`,
                        faded
                    };
                    return new PluginScmResource(this.proxy, this.handle, groupHandle, handle, new uri_1.default(vscode_uri_1.URI.revive(sourceUri)), group, decorations, contextValue || undefined, command);
                });
                group.splice(start, deleteCount, resources);
            }
        }
        this.onDidChangeResourcesEmitter.fire();
    }
    unregisterGroup(handle) {
        const group = this.groupsByHandle[handle];
        if (!group) {
            return;
        }
        delete this.groupsByHandle[handle];
        this.groups.splice(this.groups.indexOf(group), 1);
    }
    dispose() { }
}
exports.PluginScmProvider = PluginScmProvider;
class ScmMainImpl {
    constructor(rpc, container) {
        this.repositories = new Map();
        this.repositoryDisposables = new Map();
        this.disposables = new disposable_1.DisposableCollection();
        this.proxy = rpc.getProxy(plugin_api_rpc_1.MAIN_RPC_CONTEXT.SCM_EXT);
        this.scmService = container.get(scm_service_1.ScmService);
        this.colors = container.get(color_registry_1.ColorRegistry);
    }
    dispose() {
        this.repositories.forEach(r => r.dispose());
        this.repositories.clear();
        this.repositoryDisposables.forEach(d => d.dispose());
        this.repositoryDisposables.clear();
        this.disposables.dispose();
    }
    async $registerSourceControl(handle, id, label, rootUri) {
        const provider = new PluginScmProvider(this.proxy, this.colors, handle, id, label, rootUri ? vscode_uri_1.URI.revive(rootUri) : undefined);
        const repository = this.scmService.registerScmProvider(provider, {
            input: {
                validator: async (value) => {
                    const result = await this.proxy.$validateInput(handle, value, value.length);
                    return result && { message: result[0], type: result[1] };
                }
            }
        });
        this.repositories.set(handle, repository);
        const disposables = new disposable_1.DisposableCollection(this.scmService.onDidChangeSelectedRepository(r => {
            if (r === repository) {
                this.proxy.$setSelectedSourceControl(handle);
            }
        }), repository.input.onDidChange(() => this.proxy.$onInputBoxValueChange(handle, repository.input.value)));
        if (this.scmService.selectedRepository === repository) {
            setTimeout(() => this.proxy.$setSelectedSourceControl(handle), 0);
        }
        if (repository.input.value) {
            setTimeout(() => this.proxy.$onInputBoxValueChange(handle, repository.input.value), 0);
        }
        this.repositoryDisposables.set(handle, disposables);
    }
    async $updateSourceControl(handle, features) {
        const repository = this.repositories.get(handle);
        if (!repository) {
            return;
        }
        const provider = repository.provider;
        provider.updateSourceControl(features);
    }
    async $unregisterSourceControl(handle) {
        const repository = this.repositories.get(handle);
        if (!repository) {
            return;
        }
        this.repositoryDisposables.get(handle).dispose();
        this.repositoryDisposables.delete(handle);
        repository.dispose();
        this.repositories.delete(handle);
    }
    $registerGroups(sourceControlHandle, groups, splices) {
        const repository = this.repositories.get(sourceControlHandle);
        if (!repository) {
            return;
        }
        const provider = repository.provider;
        provider.registerGroups(groups);
        provider.spliceGroupResourceStates(splices);
    }
    $updateGroup(sourceControlHandle, groupHandle, features) {
        const repository = this.repositories.get(sourceControlHandle);
        if (!repository) {
            return;
        }
        const provider = repository.provider;
        provider.updateGroup(groupHandle, features);
    }
    $updateGroupLabel(sourceControlHandle, groupHandle, label) {
        const repository = this.repositories.get(sourceControlHandle);
        if (!repository) {
            return;
        }
        const provider = repository.provider;
        provider.updateGroupLabel(groupHandle, label);
    }
    $spliceResourceStates(sourceControlHandle, splices) {
        const repository = this.repositories.get(sourceControlHandle);
        if (!repository) {
            return;
        }
        const provider = repository.provider;
        provider.spliceGroupResourceStates(splices);
    }
    $unregisterGroup(sourceControlHandle, handle) {
        const repository = this.repositories.get(sourceControlHandle);
        if (!repository) {
            return;
        }
        const provider = repository.provider;
        provider.unregisterGroup(handle);
    }
    $setInputBoxValue(sourceControlHandle, value) {
        const repository = this.repositories.get(sourceControlHandle);
        if (!repository) {
            return;
        }
        repository.input.value = value;
    }
    $setInputBoxPlaceholder(sourceControlHandle, placeholder) {
        const repository = this.repositories.get(sourceControlHandle);
        if (!repository) {
            return;
        }
        repository.input.placeholder = placeholder;
    }
}
exports.ScmMainImpl = ScmMainImpl;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/view/plugin-view-widget.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/view/plugin-view-widget.js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PluginViewWidget = exports.PluginViewWidgetIdentifier = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const widgets_1 = __webpack_require__(/*! @theia/core/shared/@phosphor/widgets */ "./node_modules/@theia/core/shared/@phosphor/widgets/index.js");
const menu_1 = __webpack_require__(/*! @theia/core/lib/common/menu */ "./node_modules/@theia/core/lib/common/menu.js");
const command_1 = __webpack_require__(/*! @theia/core/lib/common/command */ "./node_modules/@theia/core/lib/common/command.js");
const tree_view_widget_1 = __webpack_require__(/*! ./tree-view-widget */ "./node_modules/@theia/plugin-ext/lib/main/browser/view/tree-view-widget.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "./node_modules/@theia/core/lib/common/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "./node_modules/@theia/core/lib/browser/context-key-service.js");
let PluginViewWidgetIdentifier = class PluginViewWidgetIdentifier {
};
PluginViewWidgetIdentifier = __decorate([
    inversify_1.injectable()
], PluginViewWidgetIdentifier);
exports.PluginViewWidgetIdentifier = PluginViewWidgetIdentifier;
let PluginViewWidget = class PluginViewWidget extends widgets_1.Panel {
    constructor() {
        super();
        this.toDispose = new common_1.DisposableCollection();
        this.onDidChangeDescription = new common_1.Emitter();
        this._suppressUpdateViewVisibility = false;
        this.updatingViewVisibility = false;
        this._description = '';
        this.node.tabIndex = -1;
        this.node.style.height = '100%';
    }
    init() {
        this.id = this.options.id;
        const localContext = this.contextKeyService.createScoped(this.node);
        localContext.setContext('view', this.options.viewId);
        this.toDispose.push(localContext);
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        const widget = this.widgets[0];
        if (widget) {
            widget.activate();
            this.updateWidgetMessage();
        }
        else {
            this.node.focus();
        }
    }
    storeState() {
        return {
            label: this.title.label,
            message: this.message,
            widgets: this.widgets,
            suppressUpdateViewVisibility: this._suppressUpdateViewVisibility,
            currentViewContainerId: this.currentViewContainerId
        };
    }
    restoreState(state) {
        this.title.label = state.label;
        this.message = state.message;
        this.suppressUpdateViewVisibility = state.suppressUpdateViewVisibility;
        this.currentViewContainerId = state.currentViewContainerId;
        for (const widget of state.widgets) {
            this.addWidget(widget);
        }
    }
    set suppressUpdateViewVisibility(suppressUpdateViewVisibility) {
        this._suppressUpdateViewVisibility = !this.updatingViewVisibility && suppressUpdateViewVisibility;
    }
    updateViewVisibility(cb) {
        if (this._suppressUpdateViewVisibility) {
            return;
        }
        try {
            this.updatingViewVisibility = true;
            cb();
        }
        finally {
            this.updatingViewVisibility = false;
        }
    }
    get message() {
        return this._message;
    }
    set message(message) {
        this._message = message;
        this.updateWidgetMessage();
    }
    get description() {
        return this._description;
    }
    set description(description) {
        this._description = description;
        this.onDidChangeDescription.fire();
    }
    updateWidgetMessage() {
        const widget = this.widgets[0];
        if (widget) {
            if (widget instanceof tree_view_widget_1.TreeViewWidget) {
                widget.message = this._message;
            }
        }
    }
    addWidget(widget) {
        super.addWidget(widget);
        this.updateWidgetMessage();
    }
    insertWidget(index, widget) {
        super.insertWidget(index, widget);
        this.updateWidgetMessage();
    }
    dispose() {
        this.toDispose.dispose();
        super.dispose();
    }
};
__decorate([
    inversify_1.inject(menu_1.MenuModelRegistry),
    __metadata("design:type", menu_1.MenuModelRegistry)
], PluginViewWidget.prototype, "menus", void 0);
__decorate([
    inversify_1.inject(command_1.CommandRegistry),
    __metadata("design:type", command_1.CommandRegistry)
], PluginViewWidget.prototype, "commands", void 0);
__decorate([
    inversify_1.inject(context_key_service_1.ContextKeyService),
    __metadata("design:type", Object)
], PluginViewWidget.prototype, "contextKeyService", void 0);
__decorate([
    inversify_1.inject(PluginViewWidgetIdentifier),
    __metadata("design:type", PluginViewWidgetIdentifier)
], PluginViewWidget.prototype, "options", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PluginViewWidget.prototype, "init", null);
PluginViewWidget = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], PluginViewWidget);
exports.PluginViewWidget = PluginViewWidget;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/view/tree-view-widget.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/view/tree-view-widget.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2018-2019 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TreeViewWidget = exports.PluginTreeModel = exports.PluginTree = exports.TreeViewWidgetIdentifier = exports.CompositeTreeViewNode = exports.TreeViewNode = exports.VIEW_ITEM_INLINE_MENU = exports.VIEW_ITEM_CONTEXT_MENU = exports.TREE_NODE_HYPERLINK = void 0;
const vscode_uri_1 = __webpack_require__(/*! @theia/core/shared/vscode-uri */ "./node_modules/@theia/core/shared/vscode-uri/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const plugin_api_rpc_1 = __webpack_require__(/*! ../../../common/plugin-api-rpc */ "./node_modules/@theia/plugin-ext/lib/common/plugin-api-rpc.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "./node_modules/@theia/core/lib/browser/index.js");
const menu_1 = __webpack_require__(/*! @theia/core/lib/common/menu */ "./node_modules/@theia/core/lib/common/menu.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "./node_modules/@theia/core/shared/react/index.js");
const plugin_shared_style_1 = __webpack_require__(/*! ../plugin-shared-style */ "./node_modules/@theia/plugin-ext/lib/main/browser/plugin-shared-style.js");
const widget_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/widget */ "./node_modules/@theia/core/lib/browser/widgets/widget.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "./node_modules/@theia/core/lib/common/event.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "./node_modules/@theia/core/lib/common/message-service.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "./node_modules/@theia/core/lib/common/uri.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "./node_modules/@theia/core/lib/browser/context-key-service.js");
const markdownit = __webpack_require__(/*! @theia/core/shared/markdown-it */ "./node_modules/@theia/core/shared/markdown-it.js");
const markdown_string_1 = __webpack_require__(/*! ../../../plugin/markdown-string */ "./node_modules/@theia/plugin-ext/lib/plugin/markdown-string.js");
exports.TREE_NODE_HYPERLINK = 'theia-TreeNodeHyperlink';
exports.VIEW_ITEM_CONTEXT_MENU = ['view-item-context-menu'];
exports.VIEW_ITEM_INLINE_MENU = ['view-item-inline-menu'];
var TreeViewNode;
(function (TreeViewNode) {
    function is(arg) {
        return !!arg && browser_1.SelectableTreeNode.is(arg) && !browser_1.ExpandableTreeNode.is(arg) && !browser_1.CompositeTreeNode.is(arg);
    }
    TreeViewNode.is = is;
})(TreeViewNode = exports.TreeViewNode || (exports.TreeViewNode = {}));
var CompositeTreeViewNode;
(function (CompositeTreeViewNode) {
    function is(arg) {
        return !!arg && browser_1.SelectableTreeNode.is(arg) && browser_1.ExpandableTreeNode.is(arg) && browser_1.CompositeTreeNode.is(arg);
    }
    CompositeTreeViewNode.is = is;
})(CompositeTreeViewNode = exports.CompositeTreeViewNode || (exports.CompositeTreeViewNode = {}));
let TreeViewWidgetIdentifier = class TreeViewWidgetIdentifier {
};
TreeViewWidgetIdentifier = __decorate([
    inversify_1.injectable()
], TreeViewWidgetIdentifier);
exports.TreeViewWidgetIdentifier = TreeViewWidgetIdentifier;
let PluginTree = class PluginTree extends browser_1.TreeImpl {
    constructor() {
        super(...arguments);
        this.onDidChangeWelcomeStateEmitter = new event_1.Emitter();
        this.onDidChangeWelcomeState = this.onDidChangeWelcomeStateEmitter.event;
    }
    set proxy(proxy) {
        this._proxy = proxy;
    }
    get proxy() {
        return this._proxy;
    }
    set viewInfo(viewInfo) {
        this._viewInfo = viewInfo;
    }
    get isEmpty() {
        return this._isEmpty;
    }
    async resolveChildren(parent) {
        if (!this._proxy) {
            return super.resolveChildren(parent);
        }
        const children = await this.fetchChildren(this._proxy, parent);
        return children.map(value => this.createTreeNode(value, parent));
    }
    async fetchChildren(proxy, parent) {
        try {
            const children = await proxy.$getChildren(this.identifier.id, parent.id);
            const oldEmpty = this._isEmpty;
            this._isEmpty = !parent.id && (!children || children.length === 0);
            if (oldEmpty !== this._isEmpty) {
                this.onDidChangeWelcomeStateEmitter.fire();
            }
            return children || [];
        }
        catch (e) {
            if (e) {
                console.error(`Failed to fetch children for '${this.identifier.id}'`, e);
                const label = this._viewInfo ? this._viewInfo.name : this.identifier.id;
                this.notification.error(`${label}: ${e.message}`);
            }
            return [];
        }
    }
    createTreeNode(item, parent) {
        const icon = this.toIconClass(item);
        const resourceUri = item.resourceUri && vscode_uri_1.URI.revive(item.resourceUri).toString();
        const themeIconId = item.themeIconId ? item.themeIconId : item.collapsibleState !== plugin_api_rpc_1.TreeViewItemCollapsibleState.None ? 'folder' : 'file';
        const update = {
            name: item.label,
            icon,
            description: item.description,
            themeIconId,
            resourceUri,
            tooltip: item.tooltip,
            contextValue: item.contextValue,
            command: item.command,
        };
        const node = this.getNode(item.id);
        if (item.collapsibleState !== undefined && item.collapsibleState !== plugin_api_rpc_1.TreeViewItemCollapsibleState.None) {
            if (CompositeTreeViewNode.is(node)) {
                return Object.assign(node, update);
            }
            return Object.assign({
                id: item.id,
                parent,
                visible: true,
                selected: false,
                expanded: plugin_api_rpc_1.TreeViewItemCollapsibleState.Expanded === item.collapsibleState,
                children: [],
                command: item.command
            }, update);
        }
        if (TreeViewNode.is(node)) {
            return Object.assign(node, update, { command: item.command });
        }
        return Object.assign({
            id: item.id,
            parent,
            visible: true,
            selected: false,
            command: item.command,
        }, update);
    }
    toIconClass(item) {
        if (item.icon) {
            return 'fa ' + item.icon;
        }
        if (item.iconUrl) {
            const reference = this.sharedStyle.toIconClass(item.iconUrl);
            this.toDispose.push(reference);
            return reference.object.iconClass;
        }
        return undefined;
    }
};
__decorate([
    inversify_1.inject(plugin_shared_style_1.PluginSharedStyle),
    __metadata("design:type", plugin_shared_style_1.PluginSharedStyle)
], PluginTree.prototype, "sharedStyle", void 0);
__decorate([
    inversify_1.inject(TreeViewWidgetIdentifier),
    __metadata("design:type", TreeViewWidgetIdentifier)
], PluginTree.prototype, "identifier", void 0);
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], PluginTree.prototype, "notification", void 0);
PluginTree = __decorate([
    inversify_1.injectable()
], PluginTree);
exports.PluginTree = PluginTree;
let PluginTreeModel = class PluginTreeModel extends browser_1.TreeModelImpl {
    set proxy(proxy) {
        this.tree.proxy = proxy;
    }
    get proxy() {
        return this.tree.proxy;
    }
    set viewInfo(viewInfo) {
        this.tree.viewInfo = viewInfo;
    }
    get isTreeEmpty() {
        return this.tree.isEmpty;
    }
    get onDidChangeWelcomeState() {
        return this.tree.onDidChangeWelcomeState;
    }
};
__decorate([
    inversify_1.inject(PluginTree),
    __metadata("design:type", PluginTree)
], PluginTreeModel.prototype, "tree", void 0);
PluginTreeModel = __decorate([
    inversify_1.injectable()
], PluginTreeModel);
exports.PluginTreeModel = PluginTreeModel;
let TreeViewWidget = class TreeViewWidget extends browser_1.TreeViewWelcomeWidget {
    constructor() {
        super(...arguments);
        this._contextSelection = false;
        this.onDidChangeVisibilityEmitter = new event_1.Emitter();
        this.onDidChangeVisibility = this.onDidChangeVisibilityEmitter.event;
    }
    init() {
        super.init();
        this.id = this.identifier.id;
        this.addClass('theia-tree-view');
        this.node.style.height = '100%';
        this.model.onDidChangeWelcomeState(this.update, this);
        this.toDispose.push(this.model.onDidChangeWelcomeState(this.update, this));
        this.toDispose.push(this.onDidChangeVisibilityEmitter);
    }
    renderIcon(node, props) {
        const icon = this.toNodeIcon(node);
        if (icon) {
            return React.createElement("div", { className: icon + ' theia-tree-view-icon' });
        }
        return undefined;
    }
    renderCaption(node, props) {
        const classes = [browser_1.TREE_NODE_SEGMENT_CLASS];
        if (!this.hasTrailingSuffixes(node)) {
            classes.push(browser_1.TREE_NODE_SEGMENT_GROW_CLASS);
        }
        const className = classes.join(' ');
        let attrs = Object.assign(Object.assign({}, this.decorateCaption(node, {})), { className, id: node.id });
        if (node.tooltip && markdown_string_1.isMarkdownString(node.tooltip)) {
            // Render markdown in custom tooltip
            const tooltip = markdownit().render(node.tooltip.value);
            attrs = Object.assign(Object.assign({}, attrs), { 'data-tip': tooltip, 'data-for': this.tooltipService.tooltipId });
        }
        else {
            const title = node.tooltip ||
                (node.resourceUri && this.labelProvider.getLongName(new uri_1.default(node.resourceUri)))
                || this.toNodeName(node);
            attrs = Object.assign(Object.assign({}, attrs), { title });
        }
        const children = [];
        const caption = this.toNodeName(node);
        const highlight = this.getDecorationData(node, 'highlight')[0];
        if (highlight) {
            children.push(this.toReactNode(caption, highlight));
        }
        const searchHighlight = this.searchHighlights && this.searchHighlights.get(node.id);
        if (searchHighlight) {
            children.push(...this.toReactNode(caption, searchHighlight));
        }
        else if (!highlight) {
            children.push(caption);
        }
        const description = this.toNodeDescription(node);
        if (description) {
            children.push(React.createElement("span", { className: 'theia-tree-view-description' }, description));
        }
        return React.createElement('div', attrs, ...children);
    }
    renderTailDecorations(node, props) {
        return this.contextKeys.with({ view: this.id, viewItem: node.contextValue }, () => {
            const menu = this.menus.getMenu(exports.VIEW_ITEM_INLINE_MENU);
            const arg = this.toTreeViewSelection(node);
            return React.createElement(React.Fragment, null, menu.children.map((item, index) => item instanceof menu_1.ActionMenuNode && this.renderInlineCommand(item, index, arg)));
        });
    }
    toTreeViewSelection(node) {
        return { treeViewId: this.id, treeItemId: node.id };
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    renderInlineCommand(node, index, arg) {
        const { icon } = node;
        if (!icon || !this.commands.isVisible(node.action.commandId, arg) || !node.action.when || !this.contextKeys.match(node.action.when)) {
            return false;
        }
        const className = [browser_1.TREE_NODE_SEGMENT_CLASS, browser_1.TREE_NODE_TAIL_CLASS, icon, widget_1.ACTION_ITEM, 'theia-tree-view-inline-action'].join(' ');
        return React.createElement("div", { key: index, className: className, title: node.label, onClick: e => {
                e.stopPropagation();
                this.commands.executeCommand(node.action.commandId, arg);
            } });
    }
    toContextMenuArgs(node) {
        return [this.toTreeViewSelection(node)];
    }
    setFlag(flag) {
        super.setFlag(flag);
        if (flag === widget_1.Widget.Flag.IsVisible) {
            this.onDidChangeVisibilityEmitter.fire(this.isVisible);
        }
    }
    clearFlag(flag) {
        super.clearFlag(flag);
        if (flag === widget_1.Widget.Flag.IsVisible) {
            this.onDidChangeVisibilityEmitter.fire(this.isVisible);
        }
    }
    handleEnter(event) {
        super.handleEnter(event);
        this.tryExecuteCommand();
    }
    handleClickEvent(node, event) {
        super.handleClickEvent(node, event);
        // If clicked on item (not collapsable icon) - execute command or toggle expansion if item has no command
        const commandMap = this.findCommands(node);
        if (commandMap.size > 0) {
            this.tryExecuteCommandMap(commandMap);
        }
        else if (this.isExpandable(node) && !this.hasShiftMask(event) && !this.hasCtrlCmdMask(event)) {
            this.model.toggleNodeExpansion(node);
        }
    }
    // execute TreeItem.command if present
    tryExecuteCommand(node) {
        this.tryExecuteCommandMap(this.findCommands(node));
    }
    tryExecuteCommandMap(commandMap) {
        commandMap.forEach((args, commandId) => {
            this.commands.executeCommand(commandId, ...args);
        });
    }
    findCommands(node) {
        const commandMap = new Map();
        const treeNodes = (node ? [node] : this.model.selectedNodes);
        for (const treeNode of treeNodes) {
            if (treeNode && treeNode.command) {
                commandMap.set(treeNode.command.id, treeNode.command.arguments || []);
            }
        }
        return commandMap;
    }
    get message() {
        return this._message;
    }
    set message(message) {
        this._message = message;
        this.update();
    }
    render() {
        const node = React.createElement('div', this.createContainerAttributes(), this.renderSearchInfo(), this.renderTree(this.model));
        this.tooltipService.update();
        return node;
    }
    renderSearchInfo() {
        if (this._message) {
            return React.createElement("div", { className: 'theia-TreeViewInfo' }, this._message);
        }
        return undefined;
    }
    shouldShowWelcomeView() {
        return (this.model.proxy === undefined || this.model.isTreeEmpty) && this.message === undefined;
    }
};
__decorate([
    inversify_1.inject(menu_1.MenuModelRegistry),
    __metadata("design:type", menu_1.MenuModelRegistry)
], TreeViewWidget.prototype, "menus", void 0);
__decorate([
    inversify_1.inject(context_key_service_1.ContextKeyService),
    __metadata("design:type", Object)
], TreeViewWidget.prototype, "contextKeys", void 0);
__decorate([
    inversify_1.inject(TreeViewWidgetIdentifier),
    __metadata("design:type", TreeViewWidgetIdentifier)
], TreeViewWidget.prototype, "identifier", void 0);
__decorate([
    inversify_1.inject(PluginTreeModel),
    __metadata("design:type", PluginTreeModel)
], TreeViewWidget.prototype, "model", void 0);
__decorate([
    inversify_1.inject(context_key_service_1.ContextKeyService),
    __metadata("design:type", Object)
], TreeViewWidget.prototype, "contextKeyService", void 0);
__decorate([
    inversify_1.inject(browser_1.TooltipService),
    __metadata("design:type", Object)
], TreeViewWidget.prototype, "tooltipService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TreeViewWidget.prototype, "init", null);
TreeViewWidget = __decorate([
    inversify_1.injectable()
], TreeViewWidget);
exports.TreeViewWidget = TreeViewWidget;


/***/ }),

/***/ "./node_modules/@theia/plugin-ext/lib/main/browser/view/view-context-key-service.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@theia/plugin-ext/lib/main/browser/view/view-context-key-service.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ViewContextKeyService = void 0;
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "./node_modules/@theia/core/shared/inversify/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "./node_modules/@theia/core/lib/browser/context-key-service.js");
let ViewContextKeyService = class ViewContextKeyService {
    get view() {
        return this._view;
    }
    get viewItem() {
        return this._viewItem;
    }
    /**
     * Viewlet is a tab in the left area in VS Code. Active means visible in this context.
     *
     * In VS Code there can be only one visible viewlet at any time.
     * It is not true for Theia, since views can be layed-out again to different areas.
     * So only last visible view will be an active viewlet.
     */
    get activeViewlet() {
        return this._activeViewlet;
    }
    /**
     * Panel is a tab in the bottom area in VS Code. Active means visible in this context.
     *
     * In VS Code there can be only one visible panel at any time.
     * It is not true for Theia, since views can be layed-out again to different areas.
     * So only last visible view will be an active panel.
     */
    get activePanel() {
        return this._activePanel;
    }
    get focusedView() {
        return this._focusedView;
    }
    init() {
        this._view = this.contextKeyService.createKey('view', '');
        this._viewItem = this.contextKeyService.createKey('viewItem', '');
        this._activeViewlet = this.contextKeyService.createKey('activeViewlet', '');
        this._activePanel = this.contextKeyService.createKey('activePanel', '');
        this._focusedView = this.contextKeyService.createKey('focusedView', '');
    }
    match(expression) {
        return !expression || this.contextKeyService.match(expression);
    }
};
__decorate([
    inversify_1.inject(context_key_service_1.ContextKeyService),
    __metadata("design:type", Object)
], ViewContextKeyService.prototype, "contextKeyService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ViewContextKeyService.prototype, "init", null);
ViewContextKeyService = __decorate([
    inversify_1.injectable()
], ViewContextKeyService);
exports.ViewContextKeyService = ViewContextKeyService;


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_callhierarchy_lib_browser_index_js-node_modules_theia_plugin-ext_l-25966f.bundle.js.map