import { ArduinoLoader as ArduinoLoaderIcon } from '@cloud-editor-mono/images/assets/icons';
import clsx from 'clsx';

import styles from './arduino-loader.module.scss';

export function ArduinoLoader({
  secondary,
}: {
  secondary?: boolean;
}): JSX.Element {
  return (
    <div
      className={clsx(styles['arduino-loader'], {
        [styles.secondary]: secondary,
      })}
    >
      <ArduinoLoaderIcon />
    </div>
  );

  return (
    <div className={styles['arduino-loader-container']}>
      <svg
        id="logo-arduino"
        className={clsx(styles['arduino-loader'], {
          [styles.secondary]: secondary,
        })}
        xmlns="http://www.w3.org/2000/svg"
        viewBox="0 0 821.27 566.24"
      >
        <g id="traccia-loop">
          <path
            className={styles['loop']}
            d="M960,449.62l-28,50.66c-29.35,43.15-79.66,96.78-152.66,107.26a188.26,188.26,0,0,1-26.14,1.78c-92,0-166.78-71.64-166.78-159.7s74.86-159.7,166.87-159.7a180.62,180.62,0,0,1,26,1.83c65.21,9.3,112.32,53,142.56,93a213.75,213.75,0,0,1,16.52,25.65l45.53,82.31A158.69,158.69,0,0,0,994,508.77c29.92,41.4,78.28,89,146.55,98.76a189.83,189.83,0,0,0,26.26,1.79c92,0,166.77-71.64,166.77-159.7s-74.85-159.7-166.86-159.7a183.49,183.49,0,0,0-26.1,1.84c-73,10.42-123.26,64-152.54,107.09L960,449.62"
            pathLength="1"
            transform="translate(-550.35 -252.49)"
            strokeLinecap="round"
          />
        </g>
        <g id="minus" data-name="-">
          <rect
            className={styles['minus']}
            x="143.14"
            y="178.03"
            width="121.88"
            height="39.29"
          />
        </g>
        <g id="plus" data-name="+">
          <polygon
            className={styles['plus']}
            points="630.62 217.32 671.82 217.32 671.82 178.03 630.62 178.03 630.62 136.7 591.24 136.7 591.24 178.03 549.97 178.03 549.97 217.32 591.24 217.32 591.24 258.65 630.62 258.65 630.62 217.32"
          />
        </g>
      </svg>
    </div>
  );
}
