import { defineMessages } from 'react-intl';

export const messages = defineMessages({
  titleCheckingForUpdates: {
    id: 'app-lab.board-update-dialog.checking-for-updates-title',
    defaultMessage: 'Checking for updates',
    description:
      'Title shown on the board update dialog when checking for updates',
  },
  titleUpdates: {
    id: 'app-lab.board-update-dialog.updates',
    defaultMessage: 'Updates',
    description: 'Title shown on the board update dialog for updates',
  },
  installUpdate: {
    id: 'app-lab.board-update-dialog.install-update',
    defaultMessage: 'Install Updates',
    description: 'Button text to install the available update',
  },
  retry: {
    id: 'app-lab.board-update-dialog.retry',
    defaultMessage: 'Retry',
    description: 'Button text to retry checking for updates',
  },
  restart: {
    id: 'app-lab.board-update-dialog.restart',
    defaultMessage: 'Restart App Lab',
    description: 'Button text to restart the app lab after update',
  },
  checkingForUpdates: {
    id: 'app-lab.board-update-dialog.checking-for-updates',
    defaultMessage: 'We are checking for updates',
    description: 'Status text shown when the updater is checking for updates',
  },
  onlyMoment: {
    id: 'app-lab.board-update-dialog.checking-for-updates',
    defaultMessage: 'This will only take a moment, thank you for your patience',
    description: 'Additional info text shown when checking for updates',
  },
  updateFailed: {
    id: 'app-lab.board-update-dialog.update-failed',
    defaultMessage: 'Update failed',
    description: 'Status text shown when the update has failed',
  },
  errorEncountered: {
    id: 'app-lab.board-update-dialog.error-encountered',
    defaultMessage:
      'Updates were applied successfully, but we encountered some errors',
    description:
      'Text shown when errors were encountered during the update process',
  },
});
