import { defineMessages } from 'react-intl';

export const appFilesMessages = defineMessages({
  bricksLabel: {
    id: 'app-files-section.bricks-label',
    defaultMessage: 'Bricks',
    description: 'Label for the Bricks section in the App Files Section',
  },
  sketchLibrariesLabel: {
    id: 'app-files-section.sketch-libraries-label',
    defaultMessage: 'Sketch Libraries',
    description:
      'Label for the Sketch Libraries section in the App Files Section',
  },
  filesLabel: {
    id: 'app-files-section.files-label',
    defaultMessage: 'Files',
    description: 'Label for the Files section in the App Files Section',
  },
  addBrickButton: {
    id: 'app-files-section.add-brick-button',
    defaultMessage: 'Add Brick',
    description: 'Button text to add a new brick to the app',
  },
  addSketchLibraryButton: {
    id: 'app-files-section.add-sketch-library-button',
    defaultMessage: 'Add Sketch Library',
    description: 'Button text to add a new sketch library to the app',
  },
  addFileButton: {
    id: 'app-files-section.add-file-button',
    defaultMessage: 'Add File',
    description: 'Button text to add a new file to the app',
  },
  noBricksAddedYet: {
    id: 'app-files-section.no-bricks-added-yet',
    defaultMessage: 'No bricks added yet',
    description: 'Message shown when there are no bricks added to the app',
  },
  noSketchLibrariesAddedYet: {
    id: 'app-files-section.no-sketch-libraries-added-yet',
    defaultMessage: 'No sketch libraries added yet',
    description:
      'Message shown when there are no sketch libraries added to the app',
  },
});
