import { defineMessages } from 'react-intl';

export const messages = defineMessages({
  appearenceLabel: {
    id: 'settings.appearance',
    defaultMessage: 'Appearance',
    description: 'Label for the appearance settings item',
  },
  sketchLabel: {
    id: 'settings.sketch',
    defaultMessage: 'Sketch',
    description: 'Label for the sketch settings item',
  },
  deviceLabel: {
    id: 'settings.device',
    defaultMessage: 'Device',
    description: 'Label for the device settings item',
  },
  verifyAndUploadLabel: {
    id: 'settings.verifyAndUpload',
    defaultMessage: 'Verify & upload',
    description: 'Label for the verify and upload settings item',
  },
  restoreSettings: {
    id: 'settings.restoreSettings',
    defaultMessage: 'RESTORE Settings to Default',
    description: 'Label for the restore settings button',
  },
  themeSection: {
    id: 'settings.appearance.themeSection',
    defaultMessage: 'Theme',
    description: 'Label for the theme section',
  },
  themeLightLabel: {
    id: 'settings.appearance.themeSection.light',
    defaultMessage: 'Light',
    description: 'Label for the light theme',
  },
  themeDarkLabel: {
    id: 'settings.appearance.themeSection.dark',
    defaultMessage: 'Dark',
    description: 'Label for the dark theme',
  },
  themeComingSoonLabel: {
    id: 'settings.appearance.themeSection.comingSoon',
    defaultMessage: 'Coming Soon',
    description: 'Label for the coming soon theme',
  },
  themeAutoLabel: {
    id: 'settings.appearance.themeSection.auto',
    defaultMessage: 'Auto',
    description: 'Label for the auto theme',
  },
  themeAutoDescription: {
    id: 'settings.appearance.themeSection.auto.description',
    defaultMessage: ' - based on OS setting',
    description: 'Description for the auto theme',
  },
  fontSizeSection: {
    id: 'settings.appearance.fontSizeSection',
    defaultMessage: 'Font size',
    description: 'Label for the font size section',
  },
  savingSection: {
    id: 'settings.sketch.savingSection',
    defaultMessage: 'Saving',
    description: 'Label for the saving section',
  },
  enableAutoSave: {
    id: 'settings.sketch.savingSection.enableAutoSave',
    defaultMessage: 'Enable autosave',
    description: 'Label for the enable autosave setting',
  },
  saveOnVerifyAndUpload: {
    id: 'settings.sketch.savingSection.saveOnVerifyAndUpload',
    defaultMessage: 'Save on verifying and uploading',
    description: 'Label for the save on verifying and uploading setting',
  },
  deviceSelectionSection: {
    id: 'settings.device.deviceSelectionSection',
    defaultMessage: 'Device selection',
    description: 'Label for the device selection section',
  },
  enableAutoSelection: {
    id: 'settings.device.deviceSelectionSection.enableAutoSelection',
    defaultMessage: 'Enable auto-selection',
    description: 'Label for the enable auto-selection setting',
  },
  autoSelectionInfo: {
    id: 'settings.device.deviceSelectionSection.autoSelectionInfo',
    defaultMessage:
      'On new sketches, when you plug a device it will get automatically selected.',
    description: 'Label for the info auto-selection setting',
  },
  consoleVerbositySection: {
    id: 'settings.device.consoleVerbositySection',
    defaultMessage: 'Console verbosity',
    description: 'Label for the console verbosity section',
  },
  consoleVerbosityInfo: {
    id: 'settings.device.consoleVerbositySection.info',
    defaultMessage: 'This change will be applied from the next compilation.',
    description: 'Label for the info console verbosity setting',
  },
  consoleVerbosity: {
    id: 'settings.device.consoleVerbositySection',
    defaultMessage: 'Console verbosity',
    description: 'Label for the console verbosity setting',
  },
  consoleVerbosityVerbose: {
    id: 'settings.device.consoleVerbositySection.verbose',
    defaultMessage: 'Verbose',
    description: 'Label for the verbose console verbosity setting',
  },
  consoleVerbosityConcise: {
    id: 'settings.device.consoleVerbositySection.concise',
    defaultMessage: 'Concise',
    description: 'Label for the concise console verbosity setting',
  },
  consoleVerbosityVerboseOutput: {
    id: 'settings.device.consoleVerbositySection.verboseOutput',
    defaultMessage: 'Verbose output',
    description: 'Label for the verbose output console verbosity setting',
  },
  consoleVerbosityConciseOutput: {
    id: 'settings.device.consoleVerbositySection.conciseOutput',
    defaultMessage: 'Concise output',
    description: 'Label for the concise output console verbosity setting',
  },
});
