import {
  CustomLibraryExampleItem,
  Example,
  ExamplesFolder,
} from '../../sidenav.type';
import NoResults from '../common/NoResults';
import styles from './examples.module.scss';
import ExamplesFromCustomLibrariesListItem from './ExamplesFromCustomLibrariesListItem';
import ExamplesListItem from './ExamplesListItem';
import ExamplesListItemSkeleton from './ExamplesListItemSkeleton';

const skeletonChildren = Number(styles.skeletonChildren);

interface ExamplesListProps {
  items: (ExamplesFolder | Example | CustomLibraryExampleItem)[];
  sourceLibraryID?: string;
  customLibraryID?: string;
  isLoading?: boolean;
  searchQuery?: string;
  index?: number;
  onHeightChange?: (index?: number) => void;
}

const ExamplesList: React.FC<ExamplesListProps> = (
  props: ExamplesListProps,
) => {
  const {
    items,
    sourceLibraryID,
    customLibraryID,
    isLoading = false,
    searchQuery,
    index,
    onHeightChange,
  } = props;

  return (
    <div className={styles['examples-list-container']}>
      {!isLoading && (!items || (items?.length === 0 && searchQuery)) ? (
        <NoResults
          resourceName="examples"
          classes={{
            container: styles['no-results-container'],
          }}
        />
      ) : (
        <ul className={styles['examples-list']}>
          {isLoading ? (
            <ExamplesListItemSkeleton count={skeletonChildren} />
          ) : customLibraryID ? (
            items.map((item) => (
              <ExamplesFromCustomLibrariesListItem
                key={`${item.name}-${customLibraryID}`}
                example={item as CustomLibraryExampleItem}
                customLibraryID={customLibraryID}
              />
            ))
          ) : (
            items.map((item) => (
              <ExamplesListItem
                key={`${item.name}-${sourceLibraryID}`}
                example={item as Example | ExamplesFolder}
                sourceLibraryID={sourceLibraryID}
                searchQuery={searchQuery}
                index={index}
                onHeightChange={onHeightChange}
              />
            ))
          )}
        </ul>
      )}
    </div>
  );
};

export default ExamplesList;
