import { defineMessages } from 'react-intl';

export const messages = defineMessages({
  filesLabel: {
    id: 'files.files',
    defaultMessage: 'Files',
    description: 'Label for the files sidenav item',
  },
  examplesLabel: {
    id: 'sidenav.examples',
    defaultMessage: 'Examples',
    description: 'Label for the examples sidenav item',
  },
  librariesLabel: {
    id: 'sidenav.libraries',
    defaultMessage: 'Libraries',
    description: 'Label for the libraries sidenav item',
  },
  referenceLabel: {
    id: 'sidenav.reference',
    defaultMessage: 'Reference',
    description: 'Label for the language reference sidenav item',
  },
  genAILabel: {
    id: 'sidenav.genAI',
    defaultMessage: 'Arduino AI Assistant',
    description: 'Label for the genAI sidenav item',
  },
  genAIExperimentalLabel: {
    id: 'sidenav.genAIExperimental',
    defaultMessage: 'Experimental',
    description: 'Label for the genAI experimental sidenav item',
  },
  settingsLabel: {
    id: 'sidenav.settings',
    defaultMessage: 'Settings',
    description: 'Label for the settings sidenav item',
  },
  hideSidenavContentButton: {
    id: 'sidenav.hideSidenavContent',
    defaultMessage: 'Hide sidenav content',
    description: 'Button text to hide the sidenav content',
  },
  sidenavContentClose: {
    id: 'sidenav.sidenavContentClose',
    defaultMessage: 'Close',
    description: 'Button text to close the sidenav content',
  },
  includeLibraryButton: {
    id: 'sidenav.libraries.includeButton',
    defaultMessage: 'Include',
    description: 'Button text to include a library',
  },
  examplesInLibrariesLabel: {
    id: 'sidenav.libraries.examples',
    defaultMessage: 'Examples',
    description: 'Label for the examples section in the libraries sidenav',
  },
  noResults: {
    id: 'sidenav.noResultsTitle',
    defaultMessage: 'No results found',
    description: 'Title shown when no results are found',
  },
  noResultsSubtitle: {
    id: 'sidenav.noResultsSubtitle',
    defaultMessage: "We couldn't find any {resourceName} with this name",
    description: 'Helper text shown when no results are found',
  },
  moreInfo: {
    id: 'sidenav.moreInfo',
    defaultMessage: 'More info',
    description: 'Label for the more info button',
  },
  addLibraryToFavorite: {
    id: 'sidenav.libraries.addLibraryToFavorite',
    defaultMessage: 'Add library to favorites',
    description: 'Label for the add library to favorite button',
  },
  removeLibraryFromFavorite: {
    id: 'sidenav.libraries.removeLibraryFromFavorite',
    defaultMessage: 'Remove library from favorites',
    description: 'Label for the remove library from favorite button',
  },
  copyAndModifyLibrary: {
    id: 'sidenav.libraries.copyAndModifyLibrary',
    defaultMessage: 'Copy & modify library',
    description: 'Label for the "copy and modify library" button',
  },
  modifyLibrary: {
    id: 'sidenav.libraries.modifyLibrary',
    defaultMessage: 'Modify library',
    description: 'Label for the "modify library" button',
  },
  deleteLibrary: {
    id: 'sidenav.libraries.deleteLibrary',
    defaultMessage: 'Delete library',
    description: 'Label for the "delete library" button',
  },
  searchLibraries: {
    id: 'sidenav.libraries.searchLibraries',
    defaultMessage: 'Search libraries',
    description: 'Search libraries',
  },
  showLibrariesFor: {
    id: 'sidenavLibraries.showLibrariesFor',
    defaultMessage: 'Show libraries for:',
    description: 'Label for libraries architecture filter toggle',
  },
  allDevices: {
    id: 'sidenavLibraries.allDevices',
    defaultMessage: 'All devices',
    description: 'All devices filter option',
  },
  noCustomLibrariesTitle: {
    id: 'sidenav.libraries.noCustomLibrariesTitle',
    defaultMessage: 'No custom libraries',
    description: 'Title shown when there are no custom libraries',
  },
  noFavoriteLibrariesTitle: {
    id: 'sidenav.libraries.noFavoriteLibrariesTitle',
    defaultMessage: 'No Favorites',
    description: 'Title shown when there are no favorite libraries',
  },
  noCustomLibrariesMsg: {
    id: 'sidenav.libraries.noCustomLibrariesMsg',
    defaultMessage: 'No custom libraries found',
    description: 'Message shown when there are no custom libraries',
  },
  noFavoriteLibrariesMsg: {
    id: 'sidenav.libraries.noFavoriteLibrariesMsg',
    defaultMessage: 'No favorite libraries found',
    description: 'Message shown when there are no favorite libraries',
  },
  downloadLibrary: {
    id: 'sidenav.libraries.downloadLibrary',
    defaultMessage: 'Download',
    description: 'Label for the "download library" button',
  },
});
