import clsx from 'clsx';
import { useRef, useState } from 'react';
import { useButton } from 'react-aria';

import { Loader } from '../essential/loader';
import styles from './editor-image.module.scss';

interface EditorImageProps {
  data?: string;
  extension: string;
}

const EditorImage: React.FC<EditorImageProps> = (props: EditorImageProps) => {
  const { data, extension } = props;

  const [isZoomed, setIsZoomed] = useState(false);

  const ref = useRef<HTMLImageElement>(null);

  const { buttonProps } = useButton(
    { onPress: () => setIsZoomed(!isZoomed) },
    ref,
  );

  return (
    <div
      className={clsx(styles.container, {
        [styles['container-scaled']]: !isZoomed,
      })}
    >
      {data ? (
        <img
          src={`data:image/${extension};base64, ${data.split(',')[1]}`}
          alt="sketch file"
          className={clsx(styles.image, {
            [styles['image-scaled']]: !isZoomed,
            [styles['image-zoomed']]: isZoomed,
          })}
          {...buttonProps}
        />
      ) : (
        <div className={styles.loaderContainer}>
          <Loader />
        </div>
      )}
    </div>
  );
};

export default EditorImage;
