import { PlayOutline } from '@cloud-editor-mono/images/assets/icons';
import { useMutation } from '@tanstack/react-query';

import { Button, ButtonType } from '../../../components-by-app/app-lab';
import { useI18n } from '../../../i18n/useI18n';
import { Medium, XSmall } from '../../../typography';
import { AppLabDialog } from '../app-lab-dialog/AppLabDialog';
import { setAsDefaultAppDialogMessages as messages } from '../messages';
import styles from './set-as-default-app-dialog.module.scss';

export type SetAsDefaultAppDialogLogic = () => {
  open: boolean;
  confirmAction: () => Promise<boolean>;
  onOpenChange: (open: boolean) => void;
};

type SetAsDefaultAppDialogProps = { logic: SetAsDefaultAppDialogLogic };

export const SetAsDefaultAppDialog: React.FC<SetAsDefaultAppDialogProps> = ({
  logic,
}: SetAsDefaultAppDialogProps) => {
  const { open, confirmAction, onOpenChange } = logic();

  const { formatMessage } = useI18n();

  const { mutateAsync: handleSetAsDefaultApp, isLoading } = useMutation(
    ['set-as-default-app'],
    async (): Promise<void> => {
      const result = await confirmAction();
      if (result) {
        onOpenChange(false);
      }
    },
  );

  return (
    <AppLabDialog
      open={open}
      onOpenChange={onOpenChange}
      title={formatMessage(messages.dialogTitle)}
      footer={
        <>
          <Button
            type={ButtonType.Secondary}
            onClick={(): void => onOpenChange(false)}
          >
            {formatMessage(messages.cancelButton)}
          </Button>
          <Button
            type={ButtonType.Primary}
            loading={isLoading}
            onClick={handleSetAsDefaultApp}
          >
            {formatMessage(messages.confirmButton)}
          </Button>
        </>
      }
      classes={{
        body: styles['body'],
      }}
    >
      <PlayOutline className={styles['body-icon']} />
      <Medium className={styles['body-title']}>
        {formatMessage(messages.dialogBodyTitle)}
      </Medium>
      <XSmall className={styles['body-description']}>
        {formatMessage(messages.dialogBodyDescription)}
      </XSmall>
    </AppLabDialog>
  );
};
