import clsx from 'clsx';

import type { Notification } from '../../AppLabFooterBar.type';
import styles from './notification-panel.module.scss';

interface NotificationPanelProps {
  items: Notification[];
}

const NotificationPanel: React.FC<NotificationPanelProps> = ({
  items,
}: NotificationPanelProps) => {
  return (
    <div className={clsx(styles['notification-menu'])}>
      <div className={clsx(styles['notification-menu-header'])}>
        Notifications
      </div>
      <div className={clsx(styles['notification-menu-content'])}>
        {items.length > 0 ? (
          items.map((item, index) => (
            <div
              role={item.onClick ? 'button' : undefined}
              title={item.tooltip}
              key={index}
              className={clsx(styles['notification-item'], {
                [styles['is-clickable']]: !!item.onClick,
              })}
              onClick={item.onClick}
              onKeyUp={item.onClick}
            >
              {item.icon && (
                <span
                  title={item.tooltip}
                  className={clsx(styles['notification-icon'])}
                >
                  {item.icon}
                </span>
              )}
              {item.label}
            </div>
          ))
        ) : (
          <div className={clsx(styles['no-notifications'])}>
            No new notifications
          </div>
        )}
      </div>
    </div>
  );
};

export default NotificationPanel;
