import clsx from 'clsx';

import styles from './bell-icon.module.scss';

interface BellIconProps {
  newNotifications: number;
}

const BellIcon: React.FC<BellIconProps> = ({
  newNotifications,
}: BellIconProps) => (
  <div className={clsx(styles['bell-icon-container'])}>
    <svg
      xmlns="http://www.w3.org/2000/svg"
      className={clsx(styles['bell-icon'])}
      viewBox="0 0 32 32"
    >
      <path
        d="M23.82 23.57C23.7281 23.7025 23.6055 23.8107 23.4628 23.8856C23.32 23.9605 23.1612 23.9997 23 24H0.999987C0.838233 24.0005 0.678765 23.9618 0.535263 23.8872C0.391761 23.8125 0.268508 23.7042 0.176078 23.5714C0.0836472 23.4387 0.024798 23.2855 0.00457828 23.125C-0.0156414 22.9645 0.00337199 22.8015 0.0599872 22.65L2.99999 14.82V12C3.00104 9.78694 3.81744 7.65185 5.29321 6.00268C6.76897 4.35351 8.80063 3.3059 11 3.06V1C11 0.734784 11.1053 0.48043 11.2929 0.292893C11.4804 0.105357 11.7348 0 12 0C12.2652 0 12.5196 0.105357 12.7071 0.292893C12.8946 0.48043 13 0.734784 13 1V3.06C15.1993 3.3059 17.231 4.35351 18.7068 6.00268C20.1825 7.65185 20.9989 9.78694 21 12V14.82L23.94 22.65C23.9958 22.8016 24.014 22.9645 23.9931 23.1248C23.9722 23.285 23.9128 23.4378 23.82 23.57Z"
        fill="currentColor"
      />
      <path
        d="M12 29C10.7018 29 9.43855 28.5789 8.39997 27.8C8.29492 27.7212 8.20641 27.6225 8.1395 27.5095C8.07259 27.3965 8.0286 27.2714 8.01002 27.1414C7.97252 26.8789 8.04084 26.6122 8.19997 26.4C8.3591 26.1878 8.596 26.0476 8.85855 26.0101C9.1211 25.9725 9.3878 26.0409 9.59997 26.2C10.2924 26.7193 11.1345 27 12 27C12.8655 27 13.7076 26.7193 14.4 26.2C14.6121 26.0409 14.8788 25.9725 15.1414 26.0101C15.4039 26.0476 15.6408 26.1878 15.8 26.4C15.9591 26.6122 16.0274 26.8789 15.9899 27.1414C15.9524 27.404 15.8121 27.6409 15.6 27.8C14.5614 28.5789 13.2982 29 12 29Z"
        fill="currentColor"
      />

      {newNotifications > 0 && (
        <circle
          cx="19"
          cy="5"
          r="5"
          className={clsx(styles['notification-dot'])}
        />
      )}
    </svg>
    {newNotifications > 0 && (
      <span className={clsx(styles['notification-label'])}>
        {newNotifications}
      </span>
    )}
  </div>
);

export default BellIcon;
