import { AppDetailedInfo } from '@cloud-editor-mono/infrastructure';

import { CreateAppDialogLogic, DeleteAppDialogLogic } from '../dialogs';
import { SetAsDefaultAppDialogLogic } from '../dialogs/app-lab/set-as-default-app-dialog/SetAsDefaultAppDialog';

export enum AppAction {
  SetAsDefault = 'DEFAULT',
  Rename = 'RENAME',
  Duplicate = 'DUPLICATE',
  Delete = 'DELETE',
}

export type AppTitleLogic = () => {
  app: AppDetailedInfo | undefined;
  name: string;
  editing: boolean;
  hasError: boolean;
  onAppNameChange: (value: string) => void;
  onAppAction: (action: AppAction) => void;
  onResetAppName: () => void;
  onRenameApp: () => void;
  onUpdateAppIcon: (emoji: string) => Promise<boolean>;
  deleteAppDialogLogic: DeleteAppDialogLogic;
  createAppDialogLogic: CreateAppDialogLogic;
  setAsDefaultAppDialogLogic: SetAsDefaultAppDialogLogic;
};

export type UseCreateAppTitleLogic = (
  app: AppDetailedInfo | undefined,
  section?: string,
  reloadApp?: () => void,
) => AppTitleLogic;
