import { WebSocketHandlers } from './websocket.type';

export function getWebSocket(
  url: string,
  handlers: WebSocketHandlers,
): Promise<WebSocket> {
  const websocket = new WebSocket(url);
  websocket.onopen = handlers.onopen;
  websocket.onmessage = handlers.onmessage;
  websocket.onerror = handlers.onerror;
  websocket.onclose = handlers.onclose;

  return Promise.resolve(websocket);
}
