import { CamelCasedProperties } from 'type-fest';

import { ArduinoBuilderExample_BuilderApi } from './builderApi.examples.type';
export interface GetLibraries_Params {
  architecture?: string[] | string;
  category?: string;
  limit?: number;
  maintainer?: string;
  page?: number;
  search?: string;
  type?: string;
  without_type?: string;
}

export interface GetLibrary_Params {
  id: string;
}

export interface LibraryFile {
  name: string;
  path: string;
  href: string;
  mimetype: string;
}

export interface Library {
  architectures: string[];
  category: string;
  code: string;
  download_url: string;
  examples_number: number;
  href: string;
  id: string;
  license: string;
  maintainer: string;
  name: string;
  sentence: string;
  types: string[];
  url: string;
  version: string;
}

export interface Libraries {
  libraries: Library[];
  page: number;
  pages: number;
  total_items: number;
}

export type LibraryDetails = Library & {
  examples?: ArduinoBuilderExample_BuilderApi[];
  files?: LibraryFile[];
  other_versions?: string[];
  path?: string;
};

export type LibraryDetails_Response = CamelCasedProperties<LibraryDetails>;

export enum IsFavoriteLibrary {
  Yes = 'yes',
  No = 'no',
  Unknown = 'unknown',
}

export type LibrariesItem_Response = CamelCasedProperties<Library> & {
  isFavorite: IsFavoriteLibrary;
};

export interface GetLibraries_Response {
  libraries: LibrariesItem_Response[];
  page: number;
  pages: number;
  totalItems: number;
}

export type GetFavoriteLibraries_Response = LibrariesItem_Response[];

export interface FavoriteLibrary_Params {
  id: string;
}
