import {
  AppLabBrickDetail,
  AppLabBrickListItem,
  AppLabBricksList,
  AppLabTopBar,
} from '@cloud-editor-mono/ui-components/lib/components-by-app/app-lab';
import clsx from 'clsx';
import Split from 'react-split';

import styles from './brick-list.module.scss';
import { useBrickListLogic } from './brickList.logic';

const BrickList: React.FC = () => {
  const {
    bricks,
    isLoading: bricksLoading,
    selectedBrick,
    brickDetailLogic,
    setSelectedBrick,
  } = useBrickListLogic();

  return (
    <section className={styles['main']}>
      <AppLabTopBar pathItems={['Bricks']} />
      <div className={styles['container']}>
        {/* Loading state */}
        {bricksLoading ? <AppLabBrickListItem variant="skeleton" /> : null}
        {!bricksLoading && selectedBrick && (
          <Split
            className={styles['split']}
            sizes={[50, 50]}
            minSize={400}
            expandToMin={false}
            gutterSize={16}
            gutterAlign="center"
            snapOffset={30}
            direction="horizontal"
            cursor="col-resize"
            gutter={(): HTMLElement => {
              const element = document.createElement('div');
              element.className = styles['gutter'];
              return element;
            }}
          >
            <div className={(styles['split-item'], styles['split-item-left'])}>
              <AppLabBricksList
                bricks={bricks}
                selectedBrick={selectedBrick}
                onClick={setSelectedBrick}
              />
            </div>

            <div
              className={clsx(styles['split-item'], styles['split-item-right'])}
            >
              <AppLabBrickDetail
                brickId={selectedBrick?.id ?? ''}
                brickDetailLogic={brickDetailLogic}
              />
            </div>
          </Split>
        )}
      </div>
    </section>
  );
};

export default BrickList;
