import {
  AppLabAppTitle,
  AppLabTabs,
  AppLabTopBar,
  MultipleConsolePanel,
  RuntimeActions,
  SwapRunningAppDialog,
} from '@cloud-editor-mono/ui-components/lib/components-by-app/app-lab';
import clsx from 'clsx';
import { useState } from 'react';

import { AppsSection } from '../../routes/__root';
import styles from './app-detail.module.scss';
import { useAppDetailLogic } from './appDetail.logic';
import { useAppDetailRuntimeLogic } from './appDetailRuntime.logic';
import { useCreateAppTitleLogic } from './appDetailTitle.logic';
import AppFilesSection from './sub-components/AppFilesSection.feat';

interface AppDetailProps {
  appId: string;
  section: AppsSection;
}

const AppDetail: React.FC<AppDetailProps> = (props: AppDetailProps) => {
  const { appId, section } = props;
  const {
    app,
    appBricks,
    appLibraries,
    bricks,
    fileTree,
    selectedFile,
    selectedNode,
    defaultOpenFoldersState,
    reloadApp,
    setSelectedFile,
    openFilesFolder,
    openExternal,
    openExternalLink,
    addAppBrick,
    removeAppBrick,
    editorLogicParams,
    addFileHandler,
    renameFileHandler,
    deleteFileHandler,
    addSketchLibraryDialogLogic,
    openAddSketchLibraryDialog,
    deleteSketchLibrary,
  } = useAppDetailLogic(appId, section);

  const tabs = ['editor', 'console'] as const;
  const [activeTab, setTab] = useState<typeof tabs[number]>('editor');

  const appTitleLogic = useCreateAppTitleLogic(app, section, reloadApp);

  const {
    swapRunningAppDialogLogic,
    multipleConsolePanelLogic,
    runtimeActionsLogic,
  } = useAppDetailRuntimeLogic(app, fileTree, appTitleLogic);

  return (
    <section className={styles['main']}>
      <SwapRunningAppDialog logic={swapRunningAppDialogLogic} />
      <AppLabTopBar
        pathItems={[
          section,
          <AppLabAppTitle key="app-title" appTitleLogic={appTitleLogic} />,
        ]}
      >
        <div className={styles['top-bar-container']}>
          <AppLabTabs tabs={tabs} setTab={setTab} activeTab={activeTab} />
          {app?.id && (
            <RuntimeActions
              runtimeActionsLogic={runtimeActionsLogic}
              setTab={setTab}
              runtimeDisable={!fileTree}
            />
          )}
        </div>
      </AppLabTopBar>
      {activeTab === 'editor' && (
        <AppFilesSection
          app={app}
          section={section}
          appBricks={appBricks}
          bricks={bricks}
          appLibraries={appLibraries}
          fileTree={fileTree}
          selectedFile={selectedFile}
          selectedNode={selectedNode}
          defaultOpenFoldersState={defaultOpenFoldersState}
          setSelectedFile={setSelectedFile}
          openFilesFolder={openFilesFolder}
          openExternal={openExternal}
          openExternalLink={openExternalLink}
          addAppBrick={addAppBrick}
          deleteAppBrick={removeAppBrick}
          editorLogicParams={editorLogicParams}
          addFileHandler={addFileHandler}
          renameFileHandler={renameFileHandler}
          deleteFileHandler={deleteFileHandler}
          addSketchLibraryDialogLogic={addSketchLibraryDialogLogic}
          openAddSketchLibraryDialog={openAddSketchLibraryDialog}
          deleteSketchLibrary={deleteSketchLibrary}
        />
      )}
      <div
        className={clsx(styles['multiple-console'], {
          [styles['hidden']]: activeTab !== 'console',
        })}
      >
        <MultipleConsolePanel
          multipleConsolePanelLogic={multipleConsolePanelLogic}
        />
      </div>
    </section>
  );
};

export default AppDetail;
