/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.Handshaker;

final class HandshakeStateManager {
    private LinkedList<HandshakeState> upcomingStates = new LinkedList();
    private LinkedList<HandshakeState> alternatives = new LinkedList();
    private static final boolean debugIsOn = Handshaker.debug != null && Debug.isOn("handshake") && Debug.isOn("verbose");
    private static final HashMap<Byte, String> handshakeTypes = new HashMap(8);

    HandshakeStateManager() {
    }

    boolean isEmpty() {
        return this.upcomingStates.isEmpty();
    }

    List<Byte> check(byte by) throws SSLProtocolException {
        LinkedList<Byte> linkedList = new LinkedList<Byte>();
        String string = "Handshake message sequence violation, " + by;
        if (debugIsOn) {
            System.out.println("check handshake state: " + HandshakeStateManager.toString(by));
        }
        if (this.upcomingStates.isEmpty()) {
            if (by != 0 && by != 1) {
                throw new SSLProtocolException("Handshake message sequence violation, " + by);
            }
            return Collections.emptyList();
        }
        if (by == 0) {
            return Collections.emptyList();
        }
        for (HandshakeState handshakeState : this.upcomingStates) {
            if (handshakeState.handshakeType == by) {
                return linkedList;
            }
            if (handshakeState.isOptional) {
                linkedList.add(handshakeState.handshakeType);
                continue;
            }
            for (HandshakeState handshakeState2 : this.alternatives) {
                if (handshakeState2.handshakeType == by) {
                    return linkedList;
                }
                if (handshakeState2.isOptional) continue;
                throw new SSLProtocolException(string);
            }
            throw new SSLProtocolException(string);
        }
        throw new SSLProtocolException("Handshake message sequence violation, " + by);
    }

    void update(HandshakeMessage handshakeMessage, boolean bl) throws SSLProtocolException {
        byte by = (byte)handshakeMessage.messageType();
        String string = "Handshake message sequence violation, " + by;
        if (debugIsOn) {
            System.out.println("update handshake state: " + HandshakeStateManager.toString(by));
        }
        boolean bl2 = false;
        switch (by) {
            case 0: {
                if (this.upcomingStates.isEmpty()) break;
                this.upcomingStates.add(HandshakeState.HS_CLIENT_HELLO);
                break;
            }
            case 1: {
                Object object;
                if (!this.upcomingStates.isEmpty() && (object = this.upcomingStates.pop()) != HandshakeState.HS_CLIENT_HELLO) {
                    throw new SSLProtocolException(string);
                }
                object = (HandshakeMessage.ClientHello)handshakeMessage;
                this.upcomingStates.add(HandshakeState.HS_SERVER_HELLO);
                break;
            }
            case 2: {
                Object object;
                Object object2;
                if (!this.upcomingStates.isEmpty()) {
                    object2 = this.upcomingStates.pop();
                    object = null;
                    if (!this.alternatives.isEmpty()) {
                        object = this.alternatives.pop();
                    }
                    if (object2 != HandshakeState.HS_SERVER_HELLO && object != HandshakeState.HS_SERVER_HELLO) {
                        throw new SSLProtocolException(string);
                    }
                } else {
                    throw new SSLProtocolException(string);
                }
                object2 = (HandshakeMessage.ServerHello)handshakeMessage;
                object = ((HandshakeMessage.ServerHello)object2).extensions;
                if (bl) {
                    this.upcomingStates.add(HandshakeState.HS_SERVER_CHANGE_CIPHER_SPEC);
                    this.upcomingStates.add(HandshakeState.HS_SERVER_FINISHED);
                    this.upcomingStates.add(HandshakeState.HS_CLIENT_CHANGE_CIPHER_SPEC);
                    this.upcomingStates.add(HandshakeState.HS_CLIENT_FINISHED);
                    break;
                }
                Enum enum_ = ((HandshakeMessage.ServerHello)object2).cipherSuite.keyExchange;
                if (enum_ != CipherSuite.KeyExchange.K_KRB5 && enum_ != CipherSuite.KeyExchange.K_KRB5_EXPORT && enum_ != CipherSuite.KeyExchange.K_DH_ANON && enum_ != CipherSuite.KeyExchange.K_ECDH_ANON) {
                    this.upcomingStates.add(HandshakeState.HS_SERVER_CERTIFICATE);
                }
                if (enum_ == CipherSuite.KeyExchange.K_RSA_EXPORT || enum_ == CipherSuite.KeyExchange.K_DHE_RSA || enum_ == CipherSuite.KeyExchange.K_DHE_DSS || enum_ == CipherSuite.KeyExchange.K_DH_ANON || enum_ == CipherSuite.KeyExchange.K_ECDHE_RSA || enum_ == CipherSuite.KeyExchange.K_ECDHE_ECDSA || enum_ == CipherSuite.KeyExchange.K_ECDH_ANON) {
                    this.upcomingStates.add(HandshakeState.HS_SERVER_KEY_EXCHANGE);
                }
                this.upcomingStates.add(HandshakeState.HS_CERTIFICATE_REQUEST);
                this.upcomingStates.add(HandshakeState.HS_SERVER_HELLO_DONE);
                this.upcomingStates.add(HandshakeState.HS_CLIENT_CERTIFICATE);
                this.upcomingStates.add(HandshakeState.HS_CLIENT_KEY_EXCHANGE);
                this.upcomingStates.add(HandshakeState.HS_CERTIFICATE_VERIFY);
                this.upcomingStates.add(HandshakeState.HS_CLIENT_CHANGE_CIPHER_SPEC);
                this.upcomingStates.add(HandshakeState.HS_CLIENT_FINISHED);
                this.upcomingStates.add(HandshakeState.HS_SERVER_CHANGE_CIPHER_SPEC);
                this.upcomingStates.add(HandshakeState.HS_SERVER_FINISHED);
                break;
            }
            case 11: {
                Enum enum_;
                while (!this.upcomingStates.isEmpty()) {
                    enum_ = this.upcomingStates.pop();
                    if (((HandshakeState)enum_).handshakeType == by) {
                        HandshakeState handshakeState;
                        bl2 = true;
                        if (enum_ != HandshakeState.HS_CLIENT_CERTIFICATE && enum_ != HandshakeState.HS_SERVER_CERTIFICATE) {
                            throw new SSLProtocolException(string);
                        }
                        boolean bl3 = false;
                        if (!this.upcomingStates.isEmpty() && (handshakeState = this.upcomingStates.getFirst()) == HandshakeState.HS_CLIENT_KEY_EXCHANGE) {
                            bl3 = true;
                        }
                        if (!(bl3 ? enum_ != HandshakeState.HS_CLIENT_CERTIFICATE : enum_ != HandshakeState.HS_SERVER_CERTIFICATE)) break;
                        throw new SSLProtocolException(string);
                    }
                    if (((HandshakeState)enum_).isOptional) continue;
                    throw new SSLProtocolException(string);
                }
                if (bl2) break;
                throw new SSLProtocolException(string);
            }
            default: {
                Enum enum_;
                while (!this.upcomingStates.isEmpty()) {
                    enum_ = this.upcomingStates.pop();
                    if (((HandshakeState)enum_).handshakeType == by) {
                        bl2 = true;
                        break;
                    }
                    if (((HandshakeState)enum_).isOptional) continue;
                    throw new SSLProtocolException(string);
                }
                if (bl2) break;
                throw new SSLProtocolException(string);
            }
        }
        if (debugIsOn) {
            for (Object object2 : this.upcomingStates) {
                System.out.println("upcoming handshake states: " + (Object)object2);
            }
            for (Object object2 : this.alternatives) {
                System.out.println("upcoming handshake alternative state: " + (Object)object2);
            }
        }
    }

    void changeCipherSpec(boolean bl, boolean bl2) throws SSLProtocolException {
        if (debugIsOn) {
            System.out.println("update handshake state: change_cipher_spec");
        }
        String string = "ChangeCipherSpec message sequence violation";
        HandshakeState handshakeState = bl2 && bl || !bl2 && !bl ? HandshakeState.HS_SERVER_CHANGE_CIPHER_SPEC : HandshakeState.HS_CLIENT_CHANGE_CIPHER_SPEC;
        boolean bl3 = false;
        while (!this.upcomingStates.isEmpty()) {
            Object object = this.upcomingStates.pop();
            if (object == handshakeState) {
                bl3 = true;
                break;
            }
            if (object.isOptional) continue;
            throw new SSLProtocolException(string);
        }
        if (!bl3) {
            throw new SSLProtocolException(string);
        }
        if (debugIsOn) {
            for (HandshakeState handshakeState2 : this.upcomingStates) {
                System.out.println("upcoming handshake states: " + (Object)((Object)handshakeState2));
            }
            for (HandshakeState handshakeState2 : this.alternatives) {
                System.out.println("upcoming handshake alternative state: " + (Object)((Object)handshakeState2));
            }
        }
    }

    private static String toString(byte by) {
        String string = handshakeTypes.get(by);
        if (string == null) {
            string = "unknown";
        }
        return string + "[" + by + "]";
    }

    static {
        handshakeTypes.put((byte)0, "hello_request");
        handshakeTypes.put((byte)1, "client_hello");
        handshakeTypes.put((byte)2, "server_hello");
        handshakeTypes.put((byte)11, "certificate");
        handshakeTypes.put((byte)12, "server_key_exchange");
        handshakeTypes.put((byte)14, "server_hello_done");
        handshakeTypes.put((byte)15, "certificate_verify");
        handshakeTypes.put((byte)16, "client_key_exchange");
        handshakeTypes.put((byte)20, "finished");
    }

    static enum HandshakeState {
        HS_HELLO_REQUEST("hello_request", 0),
        HS_CLIENT_HELLO("client_hello", 1),
        HS_SERVER_HELLO("server_hello", 2),
        HS_SERVER_CERTIFICATE("server certificate", 11),
        HS_SERVER_KEY_EXCHANGE("server_key_exchange", 12, true),
        HS_CERTIFICATE_REQUEST("certificate_request", 13, true),
        HS_SERVER_HELLO_DONE("server_hello_done", 14),
        HS_CLIENT_CERTIFICATE("client certificate", 11, true),
        HS_CLIENT_KEY_EXCHANGE("client_key_exchange", 16),
        HS_CERTIFICATE_VERIFY("certificate_verify", 15, true),
        HS_CLIENT_CHANGE_CIPHER_SPEC("client change_cipher_spec", -1),
        HS_CLIENT_FINISHED("client finished", 20),
        HS_SERVER_CHANGE_CIPHER_SPEC("server change_cipher_spec", -1),
        HS_SERVER_FINISHED("server finished", 20);

        final String description;
        final byte handshakeType;
        final boolean isOptional;

        private HandshakeState(String string2, byte by) {
            this.description = string2;
            this.handshakeType = by;
            this.isOptional = false;
        }

        private HandshakeState(String string2, byte by, boolean bl) {
            this.description = string2;
            this.handshakeType = by;
            this.isOptional = bl;
        }

        public String toString() {
            return this.description + "[" + this.handshakeType + "]" + (this.isOptional ? "(optional)" : "");
        }
    }
}

