/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.util.HashMap;
import org.apache.batik.anim.dom.XBLOMContentElement;
import org.apache.batik.bridge.svg12.ContentManager;
import org.apache.batik.bridge.svg12.XPathPatternContentSelector;
import org.apache.batik.bridge.svg12.XPathSubsetContentSelector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractContentSelector {
    protected ContentManager contentManager;
    protected XBLOMContentElement contentElement;
    protected Element boundElement;
    protected static HashMap selectorFactories = new HashMap();

    public AbstractContentSelector(ContentManager contentManager, XBLOMContentElement xBLOMContentElement, Element element) {
        this.contentManager = contentManager;
        this.contentElement = xBLOMContentElement;
        this.boundElement = element;
    }

    public abstract NodeList getSelectedContent();

    abstract boolean update();

    protected boolean isSelected(Node node) {
        return this.contentManager.getContentElement(node) != null;
    }

    public static AbstractContentSelector createSelector(String string, ContentManager contentManager, XBLOMContentElement xBLOMContentElement, Element element, String string2) {
        ContentSelectorFactory contentSelectorFactory = (ContentSelectorFactory)selectorFactories.get(string);
        if (contentSelectorFactory == null) {
            throw new RuntimeException("Invalid XBL content selector language '" + string + "'");
        }
        return contentSelectorFactory.createSelector(contentManager, xBLOMContentElement, element, string2);
    }

    static {
        XPathPatternContentSelectorFactory xPathPatternContentSelectorFactory = new XPathPatternContentSelectorFactory();
        XPathSubsetContentSelectorFactory xPathSubsetContentSelectorFactory = new XPathSubsetContentSelectorFactory();
        selectorFactories.put(null, xPathPatternContentSelectorFactory);
        selectorFactories.put("XPathPattern", xPathPatternContentSelectorFactory);
        selectorFactories.put("XPathSubset", xPathSubsetContentSelectorFactory);
    }

    protected static class XPathPatternContentSelectorFactory
    implements ContentSelectorFactory {
        protected XPathPatternContentSelectorFactory() {
        }

        @Override
        public AbstractContentSelector createSelector(ContentManager contentManager, XBLOMContentElement xBLOMContentElement, Element element, String string) {
            return new XPathPatternContentSelector(contentManager, xBLOMContentElement, element, string);
        }
    }

    protected static class XPathSubsetContentSelectorFactory
    implements ContentSelectorFactory {
        protected XPathSubsetContentSelectorFactory() {
        }

        @Override
        public AbstractContentSelector createSelector(ContentManager contentManager, XBLOMContentElement xBLOMContentElement, Element element, String string) {
            return new XPathSubsetContentSelector(contentManager, xBLOMContentElement, element, string);
        }
    }

    protected static interface ContentSelectorFactory {
        public AbstractContentSelector createSelector(ContentManager var1, XBLOMContentElement var2, Element var3, String var4);
    }
}

