/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.Compiler;
import cc.arduino.UpdatableBoardsLibsFakeURLsHandler;
import cc.arduino.UploaderUtils;
import cc.arduino.contributions.BuiltInCoreIsNewerCheck;
import cc.arduino.contributions.ConsoleProgressListener;
import cc.arduino.contributions.ContributionsSelfCheck;
import cc.arduino.contributions.DownloadableContributionVersionComparator;
import cc.arduino.contributions.GPGDetachedSignatureVerifier;
import cc.arduino.contributions.ProgressListener;
import cc.arduino.contributions.SignatureVerifier;
import cc.arduino.contributions.VersionHelper;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.LibrariesIndexer;
import cc.arduino.contributions.libraries.LibraryInstaller;
import cc.arduino.contributions.libraries.LibraryOfSameTypeComparator;
import cc.arduino.contributions.libraries.ui.LibraryManagerUI;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributionInstaller;
import cc.arduino.contributions.packages.ContributionsIndexer;
import cc.arduino.contributions.packages.ui.ContributionManagerUI;
import cc.arduino.files.DeleteFilesOnShutdown;
import cc.arduino.packages.DiscoveryManager;
import cc.arduino.packages.Uploader;
import cc.arduino.view.Event;
import cc.arduino.view.JMenuUtils;
import cc.arduino.view.SplashScreenHelper;
import cc.arduino.view.preferences.Preferences;
import com.apple.eawt.Application;
import com.github.zafarkhaja.semver.Version;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.NewBoardListener;
import processing.app.PreferencesData;
import processing.app.Sketch;
import processing.app.SketchController;
import processing.app.Theme;
import processing.app.UpdateCheck;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.CommandlineParser;
import processing.app.helpers.ConsoleLogger;
import processing.app.helpers.FileUtils;
import processing.app.helpers.GUIUserNotifier;
import processing.app.helpers.LogFormatter;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.helpers.filefilters.OnlyFilesWithExtension;
import processing.app.javax.swing.filechooser.FileNameExtensionFilter;
import processing.app.legacy.PApplet;
import processing.app.macosx.ThinkDifferent;
import processing.app.packages.LibraryList;
import processing.app.packages.UserLibrary;
import processing.app.packages.UserLibraryFolder;
import processing.app.syntax.PdeKeywords;
import processing.app.syntax.SketchTextAreaDefaultInputMap;
import processing.app.tools.MenuScroller;
import processing.app.tools.ZipDeflater;

public class Base {
    private static final int RECENT_SKETCHES_MAX_SIZE = 10;
    private static boolean commandLine;
    public static volatile Base INSTANCE;
    public static Map<String, Object> FIND_DIALOG_STATE;
    private final ContributionInstaller contributionInstaller;
    private final LibraryInstaller libraryInstaller;
    private ContributionsSelfCheck contributionsSelfCheck;
    boolean builtOnce;
    public static String librariesClassPath;
    static File untitledFolder;
    List<Editor> editors = Collections.synchronizedList(new ArrayList());
    Editor activeEditor;
    private List<JMenu> boardsCustomMenus;
    private List<JMenuItem> programmerMenus;
    private PdeKeywords pdeKeywords;
    private final List<JMenuItem> recentSketchesMenuItems = new LinkedList<JMenuItem>();
    boolean breakTime = false;
    String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static String priorPlatformFolder;
    private static boolean newLibraryImported;
    private MouseWheelListener editorFontResizeMouseWheelListener = null;
    private KeyListener editorFontResizeKeyListener = null;

    public static void main(String[] args) throws Exception {
        if (!OSUtils.isWindows()) {
            System.setProperty("awt.useSystemAAFontSettings", "on");
            System.setProperty("swing.aatext", "true");
        }
        System.setProperty("java.net.useSystemProxies", "true");
        if (OSUtils.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", String.valueOf(!System.getProperty("os.version").startsWith("10.13") || Application.getApplication().isAboutMenuItemPresent()));
            ThinkDifferent.init();
        }
        try {
            INSTANCE = new Base(args);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(255);
        }
    }

    public static void initLogger() {
        Handler[] handlers;
        ConsoleLogger consoleHandler = new ConsoleLogger();
        consoleHandler.setLevel(Level.ALL);
        consoleHandler.setFormatter(new LogFormatter("%1$tl:%1$tM:%1$tS [%4$7s] %2$s: %5$s%n"));
        Logger globalLogger = Logger.getLogger("global");
        globalLogger.setLevel(consoleHandler.getLevel());
        for (Handler handler : handlers = globalLogger.getHandlers()) {
            globalLogger.removeHandler(handler);
        }
        Logger root = Logger.getLogger("");
        for (Handler handler : handlers = root.getHandlers()) {
            root.removeHandler(handler);
        }
        globalLogger.addHandler(consoleHandler);
        Logger.getLogger("cc.arduino.packages.autocomplete").setParent(globalLogger);
        Logger.getLogger("br.com.criativasoft.cpluslibparser").setParent(globalLogger);
        Logger.getLogger(Base.class.getPackage().getName()).setParent(globalLogger);
    }

    protected static boolean isCommandLine() {
        return commandLine;
    }

    public static File absoluteFile(String path) {
        return BaseNoGui.absoluteFile((String)path);
    }

    public Base(String[] args) throws Exception {
        SplashScreenHelper splash;
        Thread deleteFilesOnShutdownThread = new Thread((Runnable)DeleteFilesOnShutdown.INSTANCE);
        deleteFilesOnShutdownThread.setName("DeleteFilesOnShutdown");
        Runtime.getRuntime().addShutdownHook(deleteFilesOnShutdownThread);
        BaseNoGui.initLogger();
        Base.initLogger();
        BaseNoGui.initPlatform();
        BaseNoGui.getPlatform().init();
        BaseNoGui.initPortableFolder();
        BaseNoGui.initParameters((String[])args);
        CommandlineParser parser = new CommandlineParser(args);
        parser.parseArgumentsPhase1();
        commandLine = !parser.isGuiMode();
        BaseNoGui.checkInstallationFolder();
        if (BaseNoGui.getSketchbookPath() == null) {
            File defaultFolder = this.getDefaultSketchbookFolderOrPromptForIt();
            if (BaseNoGui.getPortableFolder() != null) {
                PreferencesData.set((String)"sketchbook.path", (String)BaseNoGui.getPortableSketchbookFolder());
            } else {
                PreferencesData.set((String)"sketchbook.path", (String)defaultFolder.getAbsolutePath());
            }
            if (!defaultFolder.exists()) {
                defaultFolder.mkdirs();
            }
        }
        if (parser.isGuiMode()) {
            splash = new SplashScreenHelper(SplashScreen.getSplashScreen());
            BaseNoGui.notifier = new GUIUserNotifier(this);
            Theme.init();
            System.setProperty("swing.aatext", PreferencesData.get((String)"editor.antialias", (String)"true"));
            try {
                BaseNoGui.getPlatform().setLookAndFeel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        } else {
            splash = new SplashScreenHelper(null);
        }
        splash.splashText(I18n.tr((String)"Loading configuration..."));
        BaseNoGui.initVersion();
        untitledFolder = FileUtils.createTempFolder((String)("untitled" + new Random().nextInt(Integer.MAX_VALUE)), (String)".tmp");
        DeleteFilesOnShutdown.add((File)untitledFolder);
        splash.splashText(I18n.tr((String)"Initializing packages..."));
        BaseNoGui.initPackages();
        parser.getUploadPort().ifPresent(BaseNoGui::selectSerialPort);
        splash.splashText(I18n.tr((String)"Preparing boards..."));
        if (!Base.isCommandLine()) {
            this.rebuildBoardsMenu();
            this.rebuildProgrammerMenu();
        } else {
            TargetBoard lastSelectedBoard = BaseNoGui.getTargetBoard();
            if (lastSelectedBoard != null) {
                BaseNoGui.selectBoard((TargetBoard)lastSelectedBoard);
            }
        }
        this.onBoardOrPortChange();
        this.pdeKeywords = new PdeKeywords();
        this.pdeKeywords.reload();
        this.contributionInstaller = new ContributionInstaller(BaseNoGui.getPlatform(), (SignatureVerifier)new GPGDetachedSignatureVerifier());
        this.libraryInstaller = new LibraryInstaller(BaseNoGui.getPlatform());
        parser.parseArgumentsPhase2();
        if (parser.isForceSavePrefs()) {
            PreferencesData.save();
        }
        if (parser.isInstallBoard()) {
            ContributionsIndexer indexer = new ContributionsIndexer(BaseNoGui.getSettingsFolder(), BaseNoGui.getHardwareFolder(), BaseNoGui.getPlatform(), (SignatureVerifier)new GPGDetachedSignatureVerifier());
            ConsoleProgressListener progressListener = new ConsoleProgressListener();
            List downloadedPackageIndexFiles = this.contributionInstaller.updateIndex((ProgressListener)progressListener);
            this.contributionInstaller.deleteUnknownFiles(downloadedPackageIndexFiles);
            indexer.parseIndex();
            indexer.syncWithFilesystem();
            String[] boardToInstallParts = parser.getBoardToInstall().split(":");
            ContributedPlatform selected = null;
            if (boardToInstallParts.length == 3) {
                Optional version = VersionHelper.valueOf((String)boardToInstallParts[2]);
                if (!version.isPresent()) {
                    System.out.println(I18n.format((String)I18n.tr((String)"Invalid version {0}"), (Object[])new Object[]{boardToInstallParts[2]}));
                    System.exit(1);
                }
                selected = indexer.getIndex().findPlatform(boardToInstallParts[0], boardToInstallParts[1], ((Version)version.get()).toString());
            } else if (boardToInstallParts.length == 2) {
                List platformsByName = indexer.getIndex().findPlatforms(boardToInstallParts[0], boardToInstallParts[1]);
                Collections.sort(platformsByName, new DownloadableContributionVersionComparator());
                if (!platformsByName.isEmpty()) {
                    selected = (ContributedPlatform)platformsByName.get(platformsByName.size() - 1);
                }
            }
            if (selected == null) {
                System.out.println(I18n.tr((String)"Selected board is not available"));
                System.exit(1);
            }
            ContributedPlatform installed = indexer.getInstalled(boardToInstallParts[0], boardToInstallParts[1]);
            if (!selected.isBuiltIn()) {
                this.contributionInstaller.install(selected, (ProgressListener)progressListener);
            }
            if (installed != null && !installed.isBuiltIn()) {
                this.contributionInstaller.remove(installed);
            }
            System.exit(0);
        } else if (parser.isInstallLibrary()) {
            BaseNoGui.onBoardOrPortChange();
            ConsoleProgressListener progressListener = new ConsoleProgressListener();
            this.libraryInstaller.updateIndex((ProgressListener)progressListener);
            LibrariesIndexer indexer = new LibrariesIndexer(BaseNoGui.getSettingsFolder());
            indexer.parseIndex();
            indexer.setLibrariesFolders(BaseNoGui.getLibrariesFolders());
            indexer.rescanLibraries();
            for (String library : parser.getLibraryToInstall().split(",")) {
                Optional mayInstalled;
                String[] libraryToInstallParts = library.split(":");
                ContributedLibrary selected = null;
                if (libraryToInstallParts.length == 2) {
                    Optional version = VersionHelper.valueOf((String)libraryToInstallParts[1]);
                    if (!version.isPresent()) {
                        System.out.println(I18n.format((String)I18n.tr((String)"Invalid version {0}"), (Object[])new Object[]{libraryToInstallParts[1]}));
                        System.exit(1);
                    }
                    selected = indexer.getIndex().find(libraryToInstallParts[0], ((Version)version.get()).toString());
                } else if (libraryToInstallParts.length == 1) {
                    List librariesByName = indexer.getIndex().find(libraryToInstallParts[0]);
                    Collections.sort(librariesByName, new DownloadableContributionVersionComparator());
                    if (!librariesByName.isEmpty()) {
                        selected = (ContributedLibrary)librariesByName.get(librariesByName.size() - 1);
                    }
                }
                if (selected == null) {
                    System.out.println(I18n.tr((String)"Selected library is not available"));
                    System.exit(1);
                }
                if ((mayInstalled = indexer.getIndex().getInstalled(libraryToInstallParts[0])).isPresent() && selected.isIDEBuiltIn()) {
                    System.out.println(I18n.tr((String)I18n.format((String)"Library {0} is available as built-in in the IDE.\nRemoving the other version {1} installed in the sketchbook...", (Object[])new Object[]{library, ((ContributedLibrary)mayInstalled.get()).getParsedVersion()})));
                    this.libraryInstaller.remove((ContributedLibrary)mayInstalled.get(), (ProgressListener)progressListener);
                    continue;
                }
                this.libraryInstaller.install(selected, mayInstalled, (ProgressListener)progressListener);
            }
            System.exit(0);
        } else if (parser.isVerifyOrUploadMode()) {
            PreferencesData.setBoolean((String)"build.verbose", (boolean)parser.isDoVerboseBuild());
            PreferencesData.setBoolean((String)"upload.verbose", (boolean)parser.isDoVerboseUpload());
            PreferencesData.setBoolean((String)"runtime.preserve.temp.files", (boolean)parser.isPreserveTempFiles());
            PreferencesData.setDoSave((boolean)false);
            Sketch sketch = null;
            String outputFile = null;
            try {
                splash.splashText(I18n.tr((String)"Verifying..."));
                File sketchFile = BaseNoGui.absoluteFile((String)((String)parser.getFilenames().get(0)));
                sketch = new Sketch(sketchFile);
                outputFile = new Compiler(sketch).build(progress -> {}, false);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            if (parser.isUploadMode()) {
                splash.splashText(I18n.tr((String)"Uploading..."));
                try {
                    ArrayList warnings = new ArrayList();
                    UploaderUtils uploader = new UploaderUtils();
                    boolean res = uploader.upload(sketch, null, outputFile, parser.isDoUseProgrammer(), parser.isNoUploadPort(), warnings);
                    for (String warning : warnings) {
                        System.out.println(I18n.tr((String)"Warning") + ": " + warning);
                    }
                    if (!res) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    System.out.flush();
                    System.err.flush();
                    System.err.println(I18n.tr((String)"An error occurred while uploading the sketch"));
                    System.exit(1);
                }
            }
            System.exit(0);
        } else if (parser.isGuiMode()) {
            splash.splashText(I18n.tr((String)"Starting..."));
            for (String path : parser.getFilenames()) {
                File file = Base.absoluteFile(path);
                if (OSUtils.isWindows()) {
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (!parser.isForceSavePrefs()) {
                    PreferencesData.setDoSave((boolean)true);
                }
                if (this.handleOpen(file, this.retrieveSketchLocation(".default"), false) != null) continue;
                String mess = I18n.format((String)I18n.tr((String)"Failed to open sketch: \"{0}\""), (Object[])new Object[]{path});
                if (parser.isVerifyOrUploadMode()) {
                    Base.showError(null, mess, 2);
                    continue;
                }
                Base.showWarning(null, mess, null);
            }
            this.installKeyboardInputMap();
            this.restoreSketches();
            if (this.editors.isEmpty()) {
                this.handleNew();
            }
            new Thread(new BuiltInCoreIsNewerCheck(this)).start();
            new Thread(new NewBoardListener(this)).start();
            if (PreferencesData.getBoolean((String)"update.check")) {
                new UpdateCheck(this);
                this.contributionsSelfCheck = new ContributionsSelfCheck(this, new UpdatableBoardsLibsFakeURLsHandler(this), this.contributionInstaller, this.libraryInstaller);
                new Timer(false).schedule((TimerTask)this.contributionsSelfCheck, 60000L);
            }
        } else if (parser.isNoOpMode()) {
            System.exit(0);
        } else if (parser.isGetPrefMode()) {
            BaseNoGui.dumpPrefs((CommandlineParser)parser);
        } else if (parser.isVersionMode()) {
            System.out.println("Arduino: " + BaseNoGui.VERSION_NAME_LONG);
            System.exit(0);
        }
    }

    private void installKeyboardInputMap() {
        UIManager.put("RSyntaxTextAreaUI.inputMap", (Object)new SketchTextAreaDefaultInputMap());
    }

    protected boolean restoreSketches() throws Exception {
        int count = PreferencesData.getInteger((String)"last.sketch.count");
        int opened = 0;
        for (int i = count - 1; i >= 0; --i) {
            int[] location;
            String path = PreferencesData.get((String)("last.sketch" + i + ".path"));
            if (path == null) continue;
            if (BaseNoGui.getPortableFolder() != null && !new File(path).isAbsolute()) {
                File absolute = new File(BaseNoGui.getPortableFolder(), path);
                try {
                    path = absolute.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.handleOpen(new File(path), location = this.retrieveSketchLocation("" + i), this.nextEditorLocation(), false, false) == null) continue;
            ++opened;
        }
        return opened > 0;
    }

    protected void storeScreenDimensions() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        PreferencesData.setInteger((String)"last.screen.width", (int)screen.width);
        PreferencesData.setInteger((String)"last.screen.height", (int)screen.height);
    }

    protected void storeSketches() {
        if (this.editors.size() == 1) {
            this.storeSketchLocation(this.editors.get(0), ".default");
        }
        String untitledPath = untitledFolder.getAbsolutePath();
        LinkedList<Editor> reversedEditors = new LinkedList<Editor>(this.editors);
        Collections.reverse(reversedEditors);
        int index = 0;
        for (Editor editor : reversedEditors) {
            Sketch sketch = editor.getSketch();
            String path = sketch.getMainFilePath();
            if (path.startsWith(untitledPath) && !sketch.isModified()) continue;
            this.storeSketchLocation(editor, "" + index);
            ++index;
        }
        PreferencesData.setInteger((String)"last.sketch.count", (int)index);
    }

    private void storeSketchLocation(Editor editor, String index) {
        String path = editor.getSketch().getMainFilePath();
        String loc = StringUtils.join((int[])editor.getPlacement(), (char)',');
        PreferencesData.set((String)("last.sketch" + index + ".path"), (String)path);
        PreferencesData.set((String)("last.sketch" + index + ".location"), (String)loc);
    }

    private int[] retrieveSketchLocation(String index) {
        if (PreferencesData.get((String)"last.screen.height") == null) {
            return this.defaultEditorLocation();
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int screenW = PreferencesData.getInteger((String)"last.screen.width");
        int screenH = PreferencesData.getInteger((String)"last.screen.height");
        if (screen.width != screenW || screen.height != screenH) {
            return this.defaultEditorLocation();
        }
        String locationStr = PreferencesData.get((String)("last.sketch" + index + ".location"));
        if (locationStr == null) {
            return this.defaultEditorLocation();
        }
        return PApplet.parseInt((String[])PApplet.split((String)locationStr, (char)','));
    }

    protected void storeRecentSketches(SketchController sketch) {
        if (sketch.isUntitled()) {
            return;
        }
        LinkedHashSet<String> sketches = new LinkedHashSet<String>();
        sketches.add(sketch.getSketch().getMainFilePath());
        sketches.addAll(PreferencesData.getCollection((String)"recent.sketches"));
        PreferencesData.setCollection((String)"recent.sketches", sketches);
    }

    protected void removeRecentSketchPath(String path) {
        LinkedList sketches = new LinkedList(PreferencesData.getCollection((String)"recent.sketches"));
        sketches.remove(path);
        PreferencesData.setCollection((String)"recent.sketches", sketches);
    }

    protected void handleActivated(Editor whichEditor) {
        this.activeEditor = whichEditor;
        this.activeEditor.rebuildRecentSketchesMenu();
        if (PreferencesData.getBoolean((String)"editor.external")) {
            try {
                if (this.activeEditor.getSketch().reload()) {
                    this.activeEditor.createTabs();
                } else {
                    this.activeEditor.getCurrentTab().activated();
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    protected int[] defaultEditorLocation() {
        int defaultWidth = PreferencesData.getInteger((String)"editor.window.width.default");
        int defaultHeight = PreferencesData.getInteger((String)"editor.window.height.default");
        Rectangle screen = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        return new int[]{(screen.width - defaultWidth) / 2, (screen.height - defaultHeight) / 2, defaultWidth, defaultHeight, 0};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] nextEditorLocation() {
        if (this.activeEditor == null) {
            return this.defaultEditorLocation();
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        List<Editor> list = this.editors;
        synchronized (list) {
            int[] location = this.activeEditor.getPlacement();
            int OVER = 50;
            location[0] = location[0] + 50;
            location[1] = location[1] + 50;
            if (location[0] == 50 || location[2] == 50 || location[0] + location[2] > screen.width || location[1] + location[3] > screen.height) {
                int[] l = this.defaultEditorLocation();
                l[0] = (int)((double)l[0] * (Math.random() * 2.0));
                l[1] = (int)((double)l[1] * (Math.random() * 2.0));
                return l;
            }
            return location;
        }
    }

    protected File createNewUntitled() throws IOException {
        File newbieDir = null;
        String newbieName = null;
        File sketchbookDir = BaseNoGui.getSketchbookFolder();
        File newbieParentDir = untitledFolder;
        int index = 0;
        Calendar cal = Calendar.getInstance();
        int day = cal.get(5);
        int month = cal.get(2);
        String purty = this.months[month] + PApplet.nf((int)day, (int)2);
        do {
            if (index == 676) {
                if (!this.breakTime) {
                    Base.showWarning(I18n.tr((String)"Time for a Break"), I18n.tr((String)"You've reached the limit for auto naming of new sketches\nfor the day. How about going for a walk instead?"), null);
                    this.breakTime = true;
                } else {
                    Base.showWarning(I18n.tr((String)"Sunshine"), I18n.tr((String)"No really, time for some fresh air for you."), null);
                }
                return null;
            }
            int multiples = index / 26;
            newbieName = multiples > 0 ? (char)(97 + (multiples - 1)) + "" + (char)(97 + index % 26) + "" : (char)(97 + index) + "";
            newbieName = "sketch_" + purty + newbieName;
            newbieDir = new File(newbieParentDir, newbieName);
            ++index;
        } while (newbieDir.exists() || new File(sketchbookDir, newbieName).exists());
        newbieDir.mkdirs();
        File newbieFile = new File(newbieDir, newbieName + ".ino");
        if (!newbieFile.createNewFile()) {
            throw new IOException();
        }
        FileUtils.copyFile((File)new File(Base.getContentFile("examples"), "01.Basics" + File.separator + "BareMinimum" + File.separator + "BareMinimum.ino"), (File)newbieFile);
        return newbieFile;
    }

    public void handleNew() throws Exception {
        block3: {
            try {
                File file = this.createNewUntitled();
                if (file != null) {
                    this.handleOpen(file, true);
                }
            }
            catch (IOException e) {
                if (this.activeEditor == null) break block3;
                this.activeEditor.statusError(e);
            }
        }
    }

    public void handleOpenPrompt() throws Exception {
        FileDialog fd = new FileDialog((Frame)this.activeEditor, I18n.tr((String)"Open an Arduino sketch..."), 0);
        File lastFolder = new File(PreferencesData.get((String)"last.folder", (String)BaseNoGui.getSketchbookFolder().getAbsolutePath()));
        if (lastFolder.exists() && lastFolder.isFile()) {
            lastFolder = lastFolder.getParentFile();
        }
        fd.setDirectory(lastFolder.getAbsolutePath());
        fd.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ino") || name.toLowerCase().endsWith(".pde");
            }
        });
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return;
        }
        File inputFile = new File(directory, filename);
        PreferencesData.set((String)"last.folder", (String)inputFile.getAbsolutePath());
        this.handleOpen(inputFile);
    }

    public Editor handleOpen(File file) throws Exception {
        return this.handleOpen(file, false);
    }

    public Editor handleOpen(File file, boolean untitled) throws Exception {
        return this.handleOpen(file, this.nextEditorLocation(), untitled);
    }

    protected Editor handleOpen(File file, int[] location, boolean untitled) throws Exception {
        return this.handleOpen(file, location, location, true, untitled);
    }

    protected Editor handleOpen(File file, int[] storedLocation, int[] defaultLocation, boolean storeOpenedSketches, boolean untitled) throws Exception {
        if (!file.exists()) {
            return null;
        }
        for (Editor editor : this.editors) {
            if (!editor.getSketch().getPrimaryFile().getFile().equals(file)) continue;
            editor.toFront();
            return editor;
        }
        Editor editor = new Editor(this, file, storedLocation, defaultLocation, BaseNoGui.getPlatform());
        if (editor.getSketchController() == null) {
            return null;
        }
        editor.untitled = untitled;
        this.editors.add(editor);
        if (storeOpenedSketches) {
            this.storeSketches();
            this.storeRecentSketches(editor.getSketchController());
            this.rebuildRecentSketchesMenuItems();
            PreferencesData.save();
        }
        SwingUtilities.invokeLater(() -> editor.setVisible(true));
        return editor;
    }

    protected void rebuildRecentSketchesMenuItems() {
        LinkedHashSet<File> recentSketches = new LinkedHashSet<File>(){

            @Override
            public boolean add(File file) {
                if (this.size() >= 10) {
                    return false;
                }
                return super.add(file);
            }
        };
        for (String path : PreferencesData.getCollection((String)"recent.sketches")) {
            File file = new File(path);
            if (!file.exists()) continue;
            recentSketches.add(file);
        }
        this.recentSketchesMenuItems.clear();
        for (final File recentSketch : recentSketches) {
            JMenuItem recentSketchMenuItem = new JMenuItem(recentSketch.getParentFile().getName());
            recentSketchMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Base.this.handleOpen(recentSketch);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.recentSketchesMenuItems.add(recentSketchMenuItem);
        }
    }

    public boolean handleClose(Editor editor) {
        if (this.editors.size() == 1) {
            if (!this.handleQuit()) {
                return false;
            }
            editor.setVisible(false);
            this.editors.remove(editor);
        } else {
            if (!editor.checkModified()) {
                return false;
            }
            editor.setVisible(false);
            editor.dispose();
            this.editors.remove(editor);
        }
        return true;
    }

    public boolean handleQuit() {
        this.storeScreenDimensions();
        this.storeSketches();
        try {
            Editor.serialMonitor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        UploaderUtils uploaderInstance = new UploaderUtils();
        Uploader uploader = uploaderInstance.getUploaderByPreferences(false);
        if (uploader != null) {
            if (Uploader.programmerPid != null) {
                if (Uploader.programmerPid.isAlive()) {
                    Uploader.programmerPid.destroyForcibly();
                }
            }
        }
        if (this.handleQuitEach()) {
            PreferencesData.save();
            if (!OSUtils.isMacOS()) {
                System.exit(0);
            }
            return true;
        }
        return false;
    }

    protected boolean handleQuitEach() {
        for (Editor editor : this.editors) {
            if (editor.checkModified()) continue;
            return false;
        }
        return true;
    }

    public void rebuildSketchbookMenus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Base.this.rebuildSketchbookMenu(Editor.sketchbookMenu);
                Base.this.rebuildToolbarMenu(Editor.toolbarMenu);
            }
        });
    }

    protected void rebuildToolbarMenu(JMenu menu) {
        boolean found;
        menu.removeAll();
        JMenuItem item = Editor.newJMenuItem(I18n.tr((String)"Open..."), 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Base.this.handleOpenPrompt();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        menu.add(item);
        menu.addSeparator();
        boolean sketches = this.addSketches(menu, BaseNoGui.getSketchbookFolder());
        if (sketches) {
            menu.addSeparator();
        }
        if (found = this.addSketches(menu, BaseNoGui.getExamplesFolder())) {
            menu.addSeparator();
        }
    }

    protected void rebuildSketchbookMenu(JMenu menu) {
        JMenu hardwareMenu;
        menu.removeAll();
        this.addSketches(menu, BaseNoGui.getSketchbookFolder());
        JMenu librariesMenu = JMenuUtils.findSubMenuWithLabel(menu, "libraries");
        if (librariesMenu != null) {
            menu.remove(librariesMenu);
        }
        if ((hardwareMenu = JMenuUtils.findSubMenuWithLabel(menu, "hardware")) != null) {
            menu.remove(hardwareMenu);
        }
    }

    private LibraryList getSortedLibraries() {
        LibraryList installedLibraries = BaseNoGui.librariesIndexer.getInstalledLibraries();
        Collections.sort(installedLibraries, new LibraryOfSameTypeComparator());
        return installedLibraries;
    }

    public void rebuildImportMenu(JMenu importMenu) {
        if (importMenu == null) {
            return;
        }
        importMenu.removeAll();
        JMenuItem menu = new JMenuItem(I18n.tr((String)"Manage Libraries..."));
        menu.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        menu.addActionListener(e -> this.openLibraryManager("", ""));
        importMenu.add(menu);
        importMenu.addSeparator();
        JMenuItem addLibraryMenuItem = new JMenuItem(I18n.tr((String)"Add .ZIP Library..."));
        addLibraryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.this.handleAddLibrary();
                BaseNoGui.librariesIndexer.rescanLibraries();
                Base.this.onBoardOrPortChange();
                Base.this.rebuildImportMenu(Editor.importMenu);
                Base.this.rebuildExamplesMenu(Editor.examplesMenu);
            }
        });
        importMenu.add(addLibraryMenuItem);
        importMenu.addSeparator();
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        if (targetPlatform != null) {
            LibraryList libs = this.getSortedLibraries();
            String lastLibType = null;
            for (UserLibrary lib : libs) {
                String libType = (String)lib.getTypes().get(0);
                if (!libType.equals(lastLibType)) {
                    if (lastLibType != null) {
                        importMenu.addSeparator();
                    }
                    lastLibType = libType;
                    JMenuItem platformItem = new JMenuItem(I18n.format((String)I18n.tr((String)"{0} libraries"), (Object[])new Object[]{I18n.tr((String)lastLibType)}));
                    platformItem.setEnabled(false);
                    importMenu.add(platformItem);
                }
                AbstractAction action = new AbstractAction(lib.getName()){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        UserLibrary l = (UserLibrary)this.getValue("library");
                        try {
                            Base.this.activeEditor.getSketchController().importLibrary(l);
                        }
                        catch (IOException e) {
                            Base.showWarning(I18n.tr((String)"Error"), I18n.format((String)"Unable to list header files in {0}", (Object[])new Object[]{l.getSrcFolder()}), e);
                        }
                    }
                };
                action.putValue("library", lib);
                JMenuItem item = new JMenuItem(action);
                item.putClientProperty("library", lib);
                importMenu.add(item);
            }
        }
    }

    public void rebuildExamplesMenu(JMenu menu) {
        if (menu == null) {
            return;
        }
        menu.removeAll();
        JMenuItem label = new JMenuItem(I18n.tr((String)"Built-in Examples"));
        label.setEnabled(false);
        menu.add(label);
        boolean found = this.addSketches(menu, BaseNoGui.getExamplesFolder());
        if (found) {
            menu.addSeparator();
        }
        String boardId = null;
        String referencedPlatformName = null;
        String myArch = null;
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        if (targetPlatform != null) {
            String refcore;
            TargetPlatform referencedPlatform;
            myArch = targetPlatform.getId();
            boardId = BaseNoGui.getTargetBoard().getName();
            String core = BaseNoGui.getBoardPreferences().get("build.core", "arduino");
            if (core.contains(":") && (referencedPlatform = BaseNoGui.getTargetPlatform((String)(refcore = core.split(":")[0]), (String)myArch)) != null) {
                referencedPlatformName = (String)referencedPlatform.getPreferences().get((Object)"name");
            }
        }
        LibraryList allLibraries = BaseNoGui.librariesIndexer.getInstalledLibraries();
        LibraryList ideLibs = new LibraryList();
        LibraryList retiredIdeLibs = new LibraryList();
        LibraryList platformLibs = new LibraryList();
        LibraryList referencedPlatformLibs = new LibraryList();
        LibraryList sketchbookLibs = new LibraryList();
        LibraryList sketchbookIncompatibleLibs = new LibraryList();
        LibraryList otherLibs = new LibraryList();
        for (Object lib : allLibraries) {
            UserLibraryFolder.Location location = lib.getLocation();
            List arch = lib.getArchitectures();
            boolean compatible = myArch == null || arch == null || arch.contains("*") ? true : arch.contains(myArch);
            if (location == UserLibraryFolder.Location.IDE_BUILTIN) {
                if (!compatible) continue;
                if (lib.getTypes().contains("Retired")) {
                    retiredIdeLibs.add(lib);
                    continue;
                }
                ideLibs.add(lib);
                continue;
            }
            if (location == UserLibraryFolder.Location.CORE) {
                platformLibs.add(lib);
                continue;
            }
            if (location == UserLibraryFolder.Location.REFERENCED_CORE) {
                referencedPlatformLibs.add(lib);
                continue;
            }
            if (location == UserLibraryFolder.Location.SKETCHBOOK) {
                if (compatible) {
                    if (!lib.getTypes().isEmpty() && lib.getTypes().contains("Arduino") && lib.getArchitectures().contains("*")) {
                        ideLibs.add(lib);
                        continue;
                    }
                    sketchbookLibs.add(lib);
                    continue;
                }
                sketchbookIncompatibleLibs.add(lib);
                continue;
            }
            otherLibs.add(lib);
        }
        if (!ideLibs.isEmpty()) {
            ideLibs.sort();
            label = new JMenuItem(I18n.tr((String)"Examples for any board"));
            label.setEnabled(false);
            menu.add(label);
        }
        for (Object lib : ideLibs) {
            this.addSketchesSubmenu(menu, (UserLibrary)lib);
        }
        if (!retiredIdeLibs.isEmpty()) {
            retiredIdeLibs.sort();
            JMenu retired = new JMenu(I18n.tr((String)"RETIRED"));
            menu.add(retired);
            for (UserLibrary lib : retiredIdeLibs) {
                this.addSketchesSubmenu(retired, lib);
            }
        }
        if (!platformLibs.isEmpty()) {
            menu.addSeparator();
            platformLibs.sort();
            label = new JMenuItem(I18n.format((String)I18n.tr((String)"Examples for {0}"), (Object[])new Object[]{boardId}));
            label.setEnabled(false);
            menu.add(label);
            for (Object lib : platformLibs) {
                this.addSketchesSubmenu(menu, (UserLibrary)lib);
            }
        }
        if (!referencedPlatformLibs.isEmpty()) {
            menu.addSeparator();
            referencedPlatformLibs.sort();
            label = new JMenuItem(I18n.format((String)I18n.tr((String)"Examples for {0}"), (Object[])new Object[]{referencedPlatformName}));
            label.setEnabled(false);
            menu.add(label);
            for (Object lib : referencedPlatformLibs) {
                this.addSketchesSubmenu(menu, (UserLibrary)lib);
            }
        }
        if (!sketchbookLibs.isEmpty()) {
            menu.addSeparator();
            sketchbookLibs.sort();
            label = new JMenuItem(I18n.tr((String)"Examples from Custom Libraries"));
            label.setEnabled(false);
            menu.add(label);
            for (Object lib : sketchbookLibs) {
                this.addSketchesSubmenu(menu, (UserLibrary)lib);
            }
        }
        if (!sketchbookIncompatibleLibs.isEmpty()) {
            sketchbookIncompatibleLibs.sort();
            JMenu incompatible = new JMenu(I18n.tr((String)"INCOMPATIBLE"));
            MenuScroller.setScrollerFor(incompatible);
            menu.add(incompatible);
            for (UserLibrary lib : sketchbookIncompatibleLibs) {
                this.addSketchesSubmenu(incompatible, lib);
            }
        }
        if (!otherLibs.isEmpty()) {
            menu.addSeparator();
            otherLibs.sort();
            label = new JMenuItem(I18n.tr((String)"Examples from Other Libraries"));
            label.setEnabled(false);
            menu.add(label);
            for (Object lib : otherLibs) {
                this.addSketchesSubmenu(menu, (UserLibrary)lib);
            }
        }
    }

    public void onBoardOrPortChange() {
        BaseNoGui.onBoardOrPortChange();
        TargetPlatform tp = BaseNoGui.getTargetPlatform();
        if (tp != null) {
            String platformFolder = tp.getFolder().getAbsolutePath();
            if (priorPlatformFolder == null || !priorPlatformFolder.equals(platformFolder) || newLibraryImported) {
                this.pdeKeywords = new PdeKeywords();
                this.pdeKeywords.reload();
                priorPlatformFolder = platformFolder;
                newLibraryImported = false;
                for (Editor editor : this.editors) {
                    editor.updateKeywords(this.pdeKeywords);
                }
            }
        }
        for (Editor editor : this.editors) {
            editor.onBoardOrPortChange();
        }
    }

    public void openLibraryManager(final String filterText, final String dropdownItem) {
        if (this.contributionsSelfCheck != null) {
            this.contributionsSelfCheck.cancel();
        }
        LibraryManagerUI managerUI = new LibraryManagerUI(this.activeEditor, this.libraryInstaller){

            @Override
            protected void onIndexesUpdated() throws Exception {
                BaseNoGui.initPackages();
                Base.this.rebuildBoardsMenu();
                Base.this.rebuildProgrammerMenu();
                Base.this.onBoardOrPortChange();
                this.updateUI();
                if (StringUtils.isNotEmpty((CharSequence)dropdownItem)) {
                    this.selectDropdownItemByClassName(dropdownItem);
                }
                if (StringUtils.isNotEmpty((CharSequence)filterText)) {
                    this.setFilterText(filterText);
                }
            }
        };
        managerUI.setLocationRelativeTo(this.activeEditor);
        managerUI.updateUI();
        managerUI.setVisible(true);
        newLibraryImported = true;
        this.onBoardOrPortChange();
        this.rebuildImportMenu(Editor.importMenu);
        this.rebuildExamplesMenu(Editor.examplesMenu);
    }

    public void openBoardsManager(final String filterText, final String dropdownItem) throws Exception {
        if (this.contributionsSelfCheck != null) {
            this.contributionsSelfCheck.cancel();
        }
        ContributionManagerUI managerUI = new ContributionManagerUI(this.activeEditor, this.contributionInstaller){

            @Override
            protected void onIndexesUpdated() throws Exception {
                BaseNoGui.initPackages();
                Base.this.rebuildBoardsMenu();
                Base.this.rebuildProgrammerMenu();
                this.updateUI();
                if (StringUtils.isNotEmpty((CharSequence)dropdownItem)) {
                    this.selectDropdownItemByClassName(dropdownItem);
                }
                if (StringUtils.isNotEmpty((CharSequence)filterText)) {
                    this.setFilterText(filterText);
                }
            }
        };
        managerUI.setLocationRelativeTo(this.activeEditor);
        managerUI.updateUI();
        managerUI.setVisible(true);
        BaseNoGui.initPackages();
        this.rebuildBoardsMenu();
        this.rebuildProgrammerMenu();
        this.onBoardOrPortChange();
    }

    public void rebuildBoardsMenu() throws Exception {
        this.boardsCustomMenus = new LinkedList<JMenu>();
        JMenu boardMenu = new JMenu(I18n.tr((String)"Board"));
        boardMenu.putClientProperty("removeOnWindowDeactivation", true);
        MenuScroller.setScrollerFor(boardMenu).setTopFixedCount(1);
        boardMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Boards Manager...")){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                String filterText = "";
                String dropdownItem = "";
                if (actionevent instanceof Event) {
                    filterText = ((Event)actionevent).getPayload().get("filterText").toString();
                    dropdownItem = ((Event)actionevent).getPayload().get("dropdownItem").toString();
                }
                try {
                    Base.this.openBoardsManager(filterText, dropdownItem);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        this.boardsCustomMenus.add(boardMenu);
        if (BaseNoGui.packages.size() == 0) {
            return;
        }
        boardMenu.add(new JSeparator());
        LinkedHashSet customMenusTitles = new LinkedHashSet();
        for (TargetPackage targetPackage : BaseNoGui.packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.platforms()) {
                customMenusTitles.addAll(targetPlatform.getCustomMenus().values());
            }
        }
        for (String customMenuTitle : customMenusTitles) {
            JMenu customMenu = new JMenu(I18n.tr((String)customMenuTitle));
            customMenu.putClientProperty("removeOnWindowDeactivation", true);
            this.boardsCustomMenus.add(customMenu);
        }
        LinkedList<JMenuItem> menuItemsToClickAfterStartup = new LinkedList<JMenuItem>();
        ButtonGroup boardsButtonGroup = new ButtonGroup();
        HashMap<String, ButtonGroup> buttonGroupsMap = new HashMap<String, ButtonGroup>();
        boolean first = true;
        for (TargetPackage targetPackage : BaseNoGui.packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.platforms()) {
                if (!first) {
                    boardMenu.add(new JSeparator());
                }
                first = false;
                String platformLabel = (String)targetPlatform.getPreferences().get((Object)"name");
                if (platformLabel != null && !targetPlatform.getBoards().isEmpty()) {
                    JMenuItem menuLabel = new JMenuItem(I18n.tr((String)platformLabel));
                    menuLabel.setEnabled(false);
                    boardMenu.add(menuLabel);
                }
                for (TargetBoard board : targetPlatform.getBoards().values()) {
                    if (board.getPreferences().get((Object)"hide") != null) continue;
                    JRadioButtonMenuItem item = this.createBoardMenusAndCustomMenus(this.boardsCustomMenus, menuItemsToClickAfterStartup, buttonGroupsMap, board, targetPlatform, targetPackage);
                    boardMenu.add(item);
                    boardsButtonGroup.add(item);
                }
            }
        }
        if (menuItemsToClickAfterStartup.isEmpty()) {
            menuItemsToClickAfterStartup.add(Base.selectFirstEnabledMenuItem(boardMenu));
        }
        for (JMenuItem menuItemToClick : menuItemsToClickAfterStartup) {
            menuItemToClick.setSelected(true);
            menuItemToClick.getAction().actionPerformed(new ActionEvent(this, -1, ""));
        }
    }

    private JRadioButtonMenuItem createBoardMenusAndCustomMenus(final List<JMenu> boardsCustomMenus, List<JMenuItem> menuItemsToClickAfterStartup, Map<String, ButtonGroup> buttonGroupsMap, TargetBoard board, TargetPlatform targetPlatform, TargetPackage targetPackage) throws Exception {
        String selPackage = PreferencesData.get((String)"target_package");
        String selPlatform = PreferencesData.get((String)"target_platform");
        String selBoard = PreferencesData.get((String)"board");
        String boardId = board.getId();
        String packageName = targetPackage.getId();
        String platformName = targetPlatform.getId();
        AbstractAction action = new AbstractAction(board.getName()){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                BaseNoGui.selectBoard((TargetBoard)((TargetBoard)this.getValue("b")));
                Base.this.filterVisibilityOfSubsequentBoardMenus(boardsCustomMenus, (TargetBoard)this.getValue("b"), 1);
                Base.this.onBoardOrPortChange();
                Base.this.rebuildImportMenu(Editor.importMenu);
                Base.this.rebuildExamplesMenu(Editor.examplesMenu);
            }
        };
        action.putValue("b", board);
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
        if (selBoard.equals(boardId) && selPackage.equals(packageName) && selPlatform.equals(platformName)) {
            menuItemsToClickAfterStartup.add(item);
        }
        PreferencesMap customMenus = targetPlatform.getCustomMenus();
        for (final String menuId : customMenus.keySet()) {
            String title = (String)customMenus.get((Object)menuId);
            JMenu menu = this.getBoardCustomMenu(I18n.tr((String)title));
            if (!board.hasMenu(menuId)) continue;
            PreferencesMap boardCustomMenu = board.getMenuLabels(menuId);
            for (String customMenuOption : boardCustomMenu.keySet()) {
                AbstractAction subAction = new AbstractAction(I18n.tr((String)((String)boardCustomMenu.get((Object)customMenuOption)))){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PreferencesData.set((String)("custom_" + menuId), (String)(((TargetBoard)this.getValue("board")).getId() + "_" + this.getValue("custom_menu_option")));
                        Base.this.onBoardOrPortChange();
                    }
                };
                subAction.putValue("board", board);
                subAction.putValue("custom_menu_option", customMenuOption);
                if (!buttonGroupsMap.containsKey(menuId)) {
                    buttonGroupsMap.put(menuId, new ButtonGroup());
                }
                JRadioButtonMenuItem subItem = new JRadioButtonMenuItem(subAction);
                menu.add(subItem);
                buttonGroupsMap.get(menuId).add(subItem);
                String selectedCustomMenuEntry = PreferencesData.get((String)("custom_" + menuId));
                if (!selBoard.equals(boardId) || !(boardId + "_" + customMenuOption).equals(selectedCustomMenuEntry)) continue;
                menuItemsToClickAfterStartup.add(subItem);
            }
        }
        return item;
    }

    private void filterVisibilityOfSubsequentBoardMenus(List<JMenu> boardsCustomMenus, TargetBoard board, int fromIndex) {
        for (int i = fromIndex; i < boardsCustomMenus.size(); ++i) {
            JMenuItem visibleSelectedOrFirstMenuItem;
            JMenu menu = boardsCustomMenus.get(i);
            for (int m = 0; m < menu.getItemCount(); ++m) {
                JMenuItem menuItem = menu.getItem(m);
                menuItem.setVisible(menuItem.getAction().getValue("board").equals(board));
            }
            menu.setVisible(Base.ifThereAreVisibleItemsOn(menu));
            if (!menu.isVisible() || (visibleSelectedOrFirstMenuItem = Base.selectVisibleSelectedOrFirstMenuItem(menu)).isSelected()) continue;
            visibleSelectedOrFirstMenuItem.setSelected(true);
            visibleSelectedOrFirstMenuItem.getAction().actionPerformed(null);
        }
    }

    private static boolean ifThereAreVisibleItemsOn(JMenu menu) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (!menu.getItem(i).isVisible()) continue;
            return true;
        }
        return false;
    }

    private JMenu getBoardCustomMenu(String label) throws Exception {
        for (JMenu menu : this.boardsCustomMenus) {
            if (!label.equals(menu.getText())) continue;
            return menu;
        }
        throw new Exception("Custom menu not found!");
    }

    public List<JMenuItem> getProgrammerMenus() {
        return this.programmerMenus;
    }

    private static JMenuItem selectVisibleSelectedOrFirstMenuItem(JMenu menu) {
        JMenuItem firstVisible = null;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null || !item.isVisible()) continue;
            if (item.isSelected()) {
                return item;
            }
            if (firstVisible != null) continue;
            firstVisible = item;
        }
        if (firstVisible != null) {
            return firstVisible;
        }
        throw new IllegalStateException("Menu has no enabled items");
    }

    private static JMenuItem selectFirstEnabledMenuItem(JMenu menu) {
        for (int i = 1; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null || !item.isEnabled()) continue;
            return item;
        }
        throw new IllegalStateException("Menu has no enabled items");
    }

    public void rebuildProgrammerMenu() {
        this.programmerMenus = new LinkedList<JMenuItem>();
        ButtonGroup group = new ButtonGroup();
        for (TargetPackage targetPackage : BaseNoGui.packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.platforms()) {
                for (String programmer : targetPlatform.getProgrammers().keySet()) {
                    String id = targetPackage.getId() + ":" + programmer;
                    AbstractAction action = new AbstractAction((String)targetPlatform.getProgrammer(programmer).get((Object)"name")){

                        @Override
                        public void actionPerformed(ActionEvent actionevent) {
                            PreferencesData.set((String)"programmer", (String)("" + this.getValue("id")));
                        }
                    };
                    action.putValue("id", id);
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
                    if (PreferencesData.get((String)"programmer").equals(id)) {
                        item.setSelected(true);
                    }
                    group.add(item);
                    this.programmerMenus.add(item);
                }
            }
        }
    }

    protected boolean addSketches(JMenu menu, File folder) {
        if (folder == null) {
            return false;
        }
        if (!folder.isDirectory()) {
            return false;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return false;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file.getName().compareToIgnoreCase(file2.getName());
            }
        });
        boolean ifound = false;
        for (File subfolder : files) {
            if (FileUtils.isSCCSOrHiddenFile((File)subfolder) || !subfolder.isDirectory() || !this.addSketchesSubmenu(menu, subfolder.getName(), subfolder)) continue;
            ifound = true;
        }
        return ifound;
    }

    private boolean addSketchesSubmenu(JMenu menu, UserLibrary lib) {
        return this.addSketchesSubmenu(menu, lib.getName(), lib.getInstalledFolder());
    }

    private boolean addSketchesSubmenu(JMenu menu, String name, File folder) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = e.getActionCommand();
                File file = new File(path);
                if (file.exists()) {
                    try {
                        Base.this.handleOpen(file);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    Base.showWarning(I18n.tr((String)"Sketch Does Not Exist"), I18n.tr((String)"The selected sketch no longer exists.\nYou may need to restart Arduino to update\nthe sketchbook menu."), null);
                }
            }
        };
        File entry = new File(folder, name + ".ino");
        if (!entry.exists() && new File(folder, name + ".pde").exists()) {
            entry = new File(folder, name + ".pde");
        }
        if (entry.exists()) {
            if (!BaseNoGui.isSanitaryName((String)name)) {
                if (!this.builtOnce) {
                    String complaining = I18n.format((String)I18n.tr((String)"The sketch \"{0}\" cannot be used.\nSketch names must contain only basic letters and numbers\n(ASCII-only with no spaces, and it cannot start with a number).\nTo get rid of this message, remove the sketch from\n{1}"), (Object[])new Object[]{name, entry.getAbsolutePath()});
                    Base.showMessage(I18n.tr((String)"Ignoring sketch with bad name"), complaining);
                }
                return false;
            }
            JMenuItem item = new JMenuItem(name);
            item.addActionListener(listener);
            item.setActionCommand(entry.getAbsolutePath());
            menu.add(item);
            return true;
        }
        if (folder.getName().equals("examples")) {
            return this.addSketches(menu, folder);
        }
        JMenu submenu = new JMenu(name);
        boolean found = this.addSketches(submenu, folder);
        if (found) {
            menu.add(submenu);
            MenuScroller.setScrollerFor(submenu);
        }
        return found;
    }

    protected void addLibraries(JMenu menu, LibraryList libs) throws IOException {
        LibraryList list = new LibraryList(libs);
        list.sort();
        for (UserLibrary lib : list) {
            AbstractAction action = new AbstractAction(lib.getName()){

                @Override
                public void actionPerformed(ActionEvent event) {
                    UserLibrary l = (UserLibrary)this.getValue("library");
                    try {
                        Base.this.activeEditor.getSketchController().importLibrary(l);
                    }
                    catch (IOException e) {
                        Base.showWarning(I18n.tr((String)"Error"), I18n.format((String)"Unable to list header files in {0}", (Object[])new Object[]{l.getSrcFolder()}), e);
                    }
                }
            };
            action.putValue("library", lib);
            JMenuItem item = new JMenuItem(action);
            item.putClientProperty("library", lib);
            menu.add(item);
        }
    }

    public static String[] headerListFromIncludePath(File path) throws IOException {
        String[] list = path.list((FilenameFilter)new OnlyFilesWithExtension(new String[]{".h"}));
        if (list == null) {
            throw new IOException();
        }
        return list;
    }

    public void handleAbout() {
        final Image image = Theme.getLibImage("about", this.activeEditor, Theme.scale(475), Theme.scale(300));
        final Window window = new Window(this.activeEditor){

            @Override
            public void paint(Graphics graphics) {
                Graphics2D g = Theme.setupGraphics2D(graphics);
                g.drawImage(image, 0, 0, null);
                Font f = new Font("SansSerif", 0, Theme.scale(11));
                g.setFont(f);
                g.setColor(new Color(0, 151, 156));
                g.drawString(BaseNoGui.VERSION_NAME_LONG, Theme.scale(33), Theme.scale(20));
            }
        };
        window.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                window.dispose();
            }
        });
        int w = image.getWidth(this.activeEditor);
        int h = image.getHeight(this.activeEditor);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        window.setBounds((screen.width - w) / 2, (screen.height - h) / 2, w, h);
        window.setLocationRelativeTo(this.activeEditor);
        window.setVisible(true);
    }

    public void handlePrefs() {
        Preferences dialog = new Preferences((Window)this.activeEditor, this);
        if (this.activeEditor != null) {
            dialog.setLocationRelativeTo(this.activeEditor);
        }
        dialog.setVisible(true);
    }

    public void handleFontSizeChange(int change) {
        Object[] pieces = PreferencesData.get((String)"editor.font").split(",");
        try {
            int newSize = Integer.parseInt(pieces[2]) + change;
            if (newSize < 4) {
                newSize = 4;
            }
            pieces[2] = String.valueOf(newSize);
        }
        catch (NumberFormatException e) {
            return;
        }
        PreferencesData.set((String)"editor.font", (String)StringUtils.join((Object[])pieces, (char)','));
        this.getEditors().forEach(Editor::applyPreferences);
    }

    public void addEditorFontResizeListeners(Component comp) {
        this.addEditorFontResizeMouseWheelListener(comp);
        this.addEditorFontResizeKeyListener(comp);
    }

    public void addEditorFontResizeMouseWheelListener(Component comp) {
        if (this.editorFontResizeMouseWheelListener == null) {
            this.editorFontResizeMouseWheelListener = e -> {
                if (e.isControlDown()) {
                    if (e.getWheelRotation() < 0) {
                        this.handleFontSizeChange(1);
                    } else {
                        this.handleFontSizeChange(-1);
                    }
                } else {
                    e.getComponent().getParent().dispatchEvent(e);
                }
            };
        }
        comp.addMouseWheelListener(this.editorFontResizeMouseWheelListener);
    }

    public void addEditorFontResizeKeyListener(Component comp) {
        if (this.editorFontResizeKeyListener == null) {
            this.editorFontResizeKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getModifiersEx() == 128 || e.getModifiersEx() == 192) {
                        switch (e.getKeyCode()) {
                            case 61: 
                            case 521: {
                                Base.this.handleFontSizeChange(1);
                                break;
                            }
                            case 45: {
                                if (e.isShiftDown()) break;
                                Base.this.handleFontSizeChange(-1);
                            }
                        }
                    }
                }
            };
        }
        comp.addKeyListener(this.editorFontResizeKeyListener);
    }

    public List<JMenu> getBoardsCustomMenus() {
        return this.boardsCustomMenus;
    }

    public File getDefaultSketchbookFolderOrPromptForIt() {
        File sketchbookFolder = BaseNoGui.getDefaultSketchbookFolder();
        if (sketchbookFolder == null && !Base.isCommandLine()) {
            sketchbookFolder = Base.promptSketchbookLocation();
        }
        boolean result = true;
        if (!sketchbookFolder.exists()) {
            result = sketchbookFolder.mkdirs();
        }
        if (!result) {
            Base.showError(I18n.tr((String)"You forgot your sketchbook"), I18n.tr((String)"Arduino cannot run because it could not\ncreate a folder to store your sketchbook."), null);
        }
        return sketchbookFolder;
    }

    protected static File promptSketchbookLocation() {
        File folder = null;
        folder = new File(System.getProperty("user.home"), "sketchbook");
        if (!folder.exists()) {
            folder.mkdirs();
            return folder;
        }
        String prompt = I18n.tr((String)"Select (or create new) folder for sketches...");
        folder = Base.selectFolder(prompt, null, null);
        if (folder == null) {
            System.exit(0);
        }
        return folder;
    }

    public static void openURL(String url) {
        try {
            BaseNoGui.getPlatform().openURL(url);
        }
        catch (Exception e) {
            Base.showWarning(I18n.tr((String)"Problem Opening URL"), I18n.format((String)I18n.tr((String)"Could not open the URL\n{0}"), (Object[])new Object[]{url}), e);
        }
    }

    protected static boolean openFolderAvailable() {
        return BaseNoGui.getPlatform().openFolderAvailable();
    }

    public static void openFolder(File file) {
        try {
            BaseNoGui.getPlatform().openFolder(file);
        }
        catch (Exception e) {
            Base.showWarning(I18n.tr((String)"Problem Opening Folder"), I18n.format((String)I18n.tr((String)"Could not open the folder\n{0}"), (Object[])new Object[]{file.getAbsolutePath()}), e);
        }
    }

    public static File selectFolder(String prompt, File folder, Component parent) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(prompt);
        if (folder != null) {
            fc.setSelectedFile(folder);
        }
        fc.setFileSelectionMode(1);
        int returned = fc.showOpenDialog(parent);
        if (returned == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static void setIcon(Frame frame) {
        if (OSUtils.isMacOS()) {
            return;
        }
        List icons = Stream.of("16", "24", "32", "48", "64", "72", "96", "128", "256").map(res -> "/lib/icons/" + res + "x" + res + "/apps/arduino.png").map(path -> BaseNoGui.getContentFile((String)path).getAbsolutePath()).map(absPath -> Toolkit.getDefaultToolkit().createImage((String)absPath)).collect(Collectors.toList());
        frame.setIconImages(icons);
    }

    public static void registerWindowCloseKeys(JRootPane root, ActionListener disposer) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        root.registerKeyboardAction(disposer, stroke, 2);
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        stroke = KeyStroke.getKeyStroke(87, modifiers);
        root.registerKeyboardAction(disposer, stroke, 2);
    }

    public static void showReference(String filename) {
        Base.showReference("reference/www.arduino.cc/en", filename);
    }

    public static void showReference(String prefix, String filename) {
        File referenceFolder = Base.getContentFile(prefix);
        File referenceFile = new File(referenceFolder, filename);
        if (!referenceFile.exists()) {
            referenceFile = new File(referenceFolder, filename + ".html");
        }
        if (referenceFile.exists()) {
            Base.openURL(referenceFile.getAbsolutePath());
        } else {
            Base.showWarning(I18n.tr((String)"Problem Opening URL"), I18n.format((String)I18n.tr((String)"Could not open the URL\n{0}"), (Object[])new Object[]{referenceFile}), null);
        }
    }

    public static void showEdisonGettingStarted() {
        Base.showReference("reference/Edison_help_files", "ArduinoIDE_guide_edison");
    }

    public static void showArduinoGettingStarted() {
        if (OSUtils.isMacOS()) {
            Base.showReference("Guide/MacOSX");
        } else if (OSUtils.isWindows()) {
            Base.showReference("Guide/Windows");
        } else {
            Base.openURL("http://www.arduino.cc/playground/Learning/Linux");
        }
    }

    public static void showReference() {
        Base.showReference("Reference/HomePage");
    }

    public static void showEnvironment() {
        Base.showReference("Guide/Environment");
    }

    public static void showTroubleshooting() {
        Base.showReference("Guide/Troubleshooting");
    }

    public static void showFAQ() {
        Base.showReference("Main/FAQ");
    }

    public static void showMessage(String title, String message) {
        BaseNoGui.showMessage((String)title, (String)message);
    }

    public static void showWarning(String title, String message, Exception e) {
        BaseNoGui.showWarning((String)title, (String)message, (Exception)e);
    }

    public static void showError(String title, String message, Throwable e) {
        Base.showError(title, message, e, 1);
    }

    public static void showError(String title, String message, int exit_code) {
        Base.showError(title, message, null, exit_code);
    }

    public static void showError(String title, String message, Throwable e, int exit_code) {
        BaseNoGui.showError((String)title, (String)message, (Throwable)e, (int)exit_code);
    }

    public static File getContentFile(String name) {
        return BaseNoGui.getContentFile((String)name);
    }

    public static int countLines(String what) {
        return BaseNoGui.countLines((String)what);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytesRaw(File file) throws IOException {
        byte[] byArray;
        int size = (int)file.length();
        FileInputStream input = null;
        try {
            int bytesRead;
            input = new FileInputStream(file);
            byte[] buffer = new byte[size];
            int offset = 0;
            while ((bytesRead = input.read(buffer, offset, size - offset)) != -1) {
                offset += bytesRead;
                if (bytesRead != 0) continue;
            }
            byArray = buffer;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)input);
        return byArray;
    }

    public static HashMap<String, String> readSettings(File inputFile) {
        HashMap<String, String> outgoing = new HashMap<String, String>();
        if (!inputFile.exists()) {
            return outgoing;
        }
        String[] lines = PApplet.loadStrings((File)inputFile);
        for (int i = 0; i < lines.length; ++i) {
            String line;
            int hash = lines[i].indexOf(35);
            String string = line = hash == -1 ? lines[i].trim() : lines[i].substring(0, hash).trim();
            if (line.length() == 0) continue;
            int equals = line.indexOf(61);
            if (equals == -1) {
                System.err.println("ignoring illegal line in " + inputFile);
                System.err.println("  " + line);
                continue;
            }
            String attr = line.substring(0, equals).trim();
            String valu = line.substring(equals + 1).trim();
            outgoing.put(attr, valu);
        }
        return outgoing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        BufferedInputStream from = null;
        BufferedOutputStream to = null;
        try {
            int bytesRead;
            from = new BufferedInputStream(new FileInputStream(sourceFile));
            to = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] buffer = new byte[16384];
            while ((bytesRead = ((InputStream)from).read(buffer)) != -1) {
                ((OutputStream)to).write(buffer, 0, bytesRead);
            }
            ((OutputStream)to).flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(from);
            IOUtils.closeQuietly(to);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)from);
        IOUtils.closeQuietly((Closeable)to);
        targetFile.setLastModified(sourceFile.lastModified());
    }

    public static String loadFile(File file) throws IOException {
        return BaseNoGui.loadFile((File)file);
    }

    public static void saveFile(String str, File file) throws IOException {
        BaseNoGui.saveFile((String)str, (File)file);
    }

    public static int calcFolderSize(File folder) {
        int size = 0;
        String[] files = folder.list();
        if (files == null) {
            return -1;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(".") || files[i].equals("..") || files[i].equals(".DS_Store")) continue;
            File fella = new File(folder, files[i]);
            if (fella.isDirectory()) {
                size += Base.calcFolderSize(fella);
                continue;
            }
            size += (int)fella.length();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAddLibrary() {
        JFileChooser fileChooser = new JFileChooser(System.getProperty("user.home"));
        fileChooser.setDialogTitle(I18n.tr((String)"Select a zip file or a folder containing the library you'd like to add"));
        fileChooser.setFileSelectionMode(2);
        fileChooser.setFileFilter(new FileNameExtensionFilter(I18n.tr((String)"ZIP files or folders"), "zip"));
        Dimension preferredSize = fileChooser.getPreferredSize();
        fileChooser.setPreferredSize(new Dimension(preferredSize.width + 200, preferredSize.height + 200));
        int returnVal = fileChooser.showOpenDialog(this.activeEditor);
        if (returnVal != 0) {
            return;
        }
        File sourceFile = fileChooser.getSelectedFile();
        File tmpFolder = null;
        try {
            if (!sourceFile.isDirectory()) {
                try {
                    tmpFolder = FileUtils.createTempFolder();
                    ZipDeflater zipDeflater = new ZipDeflater(sourceFile, tmpFolder);
                    zipDeflater.deflate();
                    File[] foldersInTmpFolder = tmpFolder.listFiles((FilenameFilter)new OnlyDirs());
                    if (foldersInTmpFolder.length != 1) {
                        throw new IOException(I18n.tr((String)"Zip doesn't contain a library"));
                    }
                    sourceFile = foldersInTmpFolder[0];
                }
                catch (IOException e) {
                    this.activeEditor.statusError(e);
                    newLibraryImported = true;
                    FileUtils.recursiveDelete((File)tmpFolder);
                    return;
                }
            }
            File libFolder = sourceFile;
            if (FileUtils.isSubDirectory((File)new File(PreferencesData.get((String)"sketchbook.path")), (File)libFolder)) {
                this.activeEditor.statusError(I18n.tr((String)"A subfolder of your sketchbook is not a valid library"));
                return;
            }
            if (FileUtils.isSubDirectory((File)libFolder, (File)new File(PreferencesData.get((String)"sketchbook.path")))) {
                this.activeEditor.statusError(I18n.tr((String)"You can't import a folder that contains your sketchbook"));
                return;
            }
            String libName = libFolder.getName();
            if (!BaseNoGui.isSanitaryName((String)libName)) {
                String mess = I18n.format((String)I18n.tr((String)"The library \"{0}\" cannot be used.\nLibrary names must contain only basic letters and numbers.\n(ASCII only and no spaces, and it cannot start with a number)"), (Object[])new Object[]{libName});
                this.activeEditor.statusError(mess);
                return;
            }
            File libProp = new File(libFolder, "library.properties");
            File srcFolder = new File(libFolder, "src");
            String[] headers = libProp.exists() && srcFolder.isDirectory() ? BaseNoGui.headerListFromIncludePath((File)srcFolder) : BaseNoGui.headerListFromIncludePath((File)libFolder);
            if (headers.length == 0) {
                this.activeEditor.statusError(I18n.tr((String)"Specified folder/zip file does not contain a valid library"));
                return;
            }
            File destinationFolder = new File(BaseNoGui.getSketchbookLibrariesFolder().folder, sourceFile.getName());
            if (!destinationFolder.mkdir()) {
                this.activeEditor.statusError(I18n.format((String)I18n.tr((String)"A library named {0} already exists"), (Object[])new Object[]{sourceFile.getName()}));
                return;
            }
            try {
                FileUtils.copy((File)sourceFile, (File)destinationFolder);
            }
            catch (IOException e) {
                this.activeEditor.statusError(e);
                newLibraryImported = true;
                FileUtils.recursiveDelete((File)tmpFolder);
                return;
            }
            this.activeEditor.statusNotice(I18n.tr((String)"Library added to your libraries. Check \"Include library\" menu"));
        }
        catch (IOException iOException) {
        }
        finally {
            newLibraryImported = true;
            FileUtils.recursiveDelete((File)tmpFolder);
        }
    }

    public static DiscoveryManager getDiscoveryManager() {
        return BaseNoGui.getDiscoveryManager();
    }

    public Editor getActiveEditor() {
        return this.activeEditor;
    }

    public boolean hasActiveEditor() {
        return this.activeEditor != null;
    }

    public List<Editor> getEditors() {
        return new LinkedList<Editor>(this.editors);
    }

    public PdeKeywords getPdeKeywords() {
        return this.pdeKeywords;
    }

    public List<JMenuItem> getRecentSketchesMenuItems() {
        return this.recentSketchesMenuItems;
    }

    static {
        FIND_DIALOG_STATE = new HashMap<String, Object>();
    }
}

