/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.Constants;
import cc.arduino.contributions.DownloadableContributionsDownloader;
import cc.arduino.contributions.GZippedJsonDownloader;
import cc.arduino.contributions.ProgressListener;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.utils.ArchiveExtractor;
import cc.arduino.utils.MultiStepProgress;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.helpers.FileUtils;

public class LibraryInstaller {
    private final Platform platform;

    public LibraryInstaller(Platform platform) {
        this.platform = platform;
    }

    public synchronized void updateIndex(ProgressListener progressListener) throws Exception {
        MultiStepProgress progress = new MultiStepProgress(3);
        DownloadableContributionsDownloader downloader = new DownloadableContributionsDownloader(BaseNoGui.librariesIndexer.getStagingFolder());
        File outputFile = BaseNoGui.librariesIndexer.getIndexFile();
        File tmpFile = new File(outputFile.getAbsolutePath() + ".tmp");
        try {
            GZippedJsonDownloader gZippedJsonDownloader = new GZippedJsonDownloader(downloader, new URL(Constants.LIBRARY_INDEX_URL), new URL(Constants.LIBRARY_INDEX_URL_GZ));
            gZippedJsonDownloader.download(tmpFile, progress, I18n.tr("Downloading libraries index..."), progressListener);
        }
        catch (InterruptedException e) {
            return;
        }
        progress.stepDone();
        if (outputFile.exists()) {
            outputFile.delete();
        }
        if (!tmpFile.renameTo(outputFile)) {
            throw new Exception(I18n.tr("An error occurred while updating libraries index!"));
        }
        BaseNoGui.librariesIndexer.parseIndex();
        this.rescanLibraryIndex(progress, progressListener);
    }

    public synchronized void install(ContributedLibrary lib, Optional<ContributedLibrary> mayReplacedLib, ProgressListener progressListener) throws Exception {
        File tmpFolder;
        File libsFolder;
        MultiStepProgress progress;
        block6: {
            if (lib.isLibraryInstalled()) {
                System.out.println(I18n.format(I18n.tr("Library is already installed: {0}:{1}"), lib.getName(), lib.getParsedVersion()));
                return;
            }
            DownloadableContributionsDownloader downloader = new DownloadableContributionsDownloader(BaseNoGui.librariesIndexer.getStagingFolder());
            progress = new MultiStepProgress(3);
            try {
                downloader.download(lib, progress, I18n.format(I18n.tr("Downloading library: {0}"), lib.getName()), progressListener);
            }
            catch (InterruptedException e) {
                return;
            }
            progress.setStatus(I18n.format(I18n.tr("Installing library: {0}:{1}"), lib.getName(), lib.getParsedVersion()));
            progressListener.onProgress(progress);
            libsFolder = BaseNoGui.getSketchbookLibrariesFolder().folder;
            tmpFolder = FileUtils.createTempFolder(libsFolder);
            try {
                new ArchiveExtractor(this.platform).extract(lib.getDownloadedFile(), tmpFolder, 1);
            }
            catch (Exception e) {
                if (!tmpFolder.exists()) break block6;
                FileUtils.recursiveDelete(tmpFolder);
            }
        }
        progress.stepDone();
        if (mayReplacedLib.isPresent()) {
            this.remove(mayReplacedLib.get(), progressListener);
        }
        File destFolder = new File(libsFolder, lib.getName().replaceAll(" ", "_"));
        tmpFolder.renameTo(destFolder);
        progress.stepDone();
        this.rescanLibraryIndex(progress, progressListener);
    }

    public synchronized void remove(ContributedLibrary lib, ProgressListener progressListener) throws IOException {
        if (lib.isIDEBuiltIn()) {
            return;
        }
        MultiStepProgress progress = new MultiStepProgress(2);
        progress.setStatus(I18n.format(I18n.tr("Removing library: {0}:{1}"), lib.getName(), lib.getParsedVersion()));
        progressListener.onProgress(progress);
        FileUtils.recursiveDelete(lib.getInstalledLibrary().get().getInstalledFolder());
        progress.stepDone();
        this.rescanLibraryIndex(progress, progressListener);
    }

    private void rescanLibraryIndex(MultiStepProgress progress, ProgressListener progressListener) {
        progress.setStatus(I18n.tr("Updating list of installed libraries"));
        progressListener.onProgress(progress);
        BaseNoGui.librariesIndexer.rescanLibraries();
        progress.stepDone();
    }
}

