/*
 * Decompiled with CFR 0.152.
 */
package processing.app.packages;

import cc.arduino.Constants;
import cc.arduino.contributions.VersionHelper;
import cc.arduino.contributions.libraries.ContributedLibraryReference;
import com.github.zafarkhaja.semver.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import processing.app.I18n;
import processing.app.helpers.PreferencesMap;
import processing.app.packages.UserLibraryFolder;

public class UserLibrary {
    private String name;
    private String version;
    private String author;
    private String maintainer;
    private String sentence;
    private String paragraph;
    private String website;
    private String category;
    private String license;
    private List<String> architectures;
    private List<String> types = new ArrayList<String>();
    private List<String> declaredTypes;
    private boolean onGoingDevelopment;
    private List<String> includes;
    protected File installedFolder;
    protected UserLibraryFolder.Location location;
    protected LibraryLayout layout;

    public static UserLibrary create(UserLibraryFolder libFolderDesc) throws IOException {
        String declaredVersion;
        Optional<Version> version;
        String types;
        String license;
        File archFolder;
        File libFolder = libFolderDesc.folder;
        UserLibraryFolder.Location location = libFolderDesc.location;
        File propertiesFile = new File(libFolder, "library.properties");
        PreferencesMap properties = new PreferencesMap();
        properties.load(propertiesFile);
        if (!properties.containsKey("maintainer") && properties.containsKey("email")) {
            properties.put("maintainer", properties.get("email"));
        }
        if ((archFolder = new File(libFolder, "arch")).isDirectory()) {
            throw new IOException("'arch' folder is no longer supported! See http://goo.gl/gfFJzU for more information");
        }
        for (String p : Constants.LIBRARY_MANDATORY_PROPERTIES) {
            if (properties.containsKey(p)) continue;
            throw new IOException("Missing '" + p + "' from library");
        }
        File srcFolder = new File(libFolder, "src");
        LibraryLayout layout = srcFolder.exists() && srcFolder.isDirectory() ? LibraryLayout.RECURSIVE : LibraryLayout.FLAT;
        File[] files = libFolder.listFiles();
        if (files == null) {
            throw new IOException("Unable to list files of library in " + libFolder);
        }
        String architectures = (String)properties.get("architectures");
        if (architectures == null) {
            architectures = "*";
        }
        ArrayList<String> archs = new ArrayList<String>();
        for (String arch : architectures.split(",")) {
            archs.add(arch.trim());
        }
        String category = (String)properties.get("category");
        if (category == null) {
            category = "Uncategorized";
        }
        if (!Constants.LIBRARY_CATEGORIES.contains(category)) {
            category = "Uncategorized";
        }
        if ((license = (String)properties.get("license")) == null) {
            license = "Unspecified";
        }
        if ((types = (String)properties.get("types")) == null) {
            types = "Contributed";
        }
        LinkedList<String> typesList = new LinkedList<String>();
        for (String type : types.split(",")) {
            typesList.add(type.trim());
        }
        ArrayList<String> includes = null;
        if (properties.containsKey("includes") && !((String)properties.get("includes")).trim().isEmpty()) {
            includes = new ArrayList<String>();
            for (String i : ((String)properties.get("includes")).split(",")) {
                includes.add(i.trim());
            }
        }
        if (!(version = VersionHelper.valueOf(declaredVersion = ((String)properties.get("version")).trim())).isPresent()) {
            System.out.println(I18n.format(I18n.tr("Invalid version '{0}' for library in: {1}"), declaredVersion, libFolder.getAbsolutePath()));
        }
        UserLibrary res = new UserLibrary();
        res.installedFolder = libFolder;
        res.name = ((String)properties.get("name")).trim();
        res.version = version.isPresent() ? version.get().toString() : declaredVersion;
        res.author = ((String)properties.get("author")).trim();
        res.maintainer = ((String)properties.get("maintainer")).trim();
        res.sentence = ((String)properties.get("sentence")).trim();
        res.paragraph = ((String)properties.get("paragraph")).trim();
        res.website = ((String)properties.get("url")).trim();
        res.category = category.trim();
        res.license = license.trim();
        res.architectures = archs;
        res.layout = layout;
        res.declaredTypes = typesList;
        res.onGoingDevelopment = Files.exists(Paths.get(libFolder.getAbsolutePath(), ".development"), new LinkOption[0]);
        res.includes = includes;
        res.location = location;
        return res;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getArchitectures() {
        return this.architectures;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public String getSentence() {
        return this.sentence;
    }

    public String getWebsite() {
        return this.website;
    }

    public String getCategory() {
        return this.category;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public String getLicense() {
        return this.license;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public List<ContributedLibraryReference> getRequires() {
        return null;
    }

    public List<String> getDeclaredTypes() {
        return this.declaredTypes;
    }

    public boolean onGoingDevelopment() {
        return this.onGoingDevelopment;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public File getSrcFolder() {
        switch (this.layout) {
            case FLAT: {
                return this.installedFolder;
            }
            case RECURSIVE: {
                return new File(this.installedFolder, "src");
            }
        }
        return null;
    }

    public boolean useRecursion() {
        return this.layout == LibraryLayout.RECURSIVE;
    }

    public UserLibraryFolder.Location getLocation() {
        return this.location;
    }

    public boolean isIDEBuiltIn() {
        return this.getLocation() == UserLibraryFolder.Location.IDE_BUILTIN;
    }

    public String toString() {
        return this.name + ":" + this.version + " " + this.architectures + " " + (Object)((Object)this.location);
    }

    public File getInstalledFolder() {
        return this.installedFolder;
    }

    protected static enum LibraryLayout {
        FLAT,
        RECURSIVE;

    }
}

