/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries.ui;

import cc.arduino.contributions.DownloadableContributionVersionComparator;
import cc.arduino.contributions.VersionComparator;
import cc.arduino.contributions.filters.BuiltInPredicate;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.filters.OnlyUpstreamReleasePredicate;
import cc.arduino.contributions.libraries.ui.ContributedLibraryReleases;
import cc.arduino.contributions.libraries.ui.ContributedLibraryTableCellJPanel;
import cc.arduino.contributions.ui.InstallerTableCell;
import cc.arduino.utils.ReverseComparator;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComboBox;
import javax.swing.JTable;
import processing.app.I18n;

public class ContributedLibraryTableCellEditor
extends InstallerTableCell {
    private ContributedLibraryReleases editorValue;
    private ContributedLibraryTableCellJPanel editorCell;

    @Override
    public Object getCellEditorValue() {
        return this.editorValue;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editorValue = (ContributedLibraryReleases)value;
        this.editorCell = new ContributedLibraryTableCellJPanel(table, value, true);
        this.editorCell.installButton.addActionListener(e -> this.onInstall(this.editorValue.getSelected(), this.editorValue.getInstalled()));
        this.editorCell.downgradeButton.addActionListener(e -> {
            JComboBox chooser = this.editorCell.downgradeChooser;
            ContributedLibrary lib = (ContributedLibrary)chooser.getSelectedItem();
            this.onInstall(lib, this.editorValue.getInstalled());
        });
        this.editorCell.versionToInstallChooser.addItemListener(e -> this.editorValue.select((ContributedLibrary)this.editorCell.versionToInstallChooser.getSelectedItem()));
        this.setEnabled(true);
        ContributedLibrary installed = this.editorValue.getInstalled();
        List releases = this.editorValue.getReleases().stream().filter(new OnlyUpstreamReleasePredicate()).collect(Collectors.toList());
        List<ContributedLibrary> uninstalledReleases = releases.stream().filter(new InstalledPredicate().negate()).collect(Collectors.toList());
        List installedBuiltIn = releases.stream().filter(new InstalledPredicate()).filter(new BuiltInPredicate()).collect(Collectors.toList());
        if (installed != null && !installedBuiltIn.contains(installed)) {
            uninstalledReleases.addAll(installedBuiltIn);
        }
        Collections.sort(uninstalledReleases, new ReverseComparator((Comparator)new DownloadableContributionVersionComparator()));
        this.editorCell.downgradeChooser.removeAllItems();
        this.editorCell.downgradeChooser.addItem(I18n.tr((String)"Select version"));
        LinkedList uninstalledPreviousReleases = new LinkedList();
        LinkedList uninstalledNewerReleases = new LinkedList();
        VersionComparator versionComparator = new VersionComparator();
        uninstalledReleases.stream().forEach(input -> {
            if (installed == null || versionComparator.greaterThan(installed.getParsedVersion(), input.getParsedVersion())) {
                uninstalledPreviousReleases.add(input);
            } else {
                uninstalledNewerReleases.add(input);
            }
        });
        uninstalledNewerReleases.forEach(this.editorCell.downgradeChooser::addItem);
        uninstalledPreviousReleases.forEach(this.editorCell.downgradeChooser::addItem);
        this.editorCell.downgradeChooser.setVisible(installed != null && (!uninstalledPreviousReleases.isEmpty() || uninstalledNewerReleases.size() > 1));
        this.editorCell.downgradeButton.setVisible(installed != null && (!uninstalledPreviousReleases.isEmpty() || uninstalledNewerReleases.size() > 1));
        this.editorCell.versionToInstallChooser.removeAllItems();
        uninstalledReleases.forEach(this.editorCell.versionToInstallChooser::addItem);
        this.editorCell.versionToInstallChooser.setVisible(installed == null && uninstalledReleases.size() > 1);
        this.editorCell.setBackground(new Color(218, 227, 227));
        return this.editorCell;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.editorCell.setButtonsVisible(enabled);
    }

    @Override
    public void setStatus(String status) {
        this.editorCell.statusLabel.setText(status);
    }

    protected void onRemove(ContributedLibrary selected) {
    }

    protected void onInstall(ContributedLibrary selected, ContributedLibrary installed) {
    }
}

